/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import xnap.XNap;

import xnap.net.AbstractTransferContainer;
import xnap.net.IDownload;
import xnap.net.IDownloadContainer;
import xnap.net.IUser;

import xnap.plugin.gift.net.event.DownloadUpdatedEvent;
import xnap.plugin.gift.net.event.listener.DownloadEventListener;

import java.io.File;

//TODO: Dont extend AbtractTransferContainer! implement ITransferContainer instead!
/**
 * DownloadContainer
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: DownloadContainer.java,v 1.7 2003/01/19 00:46:32 taval Exp $
 */
public class DownloadContainer extends AbstractTransferContainer
    implements IDownloadContainer, DownloadEventListener {
    //~ Static fields/initializers ---------------------------------------------

    static final int STATUS_NOT_STARTED = 0;
    static final int STATUS_CONNECTING = 1;
    static final int STATUS_LOCALLY_QUEUED = 2;
    static final int STATUS_REMOTELY_QUEUED = 3;
    static final int STATUS_DOWNLOADING = 4;
    static final int STATUS_UPLOADING = 5;
    static final int STATUS_SUCCESS = 6;
    static final int STATUS_FAILED = 7;

    //int STATUS_INCOMPLETE      = 8;
    static final int STATUS_ABORTED = 9;
    static final int STATUS_SEARCHING = 10;
    static final int STATUS_WAITING = 11;
    static final int STATUS_DELETED = 12;
    static final int STATUS_ERROR = 13;
    static final int STATUS_PAUSED = 14;
    static final String[] STATUS_MSGS = {
        "", XNap.tr("connecting") + "...", XNap.tr("locally queued"),
        XNap.tr("remotelly queued"), XNap.tr("downloading") + "...",
        XNap.tr("uploading") + "...", XNap.tr("finished"), XNap.tr("failed"),
        XNap.tr("incomplete"), XNap.tr("aborted"), XNap.tr("searching") +
        "...", XNap.tr("waiting") + "...", XNap.tr("deleted"), XNap.tr("error"),
        XNap.tr("paused")
    };

    //~ Instance fields --------------------------------------------------------

    private String filename;
    private String hash;
    private long currentRate;
    private long filesize;
	private String giftState;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for DownloadContainer.
     *
     * @param filename DOCUMENT ME!
     * @param hash DOCUMENT ME!
     * @param filesize DOCUMENT ME!
     * @param transmit DOCUMENT ME!
     * @param state DOCUMENT ME!
     */
    public DownloadContainer(String filename, String hash, long filesize,
        long transmit, String state) {
        super();
        this.filename = filename;
        this.filesize = filesize;
        this.hash = hash;
        this.totalBytesTransferred = transmit;
		giftState = state;
		setStatus(wrapStatus(state));
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Wraps the giFT status response to ints
     *
     * @param state
     *
     * @return status
     */
    public int wrapStatus(String state) {
        if (state.equalsIgnoreCase("active")) {
            return STATUS_DOWNLOADING;
        } else if (state.equalsIgnoreCase("new")) {
            return STATUS_CONNECTING;
        } else if (state.equalsIgnoreCase("waiting")) {
            return STATUS_WAITING;
        } else if (state.equalsIgnoreCase("timeout")) {
            return STATUS_FAILED;
        } else if (state.equalsIgnoreCase("cancelled")) {
            return STATUS_ABORTED;
        } else if (state.equalsIgnoreCase("completed")) {
            return STATUS_SUCCESS;
        } else if (state.equalsIgnoreCase("queuedremote")) {
            return STATUS_REMOTELY_QUEUED;
        } else if (state.equalsIgnoreCase("queuedlocal")) {
            return STATUS_LOCALLY_QUEUED;
        } else if (state.equalsIgnoreCase("paused")) {
            return STATUS_PAUSED;
        } else if (state.equalsIgnoreCase("unused")) {
            return STATUS_ERROR;
        }

        return STATUS_ERROR;
    }

    /**
     * @see xnap.net.ITransferContainer#getAverageRate()
     */
    public long getAverageRate() {
        // TODO: calc av rate
        return currentRate;
    }

    /**
     * @see xnap.net.ITransferContainer#getCurrentRate()
     */
    public long getCurrentRate() {
        return currentRate;
    }

    /**
     * @see xnap.net.AbstractTransferContainer#setFile(java.io.File)
     */
    public void setFile(File newValue) {
    }

    /**
     * @see xnap.net.ITransferContainer#getFile()
     */
    public File getFile() {
        return null;
    }

    /**
     * @see xnap.net.ITransferContainer#getFilename()
     */
    public String getFilename() {
        return filename.substring(filename.lastIndexOf("/") + 1);
    }

    /**
     * @see xnap.net.ITransferContainer#getFilesize()
     */
    public long getFilesize() {
        return filesize;
    }

    /**
     * @see xnap.net.IDownloadContainer#setQueuePos(xnap.net.IDownload, int)
     */
    public void setQueuePos(IDownload d, int pos) {
        System.out.println("setqpos");
    }

    /**
     * @see xnap.net.ITransferContainer#getUser()
     */
    public IUser getUser() {
        return new User("unknown@giFT");
    }

    /**
     * @see xnap.net.ITransferContainer#abort()
     */
    public void abort() {
        super.abort();
        Engine.getInstance().changeDownload(this, "cancel");
        System.out.println("abort");
    }

    /**
     * @see xnap.net.AbstractTransferContainer#delete()
     */
    public void delete() {
        super.delete();
        System.out.println("delete");
    }

    /**
     * @see xnap.plugin.gift.net.event.listener.DownloadEventListener#downloadUpdated(xnap.plugin.gift.net.event.DownloadUpdatedEvent)
     */
    public void downloadUpdated(DownloadUpdatedEvent evt) {
        this.currentRate = evt.getThroughput();
        this.totalBytesTransferred = evt.getTransmit();
        setStatus(wrapStatus(evt.getState()));

        //System.out.println(evt + " " + this);
    }

    /**
     * @see xnap.net.ITransferContainer#fail(java.lang.String)
     */
    public void fail(String msg) {
        super.fail(msg);
        System.out.println("fail:" + msg);
    }

    /**
     * @see xnap.net.IDownloadContainer#remove(xnap.net.IDownload)
     */
    public void remove(IDownload d) {
        System.out.println("remove");
    }

    /**
     * @see java.lang.Runnable#run()
     */
    public void run() {
    }

    /**
     * @see xnap.net.IDownloadContainer#skip()
     */
    public void skip() {
        System.out.println("skip");
    }

    /**
     * @see xnap.net.IDownloadContainer#start(xnap.net.IDownload)
     */
    public void start(IDownload d) {
        System.out.println("startdl");
    }

    /**
     * @see xnap.net.ITransferContainer#start()
     */
    public void start() {
        if (!canStart()) {
            // already running
            logger.error("already running");

            return;
        }

        die = false;
        setStatus(STATUS_NOT_STARTED);
    }
	/**
	 * @see xnap.net.AbstractCommunication#getStatusMsg(int)
	 */
	public String getStatusMsg(int index) {
		return giftState;
	}

}
