/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.XNap;
import xnap.net.event.StatusChangeListener;
import xnap.user.UserData2;

public interface IUser {

    //--- Data field(s) ---

    int STATUS_UNKNOWN = 0;
    int STATUS_ONLINE = 1;
    int STATUS_AWAY = 2;
    int STATUS_OFFLINE = 3;

    String[] STATUS_MSGS = {
	"",
	XNap.tr("Online"), 
	XNap.tr("Away"), 
	XNap.tr("Offline"),
    };

    int TRANSFER_DEFAULT = -1;
    int TRANSFER_NEVER = 0;
    int TRANSFER_UNLIMITED = Integer.MAX_VALUE;

    //--- Method(s) ---

    /**
     * Adds a status listener.
     */
    void addStatusChangeListener(StatusChangeListener l);

    /**
     * Returns a new browse each time.
     */
    IBrowse getBrowse();

    String getCategory();

    /**
     * Returns the client info.
     */
    String getClientInfo();

    String getComment();

    UserData2 getData();

    /**
     * Returns the number of shared files by this user.
     */
    int getFileCount();

    /**
     * Returns the ip or hostname of this user.
     */
    String getHost();

    /**
     * Returns the link speed.
     *  
     * @see xnap.util.LinkSpeed
     */
    int getLinkSpeed();

    int getLocalDownloadCount();
    
    int getLocalUploadCount();

    int getMaxDownloads();

    int getMaxUploads();
    
    /**
     * Returns the name of the user.
     */
    String getName();

    /**
     * Returns a private chat channel to this user.
     */
    IChannel getPrivateChannel();

    int getStatus();

    String getStatusText();

    boolean isChatIgnored();

    /**
     * Returns true, if plugin supports action.
     */
    boolean isActionSupported(Class actionClass);

    boolean isTemporary();

    void modifyLocalDownloadCount(int newValue);

    void modifyLocalUploadCount(int newValue);
   
    /**
     * Remove a status listener.
     */
    void removeStatusChangeListener(StatusChangeListener l);

    void setChatIgnored(boolean newValue);

    void setCategory(String newValue);

    void setComment(String newValue);

    void setMaxDownloads(int newValue);

    void setMaxUploads(int newValue);

    void setTemporary(boolean newValue);

}
