/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.tree;

import xnap.gui.XNapFrame;

import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;

public class FileCellRenderer extends DefaultTreeCellRenderer
{

    public static final ImageIcon[] folders = {
	XNapFrame.getSmallIcon("folder.png"), 
	XNapFrame.getSmallIcon("folder_open.png"),
	XNapFrame.getSmallIcon("folder_yellow.png"),
	XNapFrame.getSmallIcon("folder_yellow_open.png")
    };

    // --- Constructor(s) ---

    public FileCellRenderer()
    {
    }

    // --- Method(s) ---

    public Component getTreeCellRendererComponent(JTree tree, Object node, 
						  boolean sel,
						  boolean expanded,
						  boolean leaf, int row, 
						  boolean hasFocus) 
    {
	super.getTreeCellRendererComponent(tree, node, sel, expanded, leaf, 
					   row, hasFocus);
	
	if (node instanceof File || (node instanceof SearchPathNode)) {
	    if (expanded) {
		setIcon(folders[1]);
	    }
	    else {
		setIcon(folders[0]);
	    }
	}
	else if (node instanceof String) {
	    if (expanded) {
		setIcon(folders[3]);
	    }
	    else {
		setIcon(folders[2]);
	    }
	}
	
	return this;
    }
    
}



