/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui.prefs;

import xnap.*;
import xnap.gui.*;
import xnap.util.SearchFilter;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class NetworkPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JCheckBox jcFirewalled;
    private JComboBox jcLinkSpeed;

    //--- Constructor(s) ---

    public NetworkPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// firewalled
	JPanel jpConnection = new JPanel(new GridBagLayout());
	jpConnection.setBorder(new TitledBorder(XNap.tr("Connection", 1)));
	JLabel jl = new JLabel
	    (XNap.tr("Check if you can not receive incoming connections."));
	GridBagHelper.add(jpConnection, jl);
	jcFirewalled = new JCheckBox(XNap.tr("Firewalled"), 
				     prefs.isFirewalled());
	GridBagHelper.add(jpConnection, jcFirewalled);

        GridBagHelper.add(this, jpConnection);

	// link speed
	JPanel jpLinkSpeed = new JPanel(new GridBagLayout());
	jpLinkSpeed.setBorder(new TitledBorder(XNap.tr("Link Type", 1)));
	GridBagHelper.add(jpLinkSpeed, XNap.tr("Set to closest match."));
	jcLinkSpeed = new JComboBox(SearchFilter.LINK_SPEEDS);
        jcLinkSpeed.setSelectedIndex(prefs.getLinkType());
        GridBagHelper.add(jpLinkSpeed, jcLinkSpeed, false);

        GridBagHelper.add(this, jpLinkSpeed);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setFirewalled(jcFirewalled.isSelected());
	prefs.setLinkType(jcLinkSpeed.getSelectedIndex());
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("network.png");
    }

    public String getTitle()
    {
	return XNap.tr("Network");
    }

}
