/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.gui.util.GUIHelper;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ConsolePrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private FontPanel fpConsole;
    private ColorPanel cpConsoleBackground;
    private ColorPanel cpConsoleForeground;

    //--- Constructor(s) ---

    public ConsolePrefsPanel()
    {
	setLayout(new GridBagLayout());

	GridBagHelper.addLabel(this, XNap.tr("Font"));
	fpConsole = new FontPanel(this, GUIHelper.getFont("console"));
	GridBagHelper.add(this, fpConsole);

	JPanel jpConsoleColors = new JPanel(new GridBagLayout());
	jpConsoleColors.setBorder
	    (new TitledBorder(XNap.tr("Colors", 1)));
	GridBagHelper.add(this, jpConsoleColors);

	GridBagHelper.addLabel(jpConsoleColors, XNap.tr("Background"));
	cpConsoleBackground 
	    = new ColorPanel(GUIHelper.getColor("consoleBackground"));
	GridBagHelper.add(jpConsoleColors, cpConsoleBackground);

	GridBagHelper.addLabel(jpConsoleColors, XNap.tr("Foreground"));
	cpConsoleForeground 
	    = new ColorPanel(GUIHelper.getColor("consoleForeground"));
	GridBagHelper.add(jpConsoleColors, cpConsoleForeground);
	
	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	GUIHelper.setFont("console", fpConsole.getSelectedFont());
	GUIHelper.setColor("consoleBackground", 
			   cpConsoleBackground.getSelectedColor());
	GUIHelper.setColor("consoleForeground", 
			   cpConsoleForeground.getSelectedColor());
    }

    public Icon getIcon()
    {
	return null;
    }

    public String getTitle()
    {
	return XNap.tr("Console");
    }

}
