/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.*;
import xnap.gui.*;
import xnap.gui.util.GUIHelper;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ChatAppearancePrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private FontPanel fpChat;
    private ColorPanel cpChatBackground;
    private ColorPanel cpChatMessage;
    private ColorPanel cpChatInfo;
    private ColorPanel cpChatError;
    private ColorPanel cpChatUser;

    //--- Constructor(s) ---

    public ChatAppearancePrefsPanel()
    {
	setLayout(new GridBagLayout());

	GridBagHelper.addLabel(this, XNap.tr("Font"));
	fpChat = new FontPanel(this, GUIHelper.getFont("chat"));
	GridBagHelper.add(this, fpChat);

	JPanel jpChatColors = new JPanel(new GridBagLayout());
	jpChatColors.setBorder
	    (new TitledBorder(XNap.tr("Colors", 1)));

	GridBagHelper.addLabel(jpChatColors, XNap.tr("Background"));
	cpChatBackground = new ColorPanel(GUIHelper.getColor("chatBackground"));
	GridBagHelper.add(jpChatColors, cpChatBackground);

	GridBagHelper.addLabel(jpChatColors, XNap.tr("Messages"));
	cpChatMessage = new ColorPanel(GUIHelper.getColor("chatMessage"));
	GridBagHelper.add(jpChatColors, cpChatMessage);

	GridBagHelper.addLabel(jpChatColors, XNap.tr("Users"));
	cpChatUser = new ColorPanel(GUIHelper.getColor("chatUser"));
	GridBagHelper.add(jpChatColors, cpChatUser);

	GridBagHelper.addLabel(jpChatColors, XNap.tr("Info"));
	cpChatInfo = new ColorPanel(GUIHelper.getColor("chatInfo"));
	GridBagHelper.add(jpChatColors, cpChatInfo);

	GridBagHelper.addLabel(jpChatColors, XNap.tr("Errors"));
	cpChatError = new ColorPanel(GUIHelper.getColor("chatError"));
	GridBagHelper.add(jpChatColors, cpChatError);

	GridBagHelper.add(this, jpChatColors);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	GUIHelper.setFont("chat", fpChat.getSelectedFont());
	GUIHelper.setColor("chatBackground", 
			   cpChatBackground.getSelectedColor());
	GUIHelper.setColor("chatMessage", cpChatMessage.getSelectedColor());
	GUIHelper.setColor("chatUser", cpChatUser.getSelectedColor());
	GUIHelper.setColor("chatInfo", cpChatInfo.getSelectedColor());
	GUIHelper.setColor("chatError", cpChatError.getSelectedColor());
    }

    public Icon getIcon()
    {
	return null;
    }

    public String getTitle()
    {
	return XNap.tr("Chat");
    }

}
