/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.action;

import xnap.XNap;
import xnap.gui.Dialogs;
import xnap.gui.XNapFrame;
import xnap.gui.event.DirectoryCollector;
import xnap.util.FileHelper;

import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * 
 */
public class PasteFileAction extends AbstractAction {
    
    //--- Constant(s) ---

    //--- Data field(s) ---

    DirectoryCollector dc;

    //--- Constructor(s) ---

    public PasteFileAction(DirectoryCollector dc) 
    {
	this.dc = dc;

	putValue(Action.NAME, XNap.tr("Paste"));
	putValue(Action.SHORT_DESCRIPTION, XNap.tr("Paste selected files."));
	putValue(Action.SMALL_ICON, XNapFrame.getIcon("editpaste.png"));

	FileActionManager.addPasteListener(this);
    }

    //--- Method(s) ---
        
    public void actionPerformed(ActionEvent event) 
    {
	File target = dc.getDirectory();
	File[] files = FileActionManager.getFiles();
	if (target != null && files != null) {
	    boolean success = false;
	    if (FileActionManager.getAction() 
		== FileActionManager.ACTION_COPY) {
		success = Dialogs.copy(files, target);
	    }
	    else if (FileActionManager.getAction() 
		     == FileActionManager.ACTION_MOVE) {
		success = Dialogs.move(files, target);
	    }

	    if (success) {
		FileActionManager.unsetFiles();
	    }
	    dc.hasChanged(target);
	}

    }
    
}
