/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.gui.action.*;
import xnap.net.IUser;

import java.awt.event.ActionEvent;
import java.util.*;
import javax.swing.*;

public class UserActionManager {

    //--- Data field(s) ---

    private static UserActionManager singleton = null;
    
    private Hashtable factoryByClass = new Hashtable();

    //--- Constructor(s) ---

    protected UserActionManager()
    {
    }
	
    //--- Method(s) ---

    public static UserActionManager getInstance()
    {
	if (singleton == null) {
	    synchronized (UserActionManager.class) {
		if (singleton == null) {
		    singleton = new UserActionManager();
		}
	    }
	}
	
	return singleton;
    }

    public AbstractAction[] getActions(IUser user)
    {
	return getActions(user.getClass(), new IUser[] { user });
    }

    /**
     * Get actions for mutiple user objects of possibly different classes. 
     */
    public AbstractAction[] getActions(IUser[] users)
    {
	Hashtable usersByClass = new Hashtable();

	for (int i = 0; i < users.length; i++) {
	    LinkedList l = (LinkedList)usersByClass.get(users[i].getClass());
	    if (l == null) {
		l = new LinkedList();
		usersByClass.put(users[i].getClass(), l);
	    }
	    l.add(users[i]);
	}

	LinkedList actions = new LinkedList();
	for (Iterator i = usersByClass.keySet().iterator(); i.hasNext();) {
	    Class c = (Class)i.next();
	    LinkedList l = (LinkedList)usersByClass.get(c);

	    IUser[] u = new IUser[l.size()];
	    System.arraycopy(l.toArray(), 0, u, 0, u.length);
	    
	    AbstractAction[] a = getActions(c, u);
	    for (int j = 0; j < a.length; j++) {
		actions.add(a[j]);
	    }
	}

	AbstractAction[] array = new AbstractAction[actions.size()];
	System.arraycopy(actions.toArray(), 0, array, 0, array.length);
	return array;
    }

    /**
     * @return always a non null array
     */
    public AbstractAction[] getActions(Class c, IUser[] u)
    {
	UserActionFactory f = (UserActionFactory)factoryByClass.get(c);
	if (f != null) {
	    AbstractAction[] a = f.create(u);
	    if (a != null) {
		return a;
	    }
	}

	return new AbstractAction[0];
    }

//      public synchronized boolean hasActions(Class c)
//      {
//  	return factoriesByClass.get(c) != null;
//      }

    public void install(Class c, UserActionFactory factory)
    {
	factoryByClass.put(c, factory);
    }

    public void uninstall(Class c)
    {
	factoryByClass.remove(c);
    }

}
