/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.*;
import xnap.io.*;
import xnap.net.*;
import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.text.*;
import javax.swing.*;
import javax.swing.border.*;
import org.apache.log4j.Logger;

public class UpdateDialog extends DefaultDialog {
    
    //--- Data field(s) ---

    private static UpdateDialog me = null;
		
    private static Logger logger = Logger.getLogger(UpdateDialog.class);
    private static Preferences prefs = Preferences.getInstance();
    private static VersionManager vm = new VersionManager();
    private JTextArea jtaText;
    private JCheckBox jcAutoVersionCheck;
    private XNapFrame exitHandler;
    private UpdateAction acUpdate = new UpdateAction();

    //--- Constructor(s) ---
    
    private UpdateDialog(XNapFrame exitHandler) 
    {
	super(BUTTON_OKAY);

	this.exitHandler = exitHandler;

	// text panel
	jtaText = new JTextArea(10, 40);
	jtaText.setEditable (false);
	jtaText.setBorder(new EmptyBorder(5, 5, 5, 5));
	jtaText.setText(vm.getInfo());
	JScrollPane jspText = new JScrollPane(jtaText);

	// update checkbox
	jcAutoVersionCheck = new JCheckBox(XNap.tr("Check for New Version"),
                                           prefs.getAutoVersionCheck());
	getButtonPanel().add(jcAutoVersionCheck, 0);

	// update button
	getButtonPanel().add(new JButton(acUpdate));

	// content
	Object[] args = { XNap.VERSION };
        setTitle(MessageFormat.format
		 (XNap.tr("New Version Available (Current Version: {0})!"), 
		  args));
	getMainPanel().setLayout(new BorderLayout());
	getMainPanel().add(jspText, BorderLayout.CENTER);
        pack();
    }

    // --- Methods ---

    public static void showDialog(final XNapFrame c, final boolean showFailed)
    {
	(new Thread("ShowUpdateDialog") 
	    {
		public void run()
		{
		    if (me == null) {
			boolean showUpdate = false;

			try {
			    showUpdate = vm.check();
			}
			catch (IOException e) {
			    logger.debug("version check failed", e);
			}

			if (!showUpdate) {
			    if (showFailed)
				JOptionPane.showMessageDialog
				    (c, 
				     XNap.tr("Sorry, no new version available."),
				     XNap.tr("Update"),
				     JOptionPane.INFORMATION_MESSAGE);
			    return;
			}

			me = new UpdateDialog(c);
			if (c != null) {
			    me.setLocationRelativeTo(c);
			}
		    }
		    
		    me.show();
		}
	    }).start();
    }

    public void apply()
    {
	prefs.setAutoVersionCheck(jcAutoVersionCheck.isSelected());
	prefs.write();
    }

    /**
     * Handles the Update button.
     */
    private class UpdateAction extends AbstractAction {

        public UpdateAction() 
	{
	    putValue(Action.NAME, XNap.tr("Update"));
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Update XNap to latest version"));
	    putValue(Action.MNEMONIC_KEY, new Integer('U'));
	}
	
        public void actionPerformed(ActionEvent event) 
	{
	    Thread t = new Thread(new UpdateRunner(), "Update");
	    t.start();
        }
	
    }

    private class UpdateRunner implements Runnable
    {
	public void run()
	{
	    // we only want one update at a time
	    acUpdate.setEnabled(false);
	    
	    File file;

	    try {
		InputStream in = vm.connect();
		Object[] args = { "xnap.jar" };
		ProgressMonitorInputStream pmin = new ProgressMonitorInputStream
		    (UpdateDialog.this, 
		     MessageFormat.format(XNap.tr("Downloading {0}"), args), in);
		in = new BufferedInputStream(pmin);

		pmin.getProgressMonitor().setMillisToPopup(0);
		pmin.getProgressMonitor().setMillisToDecideToPopup(0);

		file = vm.save(in);

		int response = JOptionPane.showConfirmDialog
		    (UpdateDialog.this, XNap.tr("Restart XNap?"), 
		     XNap.tr("New Version Installed"),
		     JOptionPane.YES_NO_OPTION);
		
		if (response == JOptionPane.YES_OPTION) {
		    XNapLoader.run(file);
		    exitHandler.doExit(false);
		}
	    }
	    catch (IOException e) {
		JOptionPane.showMessageDialog
		    (UpdateDialog.this, e.getLocalizedMessage(),
		     XNap.tr("Update Error"), JOptionPane.ERROR_MESSAGE);
	    }

	    acUpdate.setEnabled(true);
	}
    }

}

