/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.*;
import xnap.io.*;
import xnap.gui.table.*;
import xnap.gui.event.*;
import xnap.net.*;
import xnap.util.*;

import java.io.*;
import java.awt.*;
import java.beans.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.event.*;
import java.lang.Math;


public class TransferPanel extends AbstractPanel 
    implements PropertyChangeListener
{

    //--- Data field(s) ---

    private ValidatedTextField jtDlThrottle;
    private ValidatedTextField jtUlThrottle;
    private ValidatedTextField jtMaxDl;
    private ValidatedTextField jtMaxUl;

    private MyEnableAction acMaxDl;
    private MyEnableAction acMaxUl;
    private MyEnableAction acDlThrottle;
    private MyEnableAction acUlThrottle;

    private ApplyAction acApply = new ApplyAction();
    private TransferSubPanel tsp;

    //--- Constructor(s) ---

    public TransferPanel() 
    {
        initialize();

	prefs.addPropertyChangeListener(this);
    }

    //--- Method(s) ---

    private void initialize() 
    {
	// top panel
	Box boxOne = new Box(BoxLayout.X_AXIS);

	KeyStroke k = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);

	// limits
	JPanel jpLimits = new JPanel();
	jpLimits.setLayout(new BoxLayout(jpLimits, BoxLayout.X_AXIS));
	jpLimits.setBorder(new TitledBorder(XNap.tr("Limit", 1, 1)));
	
	jtMaxDl = new ValidatedTextField
	    (prefs.getMaxDownloads() + "", 5, ValidatedTextField.NUMBERS_INT);
	jtMaxDl.getInputMap().put(k, acApply);
	acMaxDl = new MyEnableAction(XNap.tr("Downloads"), 
				     new Component[] { jtMaxDl },
				     prefs.getLimitDownloads());
	jpLimits.add(acMaxDl.getCheckBox());
	jpLimits.add(jtMaxDl);

	jpLimits.add(Box.createHorizontalStrut(10));

	jtMaxUl = new ValidatedTextField
	    (prefs.getMaxUploads() + "", 5, ValidatedTextField.NUMBERS_INT);
	jtMaxUl.getInputMap().put(k, acApply);
	acMaxUl = new MyEnableAction(XNap.tr("Uploads"), 
				   new Component[] { jtMaxUl },
				   prefs.getLimitUploads());
	jpLimits.add(acMaxUl.getCheckBox());
	jpLimits.add(jtMaxUl);

	boxOne.add(jpLimits);

	// throttle
	JPanel jpThrottle = new JPanel();
	jpThrottle.setLayout(new BoxLayout(jpThrottle, BoxLayout.X_AXIS));
	jpThrottle.setBorder(new TitledBorder(XNap.tr("Throttle", 1, 1)));

	jtDlThrottle = new ValidatedTextField
	    (prefs.getDownloadThrottle() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
	jtDlThrottle.getInputMap().put(k, acApply);
	acDlThrottle = new MyEnableAction(XNap.tr("Downloads"), 
					new Component[] {jtDlThrottle},
					prefs.getThrottleDownloads());
	jpThrottle.add(acDlThrottle.getCheckBox());
	jpThrottle.add(jtDlThrottle);
	jpThrottle.add(new JLabel(XNap.tr("kb/s", 1, 1)));

	jpThrottle.add(Box.createHorizontalStrut(10));

	jtUlThrottle 
	    = new ValidatedTextField(prefs.getUploadThrottle() + "", 5, 
				     ValidatedTextField.NUMBERS_INT);
	jtUlThrottle.getInputMap().put(k, acApply);
	acUlThrottle = new MyEnableAction(XNap.tr("Uploads"), 
					new Component[] {jtUlThrottle},
					prefs.getThrottleUploads());
	jpThrottle.add(acUlThrottle.getCheckBox());
	jpThrottle.add(jtUlThrottle);
	jpThrottle.add(new JLabel(XNap.tr("kb/s", 1, 1)));

	boxOne.add(jpThrottle);

	// button
	//boxOne.add(new JButton(acApply));

//  	JPanel jpTop = new JPanel(new BorderLayout());
    	//jpTop.setBorder(new TitledBorder(XNap.tr("Settings", 1)));
//  	jpTop.add(boxOne, BorderLayout.CENTER);

	// transfer panel
	tsp = new TransferSubPanel(false, prefs.getUseTabbedTransferPane());
	tsp.setDividerLocation(prefs.getTransferDividerLocation());
	tsp.setStatusListener(this);

	/* content */
	setLayout(new BorderLayout());
	add(boxOne, BorderLayout.NORTH);
	add(tsp, BorderLayout.CENTER);
    }

    public AbstractAction[] getActions()
    {
	return tsp.getActions();
    }

    public JMenu getDownloadTableMenu()
    {
	return tsp.getDownloadTableMenu();
    }

    public JMenu getUploadTableMenu()
    {
	return tsp.getUploadTableMenu();
    }

    public void propertyChange(PropertyChangeEvent e)
    {
	String p = e.getPropertyName();

	if (p.equals("downloadThrottle")) {
	    jtDlThrottle.setText(prefs.getDownloadThrottle() + "");
	}
	else if (p.equals("limitDownloads")) {
	    acMaxDl.setSelected(prefs.getLimitDownloads());
	}
	else if (p.equals("limitUploads")) {
	    acMaxUl.setSelected(prefs.getLimitUploads());
	}
	else if (p.equals("maxDownloads")) {
	    jtMaxDl.setText(prefs.getMaxDownloads() + "");
	}	    
	else if (p.equals("maxUploads")) {
	    jtMaxUl.setText(prefs.getMaxUploads() + "");
	}	    
	else if (p.equals("throttleDownloads")) {
	    acDlThrottle.setSelected(prefs.getThrottleDownloads());
	}
	else if (p.equals("throttleUploads")) {
	    acUlThrottle.setSelected(prefs.getThrottleUploads());
	}
	else if (p.equals("uploadThrottle")) {
	    jtUlThrottle.setText(prefs.getUploadThrottle() + "");
	}
	else if (p.equals("useTabbedTransferPane")) {
	    tsp.setTabbed(prefs.getUseTabbedTransferPane());
	}
    }

    public void savePrefs()
    {
	prefs.setTransferDividerLocation(tsp.getDividerLocation());
    }

    /**
     * 
     */
    private class ApplyAction extends AbstractAction {

        public ApplyAction() 
	{
            putValue(Action.NAME, XNap.tr("Apply"));
            putValue(Action.SHORT_DESCRIPTION, XNap.tr("Apply settings"));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_A));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    prefs.setLimitDownloads(acMaxDl.isSelected());
	    prefs.setMaxDownloads(jtMaxDl.getIntValue());
	    prefs.setLimitUploads(acMaxUl.isSelected());
	    prefs.setMaxUploads(jtMaxUl.getIntValue());
	    prefs.setThrottleDownloads(acDlThrottle.isSelected());
	    prefs.setDownloadThrottle(jtDlThrottle.getIntValue());
	    prefs.setThrottleUploads(acUlThrottle.isSelected());
	    prefs.setUploadThrottle(jtUlThrottle.getIntValue());
	    
	    prefs.write();

	    setStatus(XNap.tr("Updated settings."));
	    tsp.grabFocus();
        }

    }

    private class MyEnableAction extends EnableAction {

	public MyEnableAction(String name, Component[] components, 
			      boolean selected)
	{
	    super(name, components, selected);
	}

	public void actionPerformed(ActionEvent event)
	{
	    super.actionPerformed(event);
	    acApply.actionPerformed(event);
	}

    }

}
