/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import org.apache.log4j.Logger;

public class ColorPanel extends JPanel
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    //private static Logger logger = Logger.getLogger(ColorPanel.class);

    private Color customColor = new Color(254, 254, 254);
    private JComboBox jcbColor;
    private Hashtable namesByColor = new Hashtable();

    //--- Constructor(s) ---

    public ColorPanel(Color newColor)
    {
	setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
	
	jcbColor = new JComboBox();
	jcbColor.setRenderer(new ColorCellRenderer());
	add(jcbColor);

	namesByColor.put(Color.black, XNap.tr("Black")); 
	namesByColor.put(Color.darkGray, XNap.tr("DarkGray")); 
	namesByColor.put(Color.gray, XNap.tr("Gray")); 
	namesByColor.put(Color.lightGray, XNap.tr("LightGray")); 
	namesByColor.put(Color.blue, XNap.tr("Blue")); 
	namesByColor.put(Color.cyan, XNap.tr("Cyan")); 
	namesByColor.put(Color.magenta, XNap.tr("Magenta")); 
	namesByColor.put(Color.pink, XNap.tr("Pink")); 
	namesByColor.put(Color.red, XNap.tr("Red")); 
	namesByColor.put(Color.orange, XNap.tr("Orange")); 
	namesByColor.put(Color.green, XNap.tr("Green")); 
	namesByColor.put(Color.yellow, XNap.tr("Yellow")); 
	namesByColor.put(Color.white, XNap.tr("White"));

	for (Enumeration e = namesByColor.keys(); e.hasMoreElements();) {
	    jcbColor.addItem(e.nextElement());
	}
	jcbColor.addItem(customColor);

	JButton jb = new JButton(new ColorAction());
	jb.setMargin(new Insets(1, 1, 1, 1));
	add(jb);

	setSelectedColor(newColor);
    }

    //--- Method(s) ---

    public Color getSelectedColor()
    {
	return (Color)jcbColor.getSelectedItem();
    }

    /**
     * Makes sure that color is always != null.
     */
    public void setSelectedColor(Color newValue)
    {
	if (namesByColor.get(newValue) != null) {
	    jcbColor.setSelectedItem(newValue);
	}
	else {
	    jcbColor.removeItem(customColor);
	    customColor = newValue;
	    jcbColor.addItem(customColor);
	    jcbColor.setSelectedItem(customColor);
	}
    }

    /**
     * 
     */
    private class ColorAction extends AbstractAction {

        public ColorAction() 
	{
            putValue(Action.SHORT_DESCRIPTION, 
		     XNap.tr("Opens color selection dialog."));
	    putValue(Action.SMALL_ICON, 
		     XNapFrame.getSmallIcon("palette_color.png"));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_O));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    Color c = JColorChooser.showDialog(ColorPanel.this, 
					       XNap.tr("Choose color"),
					       getSelectedColor());
	    if (c != null) {
		setSelectedColor(c);
	    }
	}

    }

    protected class ColorCellRenderer extends DefaultListCellRenderer {

	public ColorIcon icon = new ColorIcon(Color.white);

	public Component getListCellRendererComponent
	    (JList list, Object val, int idx, boolean isSel, boolean hasFocus) 
	{
	    super.getListCellRendererComponent
		(list, val, idx, isSel, hasFocus);

	    String colorName = (String)namesByColor.get(val);
	    if (colorName == null) {
		colorName = XNap.tr("Custom");
	    }
	    setText(colorName);
	    icon.setColor((Color)val);
	    setIcon(icon);

	    return this;
	}
    }

    /**
     * the idea for this class stems from limewire's CancelSearchIconProxy
     * class, thanks for going open source guys.
     */
    protected class ColorIcon implements Icon
    {

	//--- Data field(s) ---

	private int height = 15;
	private int width = 15;
	private Color color;

	//--- Constructor(s) ---
	
	public ColorIcon(Color color)
	{
	    this.color = color;
	}
	
	//--- Method(s) ---

	public int getIconHeight()
	{
	    return height;
	}

	public int getIconWidth()
	{
	    return width;
	}

	public void setColor(Color newValue)
	{
	    this.color = newValue;
	}
	
	public void paintIcon(Component c, Graphics g, int x, int y)
	{
	    g.setColor(Color.black);
	    g.drawRect(x, y, width, height);
	    g.setColor(color);
	    g.fillRect(x + 1, y + 1, width - 1, height - 1);
	}    

    }
    
}

