/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class SyncKeys {

    /**
     * 
     */
    public static void main(String[] argv)
    {
	if (argv.length < 2) {
	    System.err.println("usage: SyncKeys syncfile file [file...]");
	    System.exit(1);
	}

	Hashtable table = null;
	try {
	    System.out.println("Using Sync table: " + argv[0]);
	    table = Helper.readI18nFile(argv[0], true);
	}
	catch (IOException e) {
	    System.err.println("Error: " + e.getMessage());
	    System.exit(1);
	}

	for (int i = 1; i < argv.length; i++) {
	    try {
		System.out.println("Syncing keys in file: " + argv[i]);
		sync(argv[i], table);
	    }
	    catch (IOException e) {
		System.err.println("Error: " + e.getMessage());
	    }
	}
    }

    public static void sync(String filename, Hashtable table) throws IOException
    {
	Hashtable fileTable = Helper.readI18nFile(filename, false);

	for (Iterator i = table.keySet().iterator(); i.hasNext();) {
	    String oldKey = (String)i.next();
	    String newKey = (String)table.get(oldKey);
	   
	    if (!oldKey.equals(newKey)) {
		String value = (String)fileTable.get(oldKey);
		if (value != null) {
		    System.out.println(oldKey + " -> " + newKey + " = " + value);
		    fileTable.remove(oldKey);
		    fileTable.put(newKey, value);
		}
	    }
	}

	Helper.writeI18nFile(filename, fileTable);
    }
		
}

    
