/*
 *  JikesWrapper
 *
 *  A wrapper to use jikes incremental mode with Emacs.
 *
 *  Copyright by Steffen Pingel.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

import java.io.*;
import java.net.*;
import java.util.*;

public class JikesWrapper
{

    //--- Constant(s) ---

    public static final int SERVER_PORT = 10000;

    //--- Data field(s) ---

    protected Object lock = new Object();

    //--- Constructor(s) ---

    public JikesWrapper(String[] argv)
    {
	Socket socket = null;
	try {
	    socket = new Socket("127.0.0.1", SERVER_PORT);
	    runJikes(socket);
	}
	catch (IOException e) {
	    DaemonRunner d = new DaemonRunner(argv);
	    Thread t = new Thread(d);
	    t.setDaemon(false);
	    t.start();
	}
    }

    //--- Method(s) ---

    public void runJikes(Socket socket)
    {
	try {
	    BufferedReader in = new BufferedReader
		(new InputStreamReader(socket.getInputStream()));
	    
	    BufferedWriter out = new BufferedWriter
		(new OutputStreamWriter(socket.getOutputStream()));
	    
	    out.write("\n");
	    out.flush();
	    
	    String s;
	    while ((s = in.readLine()) != null) {
		System.out.println(s);
		if (s.startsWith("Incremental:")) {
		    System.exit(0);
		}
	    }
	}
	catch (Exception e) {
	    System.exit(1);
	}
    }

    public static void main(String[] argv) 
    {
	if (argv.length == 0) {
	    System.err.println("usage: java JikesWrapper jikes args");
	}

	JikesWrapper jw = new JikesWrapper(argv);
    }

    //--- Inner Class(es) ---

    public class DaemonRunner implements Runnable
    {

	String[] args;

	public DaemonRunner(String[] args)
	{
	    this.args = args;
	}

	public void run()
	{
	    Process process = null;
	    ServerSocket server = null;

	    try {
		// start jikes
		process = Runtime.getRuntime().exec(args);
	    }
	    catch (IOException e) {
		System.err.println(e.getMessage());
		System.exit(1);
	    }

	    try {
		server = new ServerSocket(SERVER_PORT);
	    }
	    catch (IOException e) {
		System.err.println(e.getMessage());
		System.exit(1);
	    }
		
	    while (true) {
		System.out.println("waiting for connectionn");
		try {
		    Socket socket = server.accept();

		    synchronized (lock) {
			startWriter(process.getInputStream(),
				    socket.getOutputStream());
			startWriter(process.getErrorStream(),
				    socket.getOutputStream());
			startWriter(socket.getInputStream(),
				    process.getOutputStream());

			try {
			    lock.wait();
			}
			catch (InterruptedException ine) {
			}
		    }
		}
		catch (IOException e) {
		}
	    }
	}

	public void startWriter(InputStream in, OutputStream out)
	{
	    Writer w = new Writer(in, out);
	    Thread t = new Thread(w);
	    t.start();
	}
	
    }

    public class Writer implements Runnable
    {

	protected InputStream inStream;
	protected OutputStream outStream;

	public Writer(InputStream inStream, OutputStream outStream)
	{
	    this.inStream = inStream;
	    this.outStream = outStream;
	}
    
	public void run()
	{
	    try {
		BufferedReader in = new BufferedReader
		    (new InputStreamReader(inStream));
		
		BufferedWriter out = new BufferedWriter
		    (new OutputStreamWriter(outStream));

		String s;
		while ((s = in.readLine()) != null) {
		    System.out.println("read: " + s);

		    out.write(s);
		    out.write("\n");
		    out.flush();
		}
	    }
	    catch (IOException e) {
	    }

	    synchronized (lock) {
		lock.notifyAll();
	    }
	}

    }

}
