/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class ConvertResource {

    /**
     * usage: ConvertResource source toconvert
     */
    public static void main(String[] argv)
    {
	if (argv.length < 2) {
	    System.err.println("usage: ConvertResource source translation");
	    System.exit(1);
	}

	try {
	    convert(argv[0], argv[1]);
	}
	catch (IOException e) {
	    System.err.println("Error: " + e.getMessage());
	    System.exit(1);
	}
	
	System.out.println(argv[0] + " -> " + argv[1]);
    }

    public static void convert(String sourceFilename, String transFilename)
	throws IOException
    {
	Properties sources = new Properties();
	Properties translations = new Properties();
	Properties dests = new Properties();

	load(sourceFilename, sources);
	load(transFilename, translations);
	

	for (Enumeration e = sources.keys(); e.hasMoreElements();) {
	    Object key = e.nextElement();

	    Object newKey = sources.get(key);
	    Object translation = translations.get(key);
	    
	    if (translation != null) {
		dests.put(newKey, translation);
	    }
	}

	store(transFilename, dests);
    }

    public static void load(String filename, Properties props) 
	throws IOException
    {
	FileInputStream in = new FileInputStream(new File(filename));
	props.load(in);
	in.close();
    }

    public static void store(String filename, Properties props) 
	throws IOException
    {
	FileOutputStream out = new FileOutputStream(new File(filename));
	props.store(out, "Generated by ConvertResource.");
	out.close();
    }

}
