/*
   Copyright (C) 1997-2001 Id Software, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

// gs_weapons.c	-	game shared weapons definitions

#include "../game/q_shared.h"
#include "gs_public.h"

//============================================================================

//=================
// GS_Weaponstate_Run
//=================
int GS_Weaponstate_Run( weapon_state_t *state, unsigned int msec, firedef_t *firedef, qboolean pressing_fire )
{
	int actions = 0;

	// we go below zero for one call, but reset back to after that
	// the purpose of this, is to make it not matter in what intervals this function is called
	state->nexttime -= msec;
	if( state->nexttime < 0 )
		state->nexttime = 0;

	// remove reload wait
	if( state->status == WEAPON_RELOADING && state->nexttime <= 0 )
	{
		if( firedef->cooldown_time )
		{
			state->status = WEAPON_COOLDOWN;
			state->nexttime += firedef->cooldown_time;
			actions |= WEAPON_ACTION_STATE_CHANGE;
		}
		else
		{
			state->status = WEAPON_READY;
			actions |= WEAPON_ACTION_STATE_CHANGE;
		}
	}

	// remove cooldown wait
	if( state->status == WEAPON_COOLDOWN && state->nexttime <= 0 )
	{
		state->status = WEAPON_READY;
		actions |= WEAPON_ACTION_STATE_CHANGE;
	}

	// change weapon init
	if( state->changing && ( state->status == WEAPON_READY || state->status == WEAPON_ACTIVATING )
	    && state->nexttime <= 0 )
	{
		state->status = WEAPON_DROPPING;
		state->nexttime += firedef->weapondown_time;
		actions |= WEAPON_ACTION_STATE_CHANGE;
	}

	//change weapon do
	if( state->status == WEAPON_DROPPING && state->nexttime <= 0 )
	{
		actions |= WEAPON_ACTION_WEAPON_CHANGE;
		state->changing = qfalse;
		state->status = WEAPON_ACTIVATING;
		state->nexttime += firedef->weaponup_time;
		actions |= WEAPON_ACTION_STATE_CHANGE;
		return actions; //FIXME: this one MUST return to refresh the fire function pointers after weapon change
	}

	// change weapon changed
	if( state->status == WEAPON_ACTIVATING && state->nexttime <= 0 )
	{
		state->status = WEAPON_READY;
		actions |= WEAPON_ACTION_STATE_CHANGE;
	}

	//check for firing
	if( pressing_fire && state->status == WEAPON_READY && state->nexttime <= 0 )
	{
		state->status = WEAPON_FIRING;
		actions |= WEAPON_ACTION_STATE_CHANGE;
	}

	// must fire a projectile? (never leave from here with WEAPON_FIRING state, or having power)
	// note: power is removed after calling the fire function, so it's value can be used in it
	if( state->status == WEAPON_FIRING )
	{
		actions |= WEAPON_ACTION_FIRE;
		state->status = WEAPON_RELOADING;
		actions |= WEAPON_ACTION_STATE_CHANGE;
		state->nexttime += firedef->reload_time;
	}

	return actions;
}
