/* $Id: QIStatusBarIndicator.cpp $ */
/** @file
 * VBox Qt GUI - QIStatusBarIndicator interface implementation.
 */

/*
 * Copyright (C) 2006-2014 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifdef VBOX_WITH_PRECOMPILED_HEADERS
# include <precomp.h>
#else  /* !VBOX_WITH_PRECOMPILED_HEADERS */

/* Qt includes: */
# include <QIcon>
# include <QPainter>
# include <QHBoxLayout>
# include <QApplication>
# include <QStyle>
# include <QLabel>
# ifdef Q_WS_MAC
#  include <QContextMenuEvent>
# endif /* Q_WS_MAC */

/* GUI includes: */
# include "QIStatusBarIndicator.h"

#endif /* !VBOX_WITH_PRECOMPILED_HEADERS */



QIStatusBarIndicator::QIStatusBarIndicator(QWidget *pParent /* = 0 */)
    : QWidget(pParent)
{
    /* Configure size-policy: */
    setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
}

#ifdef Q_WS_MAC
void QIStatusBarIndicator::mousePressEvent(QMouseEvent *pEvent)
{
    /* Do this for the left mouse button event only, cause in the case of the
     * right mouse button it could happen that the context menu event is
     * triggered twice. Also this isn't necessary for the middle mouse button
     * which would be some kind of overstated. */
    if (pEvent->button() == Qt::LeftButton)
    {
        QContextMenuEvent cme(QContextMenuEvent::Mouse, pEvent->pos(), pEvent->globalPos());
        emit sigContextMenuRequest(this, &cme);
        if (cme.isAccepted())
            pEvent->accept();
        else
            QWidget::mousePressEvent(pEvent);
    }
    else
        QWidget::mousePressEvent(pEvent);
}
#endif /* Q_WS_MAC */

void QIStatusBarIndicator::mouseDoubleClickEvent(QMouseEvent *pEvent)
{
    emit sigMouseDoubleClick(this, pEvent);
}

void QIStatusBarIndicator::contextMenuEvent(QContextMenuEvent *pEvent)
{
    emit sigContextMenuRequest(this, pEvent);
}


QIStateStatusBarIndicator::QIStateStatusBarIndicator(QWidget *pParent /* = 0 */)
  : QIStatusBarIndicator(pParent)
  , m_iState(0)
{
}

QIcon QIStateStatusBarIndicator::stateIcon(int iState) const
{
    /* Check if state-icon was set before: */
    return m_icons.value(iState, QIcon());
}

void QIStateStatusBarIndicator::setStateIcon(int iState, const QIcon &icon)
{
    /* Adjust size-hint: */
    const QStyle *pStyle = QApplication::style();
    const int iIconMetric = pStyle->pixelMetric(QStyle::PM_SmallIconSize);
    m_size = QSize(iIconMetric, iIconMetric);
    /* Cache passed-icon: */
    m_icons[iState] = icon;
}

void QIStateStatusBarIndicator::paintEvent(QPaintEvent*)
{
    QPainter painter(this);
    drawContents(&painter);
}

void QIStateStatusBarIndicator::drawContents(QPainter *pPainter)
{
    if (m_icons.contains(m_iState))
        pPainter->drawPixmap(contentsRect().topLeft(), m_icons.value(m_iState).pixmap(m_size));
}


QITextStatusBarIndicator::QITextStatusBarIndicator(QWidget *pParent /* = 0 */)
    : QIStatusBarIndicator(pParent)
{
    /* Create main-layout: */
    QHBoxLayout *pMainLayout = new QHBoxLayout(this);
    if (pMainLayout)
    {
        /* Configure main-layout: */
        pMainLayout->setContentsMargins(0, 0, 0, 0);
        pMainLayout->setSpacing(0);
        /* Crete label: */
        m_pLabel = new QLabel;
        if (m_pLabel)
        {
            /* Add label into main-layout: */
            pMainLayout->addWidget(m_pLabel);
        }
    }
}

QString QITextStatusBarIndicator::text() const
{
    return m_pLabel->text();
}

void QITextStatusBarIndicator::setText(const QString &strText)
{
    m_pLabel->setText(strText);
}

