#!/bin/sh
#
# gensvnversion.sh - svnversion.h generator script
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>

svnrevision=`$1 $2`

# a mixed range revision with local modifications may give output like this:
# 4123:4168MSP
# split only the right (highest) revision from it
svnrevisionnr=`echo $svnrevision | sed 's/[0-9]*:\([0-9]*\).*/\1/'`

echo "/*"
echo " * svnversion.h - SVN revision defines."
echo " *"
echo " * Autogenerated by gensvnversion.sh, DO NOT EDIT !!!"
echo " *"
echo " * Written by"
echo " *  Marco van den Heuvel <blackystardust68@yahoo.com>"
echo " *"
echo " * This file is part of VICE, the Versatile Commodore Emulator."
echo " * See README for copyright notice."
echo " *"
echo " *  This program is free software; you can redistribute it and/or modify"
echo " *  it under the terms of the GNU General Public License as published by"
echo " *  the Free Software Foundation; either version 2 of the License, or"
echo " *  (at your option) any later version."
echo " *"
echo " *  This program is distributed in the hope that it will be useful,"
echo " *  but WITHOUT ANY WARRANTY; without even the implied warranty of"
echo " *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
echo " *  GNU General Public License for more details."
echo " *"
echo " *  You should have received a copy of the GNU General Public License"
echo " *  along with this program; if not, write to the Free Software"
echo " *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA"
echo " *  02111-1307  USA."
echo " *"
echo " */"
echo ""
echo "#ifndef VICE_SVNVERSION_H"
echo "#define VICE_SVNVERSION_H"
echo ""
echo "#define VICE_SVN_REV_NUMBER $svnrevisionnr"
echo "#define VICE_SVN_REV_STRING \"$svnrevision\""
echo ""
echo "#endif"
