/*
 * vic20click.h - Volume change sample for sound emulation
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _VIC20CLICK_H
#define _VIC20CLICK_H

#define VIC20CLICK_LEN 5892

static unsigned short vic20click[] =
{
    0x002a,0x017a,0x030f,0x043e,0x052d,0x05da,0x0665,0x06cc,
    0x071d,0x0758,0x0787,0x07aa,0x07c7,0x07d8,0x07e9,0x07f0,
    0x07f7,0x07fd,0x07fe,0x0800,0x07fd,0x07fa,0x07f8,0x07f3,
    0x07f1,0x07ed,0x07e9,0x07e5,0x07e0,0x07dd,0x07da,0x07d8,
    0x07d3,0x07cf,0x07ca,0x07c5,0x07c3,0x07be,0x07b9,0x07b3,
    0x07ac,0x07a8,0x07a2,0x079e,0x079a,0x0795,0x0792,0x078b,
    0x0787,0x0782,0x077f,0x0779,0x0774,0x076e,0x076b,0x0764,
    0x0760,0x075c,0x0757,0x0752,0x074d,0x074a,0x0743,0x0740,
    0x073b,0x0738,0x0732,0x072c,0x0728,0x0723,0x071d,0x0719,
    0x0715,0x0711,0x070b,0x0708,0x0703,0x06fe,0x06f9,0x06f5,
    0x06f2,0x06ec,0x06e8,0x06e1,0x06de,0x06d7,0x06d5,0x06ce,
    0x06cc,0x06c6,0x06c3,0x06bf,0x06ba,0x06b5,0x06b0,0x06af,
    0x06a8,0x06a6,0x069e,0x069a,0x0696,0x068f,0x068c,0x0688,
    0x0683,0x0680,0x067b,0x0677,0x0673,0x066e,0x066a,0x0666,
    0x0662,0x065c,0x0659,0x0652,0x064f,0x064b,0x0646,0x0642,
    0x063e,0x0639,0x0635,0x0632,0x062c,0x062a,0x0625,0x0621,
    0x061d,0x0618,0x0613,0x060f,0x0608,0x0605,0x05ff,0x05fb,
    0x05f5,0x05f3,0x05ed,0x05e9,0x05e7,0x05e1,0x05df,0x05da,
    0x05d5,0x05d1,0x05cc,0x05c8,0x05c6,0x05c0,0x05bd,0x05b9,
    0x05b5,0x05b3,0x05ad,0x05aa,0x05a6,0x059f,0x059d,0x0599,
    0x0594,0x0590,0x058d,0x0589,0x0585,0x0584,0x057f,0x057b,
    0x0577,0x0571,0x056f,0x0568,0x0568,0x0562,0x055e,0x055b,
    0x0559,0x0554,0x054f,0x054d,0x0548,0x0544,0x0541,0x053d,
    0x0539,0x0536,0x0532,0x052e,0x052a,0x0525,0x0523,0x051f,
    0x051b,0x0518,0x0514,0x0510,0x050c,0x0509,0x0505,0x0500,
    0x04fe,0x04f9,0x04f6,0x04f2,0x04ee,0x04ea,0x04e7,0x04e4,
    0x04e0,0x04dd,0x04d9,0x04d6,0x04d1,0x04cf,0x04ca,0x04c7,
    0x04c4,0x04c0,0x04bc,0x04b9,0x04b7,0x04b2,0x04b0,0x04ac,
    0x04a9,0x04a4,0x04a1,0x049e,0x0498,0x0498,0x0493,0x0490,
    0x048d,0x0489,0x0486,0x0482,0x047d,0x047b,0x0479,0x0473,
    0x0471,0x046d,0x046b,0x0468,0x0465,0x0460,0x045e,0x045a,
    0x0457,0x0452,0x044e,0x044c,0x0448,0x0447,0x0442,0x043f,
    0x043a,0x043a,0x0434,0x0432,0x042e,0x042b,0x0427,0x0425,
    0x0422,0x041e,0x041d,0x0418,0x0415,0x0412,0x040f,0x040c,
    0x0407,0x0405,0x0402,0x03fd,0x03fc,0x03f7,0x03f5,0x03f0,
    0x03ef,0x03eb,0x03e7,0x03e6,0x03e1,0x03de,0x03dc,0x03d9,
    0x03d6,0x03d4,0x03cf,0x03cc,0x03ca,0x03c6,0x03c4,0x03c0,
    0x03bc,0x03bb,0x03b6,0x03b4,0x03b1,0x03b0,0x03aa,0x03a8,
    0x03a4,0x03a4,0x039d,0x039c,0x039a,0x0396,0x0394,0x0390,
    0x038f,0x038b,0x0388,0x0384,0x0382,0x037d,0x037b,0x0378,
    0x0375,0x0374,0x0370,0x036d,0x0369,0x0368,0x0363,0x0361,
    0x035d,0x035b,0x0359,0x0356,0x0352,0x0351,0x034e,0x034a,
    0x0349,0x0345,0x0341,0x0340,0x033b,0x033a,0x0336,0x0334,
    0x0331,0x032e,0x032b,0x0329,0x0327,0x0323,0x0321,0x031e,
    0x031a,0x0319,0x0316,0x0314,0x0312,0x030f,0x030c,0x030b,
    0x0306,0x0305,0x0301,0x02fe,0x02fd,0x02f9,0x02f8,0x02f3,
    0x02f1,0x02ef,0x02ed,0x02e9,0x02e7,0x02e2,0x02e1,0x02de,
    0x02dd,0x02d9,0x02d7,0x02d6,0x02d1,0x02d0,0x02cc,0x02c9,
    0x02c8,0x02c5,0x02c2,0x02c0,0x02be,0x02bb,0x02b8,0x02b6,
    0x02b4,0x02b0,0x02ae,0x02ab,0x02aa,0x02a6,0x02a5,0x02a3,
    0x02a0,0x029e,0x029c,0x0297,0x0297,0x0293,0x0292,0x028e,
    0x028c,0x028a,0x0286,0x0286,0x0281,0x0280,0x027e,0x027b,
    0x0278,0x0277,0x0273,0x0271,0x026f,0x026d,0x026b,0x0268,
    0x0266,0x0265,0x0261,0x025f,0x025c,0x025a,0x0258,0x0254,
    0x0253,0x0251,0x024e,0x024b,0x0249,0x0247,0x0244,0x0242,
    0x023f,0x023d,0x023a,0x023a,0x0237,0x0236,0x0233,0x0230,
    0x022f,0x022b,0x022a,0x0227,0x0224,0x0223,0x0220,0x021f,
    0x021b,0x021a,0x0216,0x0216,0x0213,0x0212,0x020e,0x020c,
    0x020a,0x0207,0x0206,0x0204,0x0201,0x0200,0x01fd,0x01fa,
    0x01f9,0x01f6,0x01f4,0x01f1,0x01ef,0x01ef,0x01eb,0x01e8,
    0x01e8,0x01e5,0x01e1,0x01e1,0x01de,0x01db,0x01d9,0x01d7,
    0x01d5,0x01d5,0x01d2,0x01cf,0x01ce,0x01cb,0x01c8,0x01c7,
    0x01c5,0x01c3,0x01c0,0x01c0,0x01be,0x01bb,0x01ba,0x01b6,
    0x01b6,0x01b3,0x01b3,0x01b0,0x01ae,0x01ab,0x01ab,0x01a8,
    0x01a6,0x01a5,0x01a3,0x01a1,0x019e,0x019e,0x019a,0x0198,
    0x0197,0x0195,0x0194,0x0191,0x0190,0x018d,0x018b,0x018b,
    0x0187,0x0187,0x0183,0x0182,0x0180,0x017f,0x017e,0x017c,
    0x0179,0x0178,0x0175,0x0174,0x0172,0x0170,0x016d,0x016c,
    0x016b,0x0168,0x0166,0x0166,0x0162,0x0162,0x0160,0x015d,
    0x015c,0x0159,0x0158,0x0155,0x0156,0x0153,0x0151,0x0150,
    0x014f,0x014b,0x014a,0x0149,0x0146,0x0145,0x0144,0x0142,
    0x0140,0x013e,0x013c,0x013b,0x0139,0x0136,0x0136,0x0133,
    0x0131,0x0132,0x012f,0x012d,0x012b,0x012b,0x0128,0x0127,
    0x0124,0x0123,0x0121,0x0120,0x011d,0x011d,0x011a,0x011a,
    0x0117,0x0115,0x0114,0x0111,0x0111,0x010e,0x010c,0x010a,
    0x010c,0x0108,0x0108,0x0105,0x0104,0x0102,0x0100,0x00fe,
    0x00fe,0x00fb,0x00f9,0x00fa,0x00f6,0x00f6,0x00f3,0x00f1,
    0x00f1,0x00ee,0x00ec,0x00ec,0x00e8,0x00e8,0x00e7,0x00e4,
    0x00e5,0x00e2,0x00e1,0x00df,0x00df,0x00db,0x00db,0x00d8,
    0x00d7,0x00d7,0x00d3,0x00d4,0x00d3,0x00cf,0x00ce,0x00ce,
    0x00ca,0x00ca,0x00c7,0x00c7,0x00c5,0x00c5,0x00c4,0x00c3,
    0x00c1,0x00c0,0x00bf,0x00bd,0x00bd,0x00ba,0x00bb,0x00b7,
    0x00b8,0x00b4,0x00b4,0x00b3,0x00b0,0x00b0,0x00ad,0x00ad,
    0x00ac,0x00a9,0x00a9,0x00a8,0x00a5,0x00a4,0x00a3,0x00a1,
    0x00a0,0x009f,0x009c,0x009c,0x009a,0x0099,0x0097,0x0097,
    0x0095,0x0094,0x0092,0x0091,0x008f,0x008e,0x008d,0x008b,
    0x008b,0x0088,0x0088,0x0086,0x0085,0x0083,0x0081,0x0081,
    0x007f,0x007e,0x007d,0x007b,0x0078,0x007a,0x0076,0x0075,
    0x0074,0x0073,0x0072,0x0070,0x006f,0x006d,0x006e,0x006b,
    0x006a,0x0068,0x0068,0x0067,0x0063,0x0065,0x0061,0x0062,
    0x0060,0x005e,0x005e,0x005d,0x005b,0x005a,0x0059,0x0057,
    0x0057,0x0054,0x0054,0x0053,0x0052,0x004f,0x0051,0x004e,
    0x004d,0x004c,0x004a,0x0049,0x0048,0x0047,0x0047,0x0044,
    0x0044,0x0044,0x0041,0x0041,0x003f,0x003e,0x003d,0x003a,
    0x003c,0x0038,0x0038,0x0037,0x0036,0x0034,0x0034,0x0032,
    0x0032,0x002f,0x0030,0x002e,0x002c,0x002c,0x0029,0x0029,
    0x0028,0x0028,0x0026,0x0025,0x0025,0x0022,0x0023,0x0020,
    0x001f,0x001e,0x001d,0x001d,0x001a,0x001b,0x0018,0x0019,
    0x0016,0x0016,0x0014,0x0013,0x0013,0x0011,0x0010,0x0010,
    0x000e,0x000d,0x000d,0x000a,0x000b,0x000a,0x0008,0x0006,
    0x0006,0x0006,0x0002,0x0003,0x0001,0x0001,0x0000,0xffff,
    0xffff,0xfffd,0xfffc,0xfffb,0xfffb,0xfff9,0xfff9,0xfff7,
    0xfff4,0xfff7,0xfff3,0xfff4,0xfff2,0xfff1,0xfff1,0xffef,
    0xffee,0xffee,0xffed,0xffeb,0xffea,0xffea,0xffe8,0xffe7,
    0xffe7,0xffe6,0xffe5,0xffe3,0xffe4,0xffe1,0xffe1,0xffe1,
    0xffde,0xffdf,0xffdd,0xffdc,0xffdc,0xffdb,0xffd9,0xffd8,
    0xffd7,0xffd7,0xffd5,0xffd4,0xffd4,0xffd3,0xffd1,0xffd0,
    0xffd0,0xffcf,0xffce,0xffce,0xffcb,0xffcb,0xffc9,0xffc7,
    0xffc7,0xffc5,0xffc3,0xffc1,0xffc1,0xffbf,0xffbe,0xffbe,
    0xffbd,0xffbc,0xffba,0xffba,0xffb9,0xffb7,0xffb7,0xffb7,
    0xffb4,0xffb3,0xffb4,0xffb3,0xffb1,0xffb3,0xffb1,0xffb1,
    0xffaf,0xffaf,0xffaf,0xffad,0xffab,0xffab,0xffab,0xffaa,
    0xffa9,0xffa8,0xffa7,0xffa7,0xffa7,0xffa4,0xffa5,0xffa3,
    0xffa2,0xffa3,0xffa2,0xffa2,0xffa1,0xffa0,0xff9f,0xff9f,
    0xff9d,0xff9d,0xff9e,0xff9b,0xff9b,0xff9c,0xff99,0xff99,
    0xff97,0xff97,0xff97,0xff95,0xff95,0xff94,0xff93,0xff91,
    0xff92,0xff91,0xff8f,0xff8f,0xff8e,0xff8e,0xff8c,0xff8c,
    0xff8b,0xff89,0xff8a,0xff88,0xff88,0xff87,0xff87,0xff85,
    0xff86,0xff84,0xff83,0xff83,0xff83,0xff81,0xff82,0xff81,
    0xff80,0xff81,0xff7e,0xff7f,0xff7e,0xff7d,0xff7c,0xff7c,
    0xff7b,0xff7b,0xff79,0xff7a,0xff78,0xff77,0xff76,0xff77,
    0xff74,0xff75,0xff73,0xff73,0xff73,0xff72,0xff73,0xff6f,
    0xff72,0xff70,0xff6e,0xff6f,0xff6d,0xff6d,0xff6b,0xff6b,
    0xff6b,0xff6b,0xff69,0xff69,0xff68,0xff68,0xff67,0xff66,
    0xff66,0xff65,0xff63,0xff63,0xff64,0xff64,0xff62,0xff62,
    0xff62,0xff60,0xff60,0xff5e,0xff5e,0xff5d,0xff5e,0xff5d,
    0xff5b,0xff5c,0xff5a,0xff5a,0xff5a,0xff58,0xff58,0xff56,
    0xff57,0xff56,0xff56,0xff55,0xff55,0xff54,0xff54,0xff53,
    0xff52,0xff53,0xff50,0xff51,0xff4f,0xff50,0xff4f,0xff4e,
    0xff4e,0xff4d,0xff4d,0xff4b,0xff4b,0xff4a,0xff49,0xff49,
    0xff4a,0xff49,0xff49,0xff49,0xff47,0xff47,0xff46,0xff45,
    0xff46,0xff42,0xff45,0xff43,0xff43,0xff41,0xff41,0xff40,
    0xff40,0xff3f,0xff3f,0xff3f,0xff3d,0xff3e,0xff3c,0xff3d,
    0xff3c,0xff3c,0xff3c,0xff3c,0xff3b,0xff39,0xff39,0xff38,
    0xff37,0xff37,0xff36,0xff35,0xff36,0xff35,0xff34,0xff35,
    0xff33,0xff34,0xff33,0xff32,0xff32,0xff31,0xff33,0xff32,
    0xff31,0xff30,0xff30,0xff2f,0xff2e,0xff2f,0xff2d,0xff2d,
    0xff2e,0xff2b,0xff2d,0xff2c,0xff2c,0xff2b,0xff2a,0xff2b,
    0xff28,0xff29,0xff29,0xff28,0xff28,0xff28,0xff27,0xff27,
    0xff25,0xff26,0xff24,0xff24,0xff24,0xff24,0xff22,0xff23,
    0xff22,0xff21,0xff20,0xff21,0xff20,0xff1f,0xff20,0xff1c,
    0xff1f,0xff1d,0xff1d,0xff1d,0xff1d,0xff1c,0xff1d,0xff1b,
    0xff1b,0xff1a,0xff19,0xff19,0xff19,0xff19,0xff17,0xff18,
    0xff18,0xff15,0xff18,0xff15,0xff15,0xff15,0xff15,0xff15,
    0xff13,0xff15,0xff13,0xff14,0xff13,0xff13,0xff12,0xff12,
    0xff10,0xff11,0xff0f,0xff10,0xff0f,0xff0f,0xff0e,0xff0f,
    0xff0d,0xff0e,0xff0d,0xff0c,0xff0c,0xff0b,0xff0b,0xff0b,
    0xff0c,0xff0b,0xff0b,0xff0a,0xff0a,0xff09,0xff09,0xff07,
    0xff08,0xff08,0xff07,0xff07,0xff06,0xff06,0xff04,0xff07,
    0xff03,0xff04,0xff04,0xff02,0xff02,0xff04,0xff02,0xff02,
    0xff02,0xff01,0xff01,0xff02,0xff00,0xff00,0xff00,0xfefe,
    0xfefe,0xfefe,0xfefe,0xfefd,0xfefd,0xfefc,0xfefc,0xfefc,
    0xfefb,0xfefa,0xfefa,0xfefb,0xfefa,0xfefa,0xfefa,0xfef9,
    0xfef9,0xfef9,0xfef7,0xfef8,0xfef8,0xfef6,0xfef6,0xfef6,
    0xfef6,0xfef6,0xfef6,0xfef5,0xfef6,0xfef5,0xfef4,0xfef5,
    0xfef4,0xfef3,0xfef4,0xfef3,0xfef4,0xfef3,0xfef4,0xfef3,
    0xfef3,0xfef2,0xfef2,0xfef1,0xfef2,0xfef1,0xfef1,0xfef0,
    0xfef0,0xfef0,0xfeef,0xfef1,0xfeef,0xfef0,0xfeed,0xfeee,
    0xfeef,0xfeee,0xfeef,0xfeee,0xfeed,0xfeee,0xfeed,0xfeed,
    0xfeec,0xfeec,0xfeec,0xfeec,0xfeeb,0xfeec,0xfeeb,0xfeea,
    0xfeeb,0xfeea,0xfee9,0xfeea,0xfee9,0xfee9,0xfee9,0xfee9,
    0xfeea,0xfee9,0xfee9,0xfee8,0xfee9,0xfee7,0xfee8,0xfee7,
    0xfee7,0xfee7,0xfee7,0xfee8,0xfee6,0xfee6,0xfee5,0xfee6,
    0xfee4,0xfee5,0xfee4,0xfee4,0xfee4,0xfee5,0xfee5,0xfee5,
    0xfee5,0xfee5,0xfee4,0xfee3,0xfee4,0xfee3,0xfee2,0xfee2,
    0xfee2,0xfee1,0xfee2,0xfee1,0xfee2,0xfee1,0xfee0,0xfee1,
    0xfee0,0xfee0,0xfedf,0xfee0,0xfee0,0xfee0,0xfee0,0xfedf,
    0xfee1,0xfede,0xfedf,0xfedd,0xfede,0xfedd,0xfedc,0xfedd,
    0xfedd,0xfedd,0xfedb,0xfedd,0xfedb,0xfedb,0xfedb,0xfedb,
    0xfeda,0xfedb,0xfedb,0xfedb,0xfedb,0xfedc,0xfeda,0xfedb,
    0xfedb,0xfeda,0xfeda,0xfed9,0xfeda,0xfeda,0xfed9,0xfeda,
    0xfed8,0xfed9,0xfed9,0xfed9,0xfed8,0xfed9,0xfed6,0xfed8,
    0xfed8,0xfed8,0xfed9,0xfed8,0xfeda,0xfed9,0xfed9,0xfed9,
    0xfed9,0xfed8,0xfed8,0xfed9,0xfed9,0xfed8,0xfed8,0xfed8,
    0xfed8,0xfed7,0xfed7,0xfed7,0xfed7,0xfed8,0xfed7,0xfed6,
    0xfed7,0xfed6,0xfed7,0xfed5,0xfed7,0xfed6,0xfed5,0xfed5,
    0xfed6,0xfed4,0xfed6,0xfed4,0xfed4,0xfed5,0xfed4,0xfed4,
    0xfed5,0xfed4,0xfed4,0xfed4,0xfed4,0xfed4,0xfed3,0xfed3,
    0xfed3,0xfed5,0xfed3,0xfed4,0xfed3,0xfed2,0xfed3,0xfed1,
    0xfed2,0xfed2,0xfed2,0xfed3,0xfed2,0xfed1,0xfed1,0xfed1,
    0xfed1,0xfed1,0xfed0,0xfed2,0xfecf,0xfed1,0xfed1,0xfed0,
    0xfed1,0xfecf,0xfed1,0xfecf,0xfecf,0xfecf,0xfecf,0xfed0,
    0xfed0,0xfecf,0xfecf,0xfed0,0xfece,0xfed0,0xfed0,0xfecf,
    0xfecf,0xfece,0xfece,0xfecf,0xfecf,0xfecf,0xfece,0xfecd,
    0xfecf,0xfecd,0xfece,0xfecd,0xfece,0xfecd,0xfecd,0xfecd,
    0xfecd,0xfece,0xfecc,0xfece,0xfecd,0xfecc,0xfece,0xfecc,
    0xfecc,0xfecc,0xfecd,0xfecc,0xfecc,0xfecc,0xfecc,0xfecc,
    0xfecc,0xfecc,0xfecc,0xfecc,0xfecb,0xfecc,0xfecb,0xfecd,
    0xfecc,0xfecc,0xfecc,0xfecb,0xfecc,0xfecc,0xfecb,0xfecb,
    0xfecc,0xfeca,0xfecc,0xfecb,0xfeca,0xfecb,0xfecb,0xfecb,
    0xfeca,0xfeca,0xfeca,0xfeca,0xfecc,0xfeca,0xfeca,0xfeca,
    0xfec9,0xfeca,0xfeca,0xfeca,0xfeca,0xfeca,0xfec8,0xfecb,
    0xfec9,0xfeca,0xfec9,0xfec9,0xfec8,0xfec9,0xfeca,0xfec7,
    0xfeca,0xfec8,0xfeca,0xfec8,0xfec9,0xfec9,0xfec8,0xfeca,
    0xfec8,0xfec9,0xfec9,0xfec8,0xfec9,0xfec7,0xfec9,0xfec8,
    0xfec8,0xfec7,0xfec9,0xfec6,0xfec9,0xfec8,0xfec7,0xfec9,
    0xfec8,0xfec7,0xfec8,0xfec8,0xfec8,0xfec8,0xfec7,0xfec8,
    0xfec8,0xfec7,0xfec7,0xfec8,0xfec7,0xfec7,0xfec7,0xfec8,
    0xfec6,0xfec7,0xfec6,0xfec7,0xfec7,0xfec6,0xfec6,0xfec6,
    0xfec7,0xfec5,0xfec5,0xfec4,0xfec4,0xfec3,0xfec3,0xfec2,
    0xfec2,0xfec1,0xfec1,0xfec0,0xfec1,0xfec1,0xfec0,0xfec1,
    0xfec0,0xfec1,0xfec0,0xfec1,0xfec0,0xfec0,0xfec0,0xfec1,
    0xfec2,0xfec2,0xfec1,0xfec1,0xfec2,0xfec1,0xfec2,0xfec1,
    0xfec0,0xfec3,0xfec1,0xfec1,0xfec2,0xfec1,0xfec1,0xfec2,
    0xfec2,0xfec2,0xfec1,0xfec1,0xfec1,0xfec3,0xfec3,0xfec3,
    0xfec3,0xfec4,0xfec2,0xfec4,0xfec2,0xfec4,0xfec3,0xfec3,
    0xfec2,0xfec3,0xfec4,0xfec3,0xfec3,0xfec3,0xfec3,0xfec4,
    0xfec3,0xfec3,0xfec3,0xfec2,0xfec3,0xfec3,0xfec2,0xfec2,
    0xfec2,0xfec3,0xfec2,0xfec2,0xfec2,0xfec1,0xfec2,0xfec2,
    0xfec2,0xfec2,0xfec2,0xfec3,0xfec2,0xfec2,0xfec3,0xfec2,
    0xfec2,0xfec2,0xfec3,0xfec3,0xfec4,0xfec4,0xfec3,0xfec5,
    0xfec3,0xfec3,0xfec4,0xfec3,0xfec4,0xfec4,0xfec3,0xfec5,
    0xfec4,0xfec3,0xfec5,0xfec2,0xfec4,0xfec4,0xfec3,0xfec3,
    0xfec4,0xfec3,0xfec4,0xfec5,0xfec4,0xfec4,0xfec4,0xfec4,
    0xfec3,0xfec5,0xfec3,0xfec5,0xfec4,0xfec4,0xfec5,0xfec5,
    0xfec4,0xfec4,0xfec5,0xfec5,0xfec5,0xfec4,0xfec5,0xfec5,
    0xfec5,0xfec6,0xfec6,0xfec4,0xfec6,0xfec5,0xfec5,0xfec5,
    0xfec4,0xfec5,0xfec5,0xfec5,0xfec6,0xfec6,0xfec5,0xfec5,
    0xfec6,0xfec4,0xfec6,0xfec4,0xfec7,0xfec5,0xfec5,0xfec7,
    0xfec4,0xfec8,0xfec5,0xfec7,0xfec6,0xfec5,0xfec6,0xfec6,
    0xfec6,0xfec6,0xfec7,0xfec7,0xfec6,0xfec6,0xfec7,0xfec6,
    0xfec6,0xfec6,0xfec7,0xfec7,0xfec7,0xfec8,0xfec9,0xfec8,
    0xfec7,0xfec8,0xfec7,0xfec8,0xfec6,0xfec8,0xfec7,0xfec7,
    0xfec9,0xfec7,0xfec9,0xfec7,0xfec8,0xfec7,0xfec8,0xfec8,
    0xfec6,0xfec8,0xfec8,0xfec6,0xfeca,0xfec7,0xfec9,0xfec9,
    0xfec8,0xfec8,0xfec8,0xfec8,0xfec8,0xfec9,0xfec8,0xfec9,
    0xfec8,0xfec9,0xfec9,0xfec8,0xfec8,0xfec9,0xfec7,0xfec8,
    0xfec9,0xfeca,0xfec9,0xfeca,0xfeca,0xfecb,0xfec9,0xfeca,
    0xfecb,0xfeca,0xfec9,0xfeca,0xfecc,0xfeca,0xfecb,0xfecb,
    0xfecb,0xfeca,0xfecb,0xfecb,0xfecb,0xfeca,0xfecb,0xfecc,
    0xfecc,0xfecd,0xfecb,0xfecc,0xfecd,0xfecb,0xfecc,0xfecd,
    0xfeca,0xfecd,0xfecb,0xfecd,0xfecc,0xfecd,0xfecb,0xfecd,
    0xfecc,0xfecd,0xfecc,0xfecc,0xfecb,0xfecd,0xfecd,0xfece,
    0xfecd,0xfecd,0xfecf,0xfecd,0xfecd,0xfece,0xfecd,0xfecd,
    0xfecd,0xfece,0xfecd,0xfece,0xfecd,0xfecc,0xfece,0xfecd,
    0xfece,0xfecd,0xfecd,0xfecf,0xfece,0xfece,0xfed0,0xfece,
    0xfecf,0xfecf,0xfecf,0xfece,0xfecf,0xfece,0xfed0,0xfece,
    0xfed0,0xfed0,0xfecf,0xfed1,0xfecf,0xfed0,0xfecf,0xfed0,
    0xfecf,0xfed0,0xfed1,0xfed0,0xfed1,0xfed1,0xfed1,0xfed1,
    0xfed1,0xfed0,0xfed1,0xfed1,0xfed1,0xfed1,0xfed2,0xfed1,
    0xfed1,0xfed1,0xfed0,0xfed2,0xfed0,0xfed3,0xfed1,0xfed1,
    0xfed2,0xfed1,0xfed3,0xfed2,0xfed2,0xfed3,0xfed2,0xfed2,
    0xfed2,0xfed3,0xfed1,0xfed3,0xfed1,0xfed3,0xfed3,0xfed1,
    0xfed3,0xfed2,0xfed2,0xfed3,0xfed1,0xfed2,0xfed3,0xfed1,
    0xfed4,0xfed3,0xfed3,0xfed3,0xfed3,0xfed2,0xfed4,0xfed3,
    0xfed1,0xfed4,0xfed1,0xfed3,0xfed3,0xfed2,0xfed3,0xfed2,
    0xfed3,0xfed3,0xfed4,0xfed3,0xfed3,0xfed4,0xfed5,0xfed6,
    0xfed5,0xfed5,0xfed6,0xfed6,0xfed5,0xfed6,0xfed5,0xfed5,
    0xfed7,0xfed6,0xfed6,0xfed7,0xfed7,0xfed8,0xfed6,0xfed7,
    0xfed6,0xfed6,0xfed7,0xfed6,0xfed9,0xfed9,0xfed7,0xfed9,
    0xfed8,0xfed8,0xfed9,0xfed8,0xfed9,0xfed7,0xfed9,0xfed9,
    0xfed8,0xfeda,0xfed9,0xfed9,0xfeda,0xfeda,0xfeda,0xfeda,
    0xfed9,0xfeda,0xfeda,0xfeda,0xfedc,0xfedb,0xfedc,0xfedb,
    0xfedb,0xfedc,0xfedc,0xfedc,0xfedb,0xfedd,0xfedc,0xfedd,
    0xfedb,0xfedd,0xfedb,0xfedc,0xfedc,0xfede,0xfedc,0xfedd,
    0xfedd,0xfedd,0xfedf,0xfedd,0xfedf,0xfede,0xfedf,0xfede,
    0xfede,0xfedf,0xfede,0xfedf,0xfedf,0xfede,0xfee0,0xfede,
    0xfedf,0xfee0,0xfedf,0xfedf,0xfee1,0xfede,0xfee0,0xfee0,
    0xfee2,0xfee0,0xfee1,0xfee2,0xfee1,0xfee1,0xfee1,0xfee1,
    0xfee0,0xfee1,0xfee1,0xfee1,0xfee2,0xfee1,0xfee1,0xfee1,
    0xfee1,0xfee1,0xfee3,0xfee0,0xfee2,0xfee2,0xfee3,0xfee3,
    0xfee3,0xfee3,0xfee3,0xfee3,0xfee3,0xfee4,0xfee3,0xfee4,
    0xfee4,0xfee2,0xfee5,0xfee3,0xfee4,0xfee5,0xfee3,0xfee4,
    0xfee6,0xfee4,0xfee4,0xfee5,0xfee6,0xfee7,0xfee7,0xfee7,
    0xfee8,0xfee8,0xfee8,0xfee9,0xfee8,0xfee9,0xfee9,0xfee9,
    0xfee9,0xfee9,0xfee9,0xfee8,0xfeeb,0xfeea,0xfeea,0xfeea,
    0xfeeb,0xfeea,0xfee9,0xfeeb,0xfeea,0xfeeb,0xfeeb,0xfeec,
    0xfeeb,0xfeec,0xfeeb,0xfeeb,0xfeec,0xfeeb,0xfeed,0xfeec,
    0xfeec,0xfeec,0xfeec,0xfeec,0xfeec,0xfeed,0xfeec,0xfeed,
    0xfeed,0xfeec,0xfeed,0xfeed,0xfeed,0xfeee,0xfeed,0xfeee,
    0xfeee,0xfeee,0xfeee,0xfeed,0xfeef,0xfeed,0xfeef,0xfeed,
    0xfeee,0xfeef,0xfeef,0xfeef,0xfeef,0xfeef,0xfef0,0xfef1,
    0xfef0,0xfef0,0xfeef,0xfef0,0xfef0,0xfef0,0xfef1,0xfef1,
    0xfef1,0xfef1,0xfef1,0xfef1,0xfef2,0xfef1,0xfef2,0xfef1,
    0xfef2,0xfef2,0xfef2,0xfef2,0xfef3,0xfef3,0xfef2,0xfef4,
    0xfef2,0xfef4,0xfef3,0xfef3,0xfef4,0xfef3,0xfef4,0xfef3,
    0xfef5,0xfef4,0xfef4,0xfef6,0xfef4,0xfef5,0xfef5,0xfef4,
    0xfef5,0xfef6,0xfef5,0xfef5,0xfef6,0xfef6,0xfef5,0xfef7,
    0xfef5,0xfef7,0xfef6,0xfef6,0xfef7,0xfef6,0xfef8,0xfef7,
    0xfef8,0xfef7,0xfef8,0xfef7,0xfef9,0xfef7,0xfef8,0xfef7,
    0xfef9,0xfef8,0xfef8,0xfef9,0xfef9,0xfef9,0xfef8,0xfefa,
    0xfefa,0xfef9,0xfefa,0xfef9,0xfefa,0xfefa,0xfefa,0xfefa,
    0xfefb,0xfefb,0xfefb,0xfefb,0xfefb,0xfefc,0xfefb,0xfefa,
    0xfefe,0xfefb,0xfefd,0xfefd,0xfefb,0xfefe,0xfefb,0xfefd,
    0xfefc,0xfefd,0xfefd,0xfefd,0xfefc,0xfefe,0xfeff,0xfefd,
    0xfefd,0xfefd,0xfefe,0xfefe,0xfefe,0xfeff,0xfefe,0xfefe,
    0xfeff,0xfefe,0xfefe,0xfeff,0xfeff,0xfeff,0xff00,0xff00,
    0xfeff,0xff00,0xff00,0xff00,0xff00,0xff00,0xff01,0xff00,
    0xff01,0xff00,0xff01,0xff00,0xff00,0xff01,0xff02,0xff00,
    0xff02,0xff01,0xff01,0xff02,0xff02,0xff02,0xff02,0xff02,
    0xff01,0xff02,0xff03,0xff01,0xff03,0xff01,0xff01,0xff01,
    0xff00,0xff01,0xfeff,0xff00,0xfeff,0xff00,0xfeff,0xff00,
    0xfeff,0xff00,0xfeff,0xff00,0xff00,0xfeff,0xff00,0xfeff,
    0xff00,0xff00,0xff02,0xff02,0xff01,0xff02,0xff02,0xff02,
    0xff02,0xff03,0xff02,0xff03,0xff02,0xff03,0xff03,0xff03,
    0xff03,0xff04,0xff02,0xff04,0xff04,0xff04,0xff04,0xff05,
    0xff05,0xff06,0xff06,0xff06,0xff06,0xff07,0xff07,0xff07,
    0xff08,0xff08,0xff08,0xff08,0xff08,0xff08,0xff08,0xff07,
    0xff08,0xff09,0xff0a,0xff08,0xff0a,0xff08,0xff0a,0xff09,
    0xff09,0xff0a,0xff08,0xff0b,0xff09,0xff0a,0xff09,0xff0a,
    0xff0a,0xff09,0xff0a,0xff0a,0xff0b,0xff0a,0xff0b,0xff0b,
    0xff0c,0xff09,0xff0c,0xff0b,0xff0a,0xff0c,0xff0b,0xff0d,
    0xff0d,0xff0e,0xff0d,0xff0d,0xff0e,0xff0d,0xff0f,0xff0d,
    0xff0e,0xff0f,0xff0e,0xff10,0xff0d,0xff10,0xff0f,0xff10,
    0xff0f,0xff0f,0xff0f,0xff10,0xff10,0xff11,0xff10,0xff10,
    0xff12,0xff0f,0xff12,0xff11,0xff11,0xff11,0xff13,0xff11,
    0xff13,0xff12,0xff12,0xff12,0xff14,0xff12,0xff13,0xff12,
    0xff14,0xff13,0xff13,0xff14,0xff14,0xff15,0xff14,0xff15,
    0xff14,0xff13,0xff15,0xff15,0xff14,0xff15,0xff15,0xff15,
    0xff15,0xff16,0xff16,0xff15,0xff15,0xff16,0xff15,0xff15,
    0xff16,0xff16,0xff17,0xff17,0xff16,0xff17,0xff18,0xff17,
    0xff17,0xff17,0xff19,0xff16,0xff1a,0xff17,0xff1a,0xff17,
    0xff19,0xff19,0xff19,0xff18,0xff19,0xff19,0xff18,0xff1a,
    0xff1a,0xff1b,0xff1a,0xff1b,0xff1c,0xff1b,0xff1b,0xff1b,
    0xff1a,0xff1b,0xff1a,0xff1b,0xff1b,0xff1b,0xff1b,0xff1b,
    0xff1b,0xff1b,0xff1c,0xff1b,0xff1b,0xff1c,0xff1b,0xff1d,
    0xff1d,0xff1d,0xff1c,0xff1d,0xff1d,0xff1d,0xff1e,0xff1c,
    0xff1e,0xff1c,0xff1f,0xff1d,0xff1d,0xff1f,0xff1d,0xff20,
    0xff1e,0xff1f,0xff1e,0xff1e,0xff20,0xff1e,0xff21,0xff20,
    0xff20,0xff20,0xff20,0xff21,0xff22,0xff20,0xff21,0xff21,
    0xff21,0xff21,0xff22,0xff21,0xff22,0xff21,0xff22,0xff23,
    0xff22,0xff23,0xff24,0xff23,0xff24,0xff23,0xff24,0xff25,
    0xff23,0xff24,0xff25,0xff24,0xff24,0xff25,0xff23,0xff26,
    0xff24,0xff26,0xff25,0xff25,0xff25,0xff26,0xff25,0xff26,
    0xff25,0xff26,0xff26,0xff28,0xff26,0xff27,0xff27,0xff26,
    0xff27,0xff27,0xff26,0xff28,0xff27,0xff28,0xff28,0xff28,
    0xff27,0xff28,0xff28,0xff28,0xff2a,0xff28,0xff29,0xff29,
    0xff29,0xff2a,0xff2a,0xff2b,0xff29,0xff2b,0xff2a,0xff2a,
    0xff2b,0xff2b,0xff2b,0xff2b,0xff2a,0xff2c,0xff2a,0xff2b,
    0xff2b,0xff2b,0xff2c,0xff2b,0xff2b,0xff2b,0xff2d,0xff2c,
    0xff2e,0xff2c,0xff2e,0xff2d,0xff2c,0xff2f,0xff2c,0xff2e,
    0xff2d,0xff2e,0xff2e,0xff2d,0xff2e,0xff2d,0xff2e,0xff2d,
    0xff2f,0xff2e,0xff2e,0xff2f,0xff2f,0xff2f,0xff2f,0xff2e,
    0xff30,0xff2f,0xff30,0xff2e,0xff30,0xff2e,0xff30,0xff2f,
    0xff2f,0xff30,0xff30,0xff2f,0xff31,0xff2f,0xff30,0xff30,
    0xff31,0xff2f,0xff30,0xff32,0xff31,0xff31,0xff31,0xff32,
    0xff31,0xff32,0xff30,0xff32,0xff31,0xff31,0xff32,0xff30,
    0xff32,0xff32,0xff31,0xff31,0xff31,0xff31,0xff31,0xff31,
    0xff32,0xff33,0xff33,0xff35,0xff34,0xff35,0xff35,0xff33,
    0xff35,0xff34,0xff35,0xff35,0xff34,0xff36,0xff35,0xff36,
    0xff35,0xff37,0xff35,0xff36,0xff36,0xff36,0xff37,0xff37,
    0xff37,0xff38,0xff38,0xff38,0xff38,0xff38,0xff38,0xff38,
    0xff38,0xff38,0xff39,0xff39,0xff39,0xff39,0xff39,0xff39,
    0xff39,0xff38,0xff3a,0xff39,0xff39,0xff3b,0xff3b,0xff3a,
    0xff3b,0xff3b,0xff3d,0xff3c,0xff3b,0xff3c,0xff3a,0xff3d,
    0xff3c,0xff3d,0xff3b,0xff3e,0xff3c,0xff3d,0xff3d,0xff3d,
    0xff3d,0xff3e,0xff3c,0xff3e,0xff3d,0xff3f,0xff3f,0xff40,
    0xff3f,0xff40,0xff3f,0xff40,0xff3f,0xff3f,0xff41,0xff3f,
    0xff41,0xff3f,0xff40,0xff40,0xff41,0xff3f,0xff41,0xff41,
    0xff40,0xff41,0xff41,0xff41,0xff42,0xff42,0xff43,0xff42,
    0xff42,0xff41,0xff43,0xff41,0xff42,0xff42,0xff43,0xff42,
    0xff43,0xff43,0xff42,0xff43,0xff42,0xff43,0xff43,0xff43,
    0xff43,0xff44,0xff44,0xff44,0xff45,0xff45,0xff45,0xff45,
    0xff45,0xff44,0xff45,0xff44,0xff47,0xff44,0xff46,0xff46,
    0xff45,0xff47,0xff45,0xff46,0xff47,0xff47,0xff45,0xff49,
    0xff47,0xff49,0xff49,0xff49,0xff4c,0xff4a,0xff4b,0xff4a,
    0xff4b,0xff4b,0xff4b,0xff4c,0xff4b,0xff4c,0xff4b,0xff4c,
    0xff4a,0xff4d,0xff4b,0xff4c,0xff4d,0xff4c,0xff4d,0xff4d,
    0xff4e,0xff4c,0xff4d,0xff4e,0xff4d,0xff4e,0xff4e,0xff4e,
    0xff4f,0xff4e,0xff4f,0xff4e,0xff4e,0xff4f,0xff4e,0xff4f,
    0xff4f,0xff4f,0xff4e,0xff4f,0xff50,0xff4f,0xff50,0xff50,
    0xff50,0xff50,0xff50,0xff50,0xff50,0xff50,0xff50,0xff50,
    0xff50,0xff50,0xff51,0xff50,0xff51,0xff51,0xff51,0xff53,
    0xff51,0xff52,0xff52,0xff51,0xff52,0xff53,0xff52,0xff53,
    0xff53,0xff52,0xff53,0xff53,0xff54,0xff53,0xff53,0xff54,
    0xff53,0xff53,0xff54,0xff54,0xff53,0xff56,0xff53,0xff56,
    0xff54,0xff56,0xff55,0xff55,0xff56,0xff54,0xff57,0xff56,
    0xff56,0xff56,0xff56,0xff55,0xff57,0xff57,0xff57,0xff57,
    0xff57,0xff56,0xff58,0xff58,0xff57,0xff58,0xff58,0xff57,
    0xff58,0xff57,0xff58,0xff58,0xff58,0xff58,0xff59,0xff59,
    0xff58,0xff59,0xff5a,0xff59,0xff59,0xff5b,0xff59,0xff5a,
    0xff5a,0xff5b,0xff5b,0xff5a,0xff5b,0xff5b,0xff5a,0xff5c,
    0xff5b,0xff5b,0xff5d,0xff5a,0xff5b,0xff5c,0xff5b,0xff5d,
    0xff5b,0xff5d,0xff5c,0xff5c,0xff5d,0xff5d,0xff5d,0xff5d,
    0xff5d,0xff5d,0xff5e,0xff5e,0xff5e,0xff5e,0xff5d,0xff5f,
    0xff5e,0xff5f,0xff5e,0xff5e,0xff5f,0xff5e,0xff60,0xff5e,
    0xff60,0xff5f,0xff60,0xff60,0xff5f,0xff61,0xff60,0xff60,
    0xff61,0xff5f,0xff61,0xff5f,0xff62,0xff60,0xff61,0xff61,
    0xff61,0xff61,0xff61,0xff62,0xff61,0xff62,0xff60,0xff62,
    0xff62,0xff61,0xff61,0xff63,0xff62,0xff62,0xff62,0xff63,
    0xff62,0xff62,0xff63,0xff62,0xff63,0xff63,0xff63,0xff63,
    0xff63,0xff63,0xff64,0xff63,0xff64,0xff64,0xff65,0xff63,
    0xff65,0xff63,0xff63,0xff60,0xff64,0xff61,0xff61,0xff62,
    0xff5f,0xff62,0xff61,0xff62,0xff61,0xff61,0xff61,0xff62,
    0xff61,0xff5f,0xff62,0xff60,0xff61,0xff61,0xff62,0xff62,
    0xff62,0xff63,0xff61,0xff64,0xff62,0xff63,0xff63,0xff62,
    0xff63,0xff62,0xff64,0xff63,0xff63,0xff64,0xff62,0xff65,
    0xff64,0xff65,0xff64,0xff65,0xff65,0xff67,0xff66,0xff67,
    0xff66,0xff66,0xff66,0xff67,0xff67,0xff66,0xff68,0xff67,
    0xff67,0xff67,0xff68,0xff68,0xff68,0xff68,0xff69,0xff68,
    0xff69,0xff67,0xff69,0xff68,0xff69,0xff68,0xff69,0xff69,
    0xff69,0xff67,0xff6a,0xff68,0xff69,0xff69,0xff68,0xff6a,
    0xff6a,0xff69,0xff69,0xff6a,0xff6a,0xff69,0xff6a,0xff6a,
    0xff6a,0xff6b,0xff6c,0xff6c,0xff6b,0xff6d,0xff6c,0xff6b,
    0xff6c,0xff6d,0xff6c,0xff6c,0xff6c,0xff6c,0xff6d,0xff6d,
    0xff6d,0xff6d,0xff6e,0xff6c,0xff6f,0xff6d,0xff6e,0xff6e,
    0xff6f,0xff6f,0xff6f,0xff6d,0xff70,0xff6f,0xff6e,0xff70,
    0xff6f,0xff6f,0xff6f,0xff6e,0xff70,0xff6f,0xff6f,0xff71,
    0xff6f,0xff70,0xff71,0xff70,0xff70,0xff6f,0xff72,0xff72,
    0xff71,0xff71,0xff71,0xff73,0xff71,0xff72,0xff72,0xff71,
    0xff72,0xff73,0xff72,0xff74,0xff71,0xff73,0xff72,0xff72,
    0xff74,0xff73,0xff72,0xff72,0xff74,0xff74,0xff74,0xff75,
    0xff73,0xff75,0xff74,0xff73,0xff75,0xff73,0xff75,0xff74,
    0xff75,0xff75,0xff74,0xff75,0xff74,0xff75,0xff75,0xff75,
    0xff75,0xff73,0xff77,0xff75,0xff77,0xff77,0xff76,0xff77,
    0xff77,0xff78,0xff77,0xff78,0xff77,0xff78,0xff77,0xff78,
    0xff77,0xff78,0xff78,0xff77,0xff79,0xff78,0xff77,0xff77,
    0xff78,0xff78,0xff78,0xff79,0xff79,0xff78,0xff79,0xff78,
    0xff79,0xff78,0xff79,0xff79,0xff79,0xff79,0xff7a,0xff7a,
    0xff79,0xff78,0xff7b,0xff78,0xff7a,0xff79,0xff78,0xff7b,
    0xff7a,0xff7b,0xff7a,0xff7b,0xff7d,0xff7b,0xff7d,0xff7a,
    0xff7d,0xff7b,0xff7c,0xff7c,0xff7d,0xff7d,0xff7c,0xff7d,
    0xff7c,0xff7d,0xff7d,0xff7c,0xff7d,0xff7d,0xff7e,0xff7e,
    0xff7d,0xff7d,0xff7d,0xff7f,0xff7e,0xff7d,0xff7f,0xff7e,
    0xff7d,0xff7f,0xff7f,0xff7f,0xff7f,0xff7f,0xff7f,0xff7f,
    0xff7f,0xff7f,0xff7f,0xff80,0xff80,0xff81,0xff81,0xff80,
    0xff81,0xff80,0xff82,0xff80,0xff80,0xff81,0xff80,0xff81,
    0xff81,0xff81,0xff83,0xff81,0xff82,0xff82,0xff80,0xff83,
    0xff81,0xff81,0xff82,0xff82,0xff83,0xff83,0xff83,0xff82,
    0xff84,0xff83,0xff83,0xff83,0xff82,0xff83,0xff83,0xff84,
    0xff83,0xff84,0xff83,0xff84,0xff84,0xff83,0xff85,0xff83,
    0xff84,0xff84,0xff85,0xff85,0xff85,0xff84,0xff86,0xff85,
    0xff85,0xff84,0xff85,0xff85,0xff85,0xff85,0xff86,0xff86,
    0xff85,0xff86,0xff86,0xff86,0xff86,0xff86,0xff85,0xff86,
    0xff85,0xff87,0xff87,0xff86,0xff88,0xff86,0xff86,0xff87,
    0xff87,0xff87,0xff86,0xff87,0xff88,0xff87,0xff87,0xff87,
    0xff86,0xff87,0xff87,0xff87,0xff87,0xff87,0xff88,0xff87,
    0xff88,0xff87,0xff88,0xff88,0xff87,0xff88,0xff88,0xff87,
    0xff87,0xff88,0xff88,0xff88,0xff89,0xff87,0xff88,0xff88,
    0xff88,0xff87,0xff88,0xff86,0xff89,0xff87,0xff88,0xff89,
    0xff89,0xff8a,0xff88,0xff8b,0xff89,0xff8b,0xff89,0xff8b,
    0xff8a,0xff8a,0xff8b,0xff8b,0xff8a,0xff8b,0xff8a,0xff8c,
    0xff8a,0xff8b,0xff8b,0xff8b,0xff8d,0xff8d,0xff8c,0xff8d,
    0xff8c,0xff8c,0xff8d,0xff8d,0xff8c,0xff8d,0xff8d,0xff8d,
    0xff8e,0xff8e,0xff8e,0xff8d,0xff8e,0xff8d,0xff8e,0xff8c,
    0xff8d,0xff91,0xff8f,0xff90,0xff8f,0xff90,0xff90,0xff90,
    0xff8f,0xff90,0xff8f,0xff90,0xff90,0xff90,0xff90,0xff91,
    0xff8f,0xff91,0xff90,0xff90,0xff91,0xff90,0xff91,0xff90,
    0xff92,0xff91,0xff92,0xff92,0xff92,0xff92,0xff92,0xff93,
    0xff92,0xff92,0xff91,0xff94,0xff91,0xff94,0xff91,0xff93,
    0xff92,0xff93,0xff93,0xff92,0xff93,0xff92,0xff93,0xff94,
    0xff95,0xff93,0xff94,0xff93,0xff95,0xff94,0xff94,0xff94,
    0xff94,0xff94,0xff94,0xff95,0xff94,0xff94,0xff94,0xff93,
    0xff95,0xff95,0xff94,0xff93,0xff95,0xff95,0xff96,0xff94,
    0xff97,0xff95,0xff96,0xff96,0xff95,0xff96,0xff95,0xff97,
    0xff95,0xff97,0xff96,0xff97,0xff96,0xff96,0xff95,0xff97,
    0xff96,0xff96,0xff97,0xff97,0xff98,0xff98,0xff9a,0xff9a,
    0xff9a,0xff9a,0xff9b,0xff9a,0xff9b,0xff9b,0xff9a,0xff9a,
    0xff9a,0xff9b,0xff9c,0xff9a,0xff9d,0xff9b,0xff9c,0xff9c,
    0xff9b,0xff9d,0xff9c,0xff9d,0xff9c,0xff9d,0xff9c,0xff9e,
    0xff9c,0xff9d,0xff9c,0xff9d,0xff9e,0xff9c,0xff9c,0xff9e,
    0xff9d,0xff9e,0xff9c,0xff9e,0xff9d,0xff9d,0xff9f,0xff9d,
    0xff9f,0xff9e,0xff9f,0xff9e,0xff9e,0xff9e,0xff9f,0xff9e,
    0xff9e,0xff9e,0xff9f,0xff9f,0xff9e,0xff9f,0xff9e,0xff9f,
    0xff9e,0xff9f,0xff9f,0xffa0,0xff9f,0xffa0,0xffa0,0xff9f,
    0xff9f,0xffa0,0xff9f,0xffa1,0xffa0,0xffa0,0xffa0,0xffa0,
    0xffa0,0xffa0,0xffa1,0xffa0,0xffa0,0xffa1,0xffa2,0xffa1,
    0xffa0,0xffa1,0xffa0,0xffa1,0xffa1,0xffa1,0xffa2,0xffa2,
    0xffa1,0xffa3,0xffa1,0xffa2,0xffa1,0xffa1,0xffa2,0xffa2,
    0xffa3,0xffa2,0xffa3,0xffa3,0xffa2,0xffa2,0xffa3,0xffa3,
    0xffa1,0xffa4,0xffa2,0xffa2,0xffa4,0xffa2,0xffa4,0xffa3,
    0xffa4,0xffa3,0xffa2,0xffa5,0xffa2,0xffa5,0xffa3,0xffa5,
    0xffa4,0xffa4,0xffa5,0xffa3,0xffa5,0xffa5,0xffa5,0xffa4,
    0xffa5,0xffa5,0xffa6,0xffa5,0xffa6,0xffa6,0xffa5,0xffa6,
    0xffa6,0xffa6,0xffa6,0xffa5,0xffa6,0xffa6,0xffa6,0xffa6,
    0xffa7,0xffa6,0xffa7,0xffa6,0xffa6,0xffa8,0xffa6,0xffa8,
    0xffa7,0xffa7,0xffa7,0xffa8,0xffa8,0xffa7,0xffa7,0xffa7,
    0xffa7,0xffa7,0xffa8,0xffa8,0xffa8,0xffa8,0xffa9,0xffa7,
    0xffa9,0xffa7,0xffa8,0xffa9,0xffa8,0xffa8,0xffa9,0xffa8,
    0xffa8,0xffa9,0xffa9,0xffa9,0xffa9,0xffa9,0xffaa,0xffa9,
    0xffa9,0xffaa,0xffaa,0xffaa,0xffa9,0xffa9,0xffaa,0xffaa,
    0xffaa,0xffaa,0xffab,0xffaa,0xffab,0xffa9,0xffaa,0xffaa,
    0xffaa,0xffaa,0xffab,0xffab,0xffaa,0xffac,0xffaa,0xffaa,
    0xffab,0xffa9,0xffab,0xffab,0xffaa,0xffa9,0xffa9,0xffa9,
    0xffa9,0xffa8,0xffa9,0xffa8,0xffa7,0xffa9,0xffa7,0xffa9,
    0xffa8,0xffa8,0xffa9,0xffa7,0xffa8,0xffa8,0xffa7,0xffa7,
    0xffa7,0xffa7,0xffa9,0xffa7,0xffa8,0xffa8,0xffa8,0xffa8,
    0xffa7,0xffa8,0xffa8,0xffa8,0xffa9,0xffa7,0xffa9,0xffa8,
    0xffa9,0xffa9,0xffa7,0xffaa,0xffa8,0xffaa,0xffa8,0xffa9,
    0xffab,0xffaa,0xffab,0xffac,0xffaa,0xffab,0xffab,0xffab,
    0xffac,0xffab,0xffac,0xffac,0xffab,0xffac,0xffad,0xffac,
    0xffac,0xffad,0xffac,0xffad,0xffab,0xffad,0xffad,0xffac,
    0xffae,0xffac,0xffac,0xffae,0xffab,0xffac,0xffad,0xffab,
    0xffad,0xffac,0xffad,0xffad,0xffad,0xffae,0xffad,0xffad,
    0xffac,0xffae,0xffad,0xffaf,0xffad,0xffaf,0xffaf,0xffaf,
    0xffb0,0xffae,0xffaf,0xffae,0xffb0,0xffaf,0xffaf,0xffb0,
    0xffaf,0xffb0,0xffaf,0xffaf,0xffb0,0xffb0,0xffb0,0xffaf,
    0xffb1,0xffaf,0xffb1,0xffaf,0xffb1,0xffb1,0xffb0,0xffb1,
    0xffb2,0xffb1,0xffb0,0xffb2,0xffb0,0xffb2,0xffb0,0xffb2,
    0xffb1,0xffb2,0xffb2,0xffb2,0xffb1,0xffb2,0xffb2,0xffb2,
    0xffb2,0xffb2,0xffb3,0xffb3,0xffb3,0xffb3,0xffb3,0xffb2,
    0xffb3,0xffb4,0xffb1,0xffb3,0xffb3,0xffb3,0xffb4,0xffb3,
    0xffb4,0xffb3,0xffb4,0xffb3,0xffb4,0xffb3,0xffb3,0xffb3,
    0xffb4,0xffb4,0xffb4,0xffb5,0xffb4,0xffb4,0xffb4,0xffb5,
    0xffb4,0xffb5,0xffb4,0xffb5,0xffb4,0xffb5,0xffb4,0xffb5,
    0xffb5,0xffb4,0xffb6,0xffb6,0xffb4,0xffb4,0xffb5,0xffb6,
    0xffb6,0xffb6,0xffb5,0xffb7,0xffb6,0xffb6,0xffb6,0xffb6,
    0xffb8,0xffb6,0xffb7,0xffb8,0xffb6,0xffb7,0xffb8,0xffb7,
    0xffb6,0xffb6,0xffb6,0xffb6,0xffb6,0xffb7,0xffb7,0xffb7,
    0xffb7,0xffb7,0xffb7,0xffb8,0xffb6,0xffb7,0xffb7,0xffb7,
    0xffb6,0xffb8,0xffb7,0xffb7,0xffb7,0xffb6,0xffb7,0xffb7,
    0xffb7,0xffb7,0xffb7,0xffb8,0xffb8,0xffb9,0xffb8,0xffb9,
    0xffb9,0xffb8,0xffb9,0xffb9,0xffb7,0xffb9,0xffb9,0xffb9,
    0xffbb,0xffb9,0xffbb,0xffb9,0xffba,0xffb9,0xffba,0xffb9,
    0xffb9,0xffbb,0xffba,0xffba,0xffba,0xffbb,0xffba,0xffba,
    0xffbb,0xffbb,0xffba,0xffba,0xffbb,0xffbb,0xffba,0xffbb,
    0xffbb,0xffbb,0xffbb,0xffba,0xffbb,0xffbb,0xffbb,0xffbb,
    0xffbc,0xffbc,0xffbc,0xffbd,0xffbc,0xffbd,0xffbc,0xffbb,
    0xffbd,0xffbc,0xffbd,0xffbb,0xffbd,0xffbb,0xffbd,0xffbb,
    0xffbd,0xffbd,0xffbc,0xffbc,0xffbc,0xffbe,0xffbc,0xffbd,
    0xffbd,0xffbd,0xffbe,0xffbd,0xffbd,0xffbd,0xffbe,0xffbd,
    0xffbe,0xffbe,0xffbd,0xffbe,0xffbe,0xffbe,0xffbe,0xffbf,
    0xffbd,0xffbe,0xffbf,0xffbd,0xffbf,0xffbe,0xffbf,0xffc0,
    0xffbe,0xffc0,0xffbe,0xffc0,0xffbf,0xffbf,0xffbe,0xffbf,
    0xffbf,0xffbf,0xffc0,0xffbe,0xffc1,0xffbf,0xffbe,0xffc0,
    0xffbe,0xffbe,0xffbf,0xffbe,0xffc0,0xffc0,0xffc0,0xffbf,
    0xffc0,0xffbf,0xffc0,0xffc0,0xffbf,0xffbf,0xffc0,0xffbf,
    0xffc1,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffbf,0xffbf,
    0xffc0,0xffbf,0xffc0,0xffc0,0xffc1,0xffbf,0xffc1,0xffc1,
    0xffbe,0xffc3,0xffbe,0xffc1,0xffc0,0xffbf,0xffc1,0xffbf,
    0xffc0,0xffbf,0xffc0,0xffbf,0xffbf,0xffbf,0xffbe,0xffc0,
    0xffbf,0xffc0,0xffbf,0xffc0,0xffbf,0xffbf,0xffbf,0xffc0,
    0xffc0,0xffc0,0xffc0,0xffc1,0xffc1,0xffc1,0xffc1,0xffc1,
    0xffc1,0xffc0,0xffc2,0xffc1,0xffc0,0xffc1,0xffc1,0xffc2,
    0xffc2,0xffc3,0xffc2,0xffc4,0xffc2,0xffc3,0xffc2,0xffc2,
    0xffc3,0xffc2,0xffc4,0xffc2,0xffc4,0xffc3,0xffc3,0xffc3,
    0xffc3,0xffc4,0xffc4,0xffc3,0xffc4,0xffc3,0xffc6,0xffc4,
    0xffc6,0xffc4,0xffc5,0xffc5,0xffc5,0xffc5,0xffc4,0xffc5,
    0xffc5,0xffc5,0xffc6,0xffc6,0xffc4,0xffc6,0xffc5,0xffc5,
    0xffc5,0xffc5,0xffc5,0xffc6,0xffc6,0xffc6,0xffc7,0xffc6,
    0xffc7,0xffc6,0xffc6,0xffc7,0xffc6,0xffc7,0xffc6,0xffc7,
    0xffc7,0xffc6,0xffc8,0xffc6,0xffc7,0xffc6,0xffc8,0xffc6,
    0xffc7,0xffc8,0xffc7,0xffc8,0xffc8,0xffc7,0xffc8,0xffc8,
    0xffc7,0xffc8,0xffc8,0xffc6,0xffc8,0xffc8,0xffc7,0xffc8,
    0xffc8,0xffc8,0xffc7,0xffc8,0xffc7,0xffc9,0xffc7,0xffc8,
    0xffc9,0xffc9,0xffc9,0xffc8,0xffca,0xffc9,0xffc8,0xffca,
    0xffc8,0xffc9,0xffc9,0xffc9,0xffca,0xffc9,0xffc8,0xffc9,
    0xffc9,0xffc8,0xffc9,0xffc9,0xffc9,0xffc9,0xffca,0xffc8,
    0xffcc,0xffca,0xffcc,0xffcc,0xffcc,0xffcc,0xffce,0xffcb,
    0xffcd,0xffcd,0xffcc,0xffcd,0xffcc,0xffcd,0xffcc,0xffce,
    0xffcc,0xffce,0xffcd,0xffcc,0xffce,0xffcd,0xffcd,0xffcd,
    0xffce,0xffcd,0xffcd,0xffce,0xffcd,0xffcd,0xffce,0xffce,
    0xffce,0xffcd,0xffcf,0xffcd,0xffcf,0xffcd,0xffce,0xffcf,
    0xffcd,0xffce,0xffcd,0xffcf,0xffce,0xffcf,0xffce,0xffcf,
    0xffce,0xffcf,0xffcf,0xffcf,0xffce,0xffcf,0xffce,0xffcf,
    0xffcf,0xffcf,0xffcf,0xffcf,0xffce,0xffcf,0xffcf,0xffcf,
    0xffd0,0xffcf,0xffd0,0xffcf,0xffd0,0xffcf,0xffcf,0xffd0,
    0xffcf,0xffcf,0xffcf,0xffd0,0xffcf,0xffcf,0xffd1,0xffd0,
    0xffcf,0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,0xffd0,
    0xffd0,0xffd1,0xffd0,0xffd0,0xffd1,0xffd1,0xffd1,0xffd0,
    0xffd1,0xffd0,0xffd2,0xffd1,0xffd1,0xffd2,0xffd1,0xffd2,
    0xffd1,0xffd1,0xffd1,0xffd1,0xffd2,0xffd0,0xffd1,0xffd2,
    0xffd2,0xffd1,0xffd1,0xffd1,0xffd3,0xffd2,0xffd1,0xffd2,
    0xffd1,0xffd4,0xffd1,0xffd3,0xffd2,0xffd2,0xffd2,0xffd3,
    0xffd3,0xffd2,0xffd3,0xffd3,0xffd3,0xffd3,0xffd3,0xffd3,
    0xffd3,0xffd4,0xffd2,0xffd4,0xffd3,0xffd3,0xffd3,0xffd4,
    0xffd4,0xffd3,0xffd4,0xffd4,0xffd3,0xffd3,0xffd3,0xffd4,
    0xffd4,0xffd3,0xffd4,0xffd4,0xffd4,0xffd4,0xffd4,0xffd4,
    0xffd3,0xffd6,0xffd3,0xffd5,0xffd4,0xffd5,0xffd5,0xffd4,
    0xffd6,0xffd3,0xffd6,0xffd4,0xffd4,0xffd5,0xffd4,0xffd5,
    0xffd6,0xffd4,0xffd6,0xffd4,0xffd5,0xffd5,0xffd5,0xffd5,
    0xffd4,0xffd6,0xffd5,0xffd6,0xffd5,0xffd5,0xffd6,0xffd5,
    0xffd6,0xffd4,0xffd6,0xffd6,0xffd4,0xffd6,0xffd6,0xffd6,
    0xffd5,0xffd6,0xffd6,0xffd5,0xffd5,0xffd5,0xffd5,0xffd5,
    0xffd6,0xffd5,0xffd6,0xffd6,0xffd7,0xffd5,0xffd7,0xffd5,
    0xffd5,0xffd4,0xffd3,0xffd4,0xffd3,0xffd3,0xffd3,0xffd2,
    0xffd3,0xffd2,0xffd3,0xffd3,0xffd3,0xffd1,0xffd2,0xffd3,
    0xffd2,0xffd3,0xffd2,0xffd2,0xffd3,0xffd2,0xffd3,0xffd3,
    0xffd2,0xffd3,0xffd2,0xffd2,0xffd3,0xffd2,0xffd2,0xffd3,
    0xffd2,0xffd3,0xffd2,0xffd3,0xffd3,0xffd3,0xffd2,0xffd4,
    0xffd3,0xffd2,0xffd3,0xffd4,0xffd4,0xffd5,0xffd5,0xffd5,
    0xffd6,0xffd5,0xffd5,0xffd6,0xffd5,0xffd4,0xffd5,0xffd5,
    0xffd6,0xffd6,0xffd4,0xffd6,0xffd5,0xffd6,0xffd6,0xffd5,
    0xffd6,0xffd6,0xffd4,0xffd6,0xffd6,0xffd4,0xffd5,0xffd5,
    0xffd4,0xffd5,0xffd4,0xffd4,0xffd4,0xffd4,0xffd6,0xffd5,
    0xffd5,0xffd5,0xffd6,0xffd5,0xffd6,0xffd4,0xffd5,0xffd5,
    0xffd5,0xffd7,0xffd7,0xffd6,0xffd7,0xffd7,0xffd6,0xffd8,
    0xffd7,0xffd6,0xffd7,0xffd7,0xffd8,0xffd7,0xffd7,0xffd8,
    0xffd7,0xffd8,0xffd6,0xffd8,0xffd7,0xffd8,0xffd8,0xffd9,
    0xffd9,0xffd8,0xffd8,0xffd8,0xffd9,0xffd9,0xffd8,0xffd9,
    0xffd8,0xffd9,0xffd8,0xffd9,0xffd9,0xffd8,0xffd9,0xffd9,
    0xffd9,0xffd9,0xffd8,0xffd8,0xffda,0xffd8,0xffda,0xffd9,
    0xffd8,0xffda,0xffd9,0xffd9,0xffd9,0xffd8,0xffd8,0xffda,
    0xffd9,0xffda,0xffda,0xffda,0xffd9,0xffda,0xffd8,0xffda,
    0xffd9,0xffd8,0xffd9,0xffda,0xffd9,0xffdb,0xffda,0xffda,
    0xffdb,0xffd9,0xffdb,0xffdb,0xffda,0xffda,0xffda,0xffdb,
    0xffda,0xffd9,0xffda,0xffda,0xffda,0xffda,0xffda,0xffda,
    0xffd9,0xffdb,0xffdb,0xffda,0xffdc,0xffda,0xffdc,0xffda,
    0xffdb,0xffdb,0xffda,0xffda,0xffdc,0xffdb,0xffdb,0xffdc,
    0xffda,0xffdc,0xffdb,0xffdb,0xffdb,0xffdc,0xffda,0xffdb,
    0xffdb,0xffdb,0xffdc,0xffdc,0xffdb,0xffdb,0xffdc,0xffdc,
    0xffda,0xffda,0xffdc,0xffdb,0xffdc,0xffdb,0xffdc,0xffdc,
    0xffdb,0xffdb,0xffdb,0xffdb,0xffdb,0xffdb,0xffdb,0xffdc,
    0xffdc,0xffde,0xffdb,0xffdd,0xffdc,0xffdc,0xffdd,0xffdc,
    0xffdb,0xffdc,0xffdd,0xffdc,0xffdc,0xffdd,0xffdc,0xffdc,
    0xffdc,0xffdc,0xffdd,0xffdb,0xffdd,0xffdd,0xffdd,0xffde,
    0xffdd,0xffdd,0xffde,0xffde,0xffde,0xffdd,0xffdd,0xffdd,
    0xffde,0xffdc,0xffdf,0xffdd,0xffde,0xffdd,0xffde,0xffdd,
    0xffde,0xffdd,0xffdd,0xffdf,0xffdf,0xffde,0xffdf,0xffde,
    0xffdf,0xffde,0xffde,0xffdf,0xffdf,0xffde,0xffde,0xffdf,
    0xffdf,0xffdf,0xffdd,0xffde,0xffdf,0xffdf,0xffdf,0xffdf,
    0xffde,0xffdf,0xffdf,0xffdf,0xffdf,0xffe0,0xffdf,0xffe1,
    0xffdf,0xffdf,0xffdf,0xffdf,0xffe0,0xffdf,0xffe0,0xffdf,
    0xffdf,0xffdf,0xffdf,0xffe0,0xffde,0xffe0,0xffde,0xffdf,
    0xffe0,0xffdf,0xffe1,0xffe0,0xffe0,0xffe1,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe1,0xffdf,0xffe0,0xffe0,0xffdf,
    0xffe1,0xffdf,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe1,0xffe0,0xffe1,0xffe0,0xffe1,0xffe0,0xffe0,0xffe0,
    0xffe1,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffdf,0xffe1,
    0xffe0,0xffe0,0xffe0,0xffdf,0xffe0,0xffe0,0xffe0,0xffe1,
    0xffe2,0xffe0,0xffe0,0xffe1,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffdf,0xffdf,0xffdf,0xffe0,
    0xffe0,0xffde,0xffdf,0xffdf,0xffdf,0xffdf,0xffe1,0xffe0,
    0xffdf,0xffe0,0xffdf,0xffdf,0xffde,0xffdf,0xffdf,0xffe1,
    0xffdf,0xffe0,0xffe0,0xffe1,0xffe0,0xffe0,0xffe1,0xffe1,
    0xffe0,0xffe1,0xffe1,0xffe0,0xffe2,0xffe1,0xffe1,0xffe2,
    0xffe0,0xffe2,0xffe0,0xffe1,0xffe2,0xffe1,0xffe2,0xffe0,
    0xffe2,0xffe2,0xffe1,0xffe2,0xffe2,0xffe2,0xffe1,0xffe2,
    0xffe1,0xffe3,0xffe2,0xffe3,0xffe3,0xffe2,0xffe3,0xffe2,
    0xffe3,0xffe2,0xffe3,0xffe3,0xffe3,0xffe2,0xffe4,0xffe2,
    0xffe4,0xffe3,0xffe3,0xffe3,0xffe3,0xffe3,0xffe4,0xffe4,
    0xffe4,0xffe4,0xffe5,0xffe3,0xffe4,0xffe5,0xffe3,0xffe5,
    0xffe3,0xffe3,0xffe4,0xffe5,0xffe5,0xffe4,0xffe5,0xffe3,
    0xffe5,0xffe4,0xffe4,0xffe3,0xffe4,0xffe6,0xffe4,0xffe6,
    0xffe6,0xffe5,0xffe6,0xffe5,0xffe6,0xffe5,0xffe4,0xffe5,
    0xffe5,0xffe4,0xffe6,0xffe5,0xffe4,0xffe5,0xffe6,0xffe3,
    0xffe6,0xffe3,0xffe4,0xffe5,0xffe5,0xffe7,0xffe4,0xffe6,
    0xffe6,0xffe6,0xffe5,0xffe7,0xffe5,0xffe6,0xffe6,0xffe6,
    0xffe5,0xffe6,0xffe5,0xffe5,0xffe6,0xffe5,0xffe6,0xffe5,
    0xffe5,0xffe5,0xffe7,0xffe6,0xffe9,0xffe7,0xffe9,0xffe9,
    0xffe8,0xffe9,0xffe9,0xffe7,0xffea,0xffe8,0xffe9,0xffe9,
    0xffe9,0xffe9,0xffe8,0xffe9,0xffe9,0xffea,0xffe8,0xffea,
    0xffe8,0xffea,0xffe9,0xffe9,0xffea,0xffea,0xffe9,0xffea,
    0xffea,0xffe9,0xffea,0xffea,0xffea,0xffe9,0xffea,0xffea,
    0xffe9,0xffea,0xffe9,0xffea,0xffea,0xffea,0xffea,0xffeb,
    0xffea,0xffe9,0xffec,0xffe9,0xffeb,0xffea,0xffea,0xffea,
    0xffea,0xffeb,0xffe9,0xffeb,0xffea,0xffea,0xffeb,0xffe9,
    0xffeb,0xffea,0xffea,0xffea,0xffea,0xffeb,0xffea,0xffeb,
    0xffea,0xffea,0xffea,0xffea,0xffeb,0xffe9,0xffec,0xffe9,
    0xffec,0xffea,0xffeb,0xffeb,0xffec,0xffea,0xffeb,0xffea,
    0xffeb,0xffeb,0xffea,0xffeb,0xffec,0xffec,0xffea,0xffec,
    0xffec,0xffeb,0xffeb,0xffec,0xffeb,0xffec,0xffeb,0xffec,
    0xffeb,0xffec,0xffeb,0xffec,0xffed,0xffeb,0xffec,0xffeb,
    0xffed,0xffeb,0xffec,0xffeb,0xffec,0xffec,0xffeb,0xffeb,
    0xffec,0xffec,0xffeb,0xffec,0xffeb,0xffec,0xffeb,0xffed,
    0xffeb,0xffec,0xffeb,0xffec,0xffec,0xffec,0xffed,0xffec,
    0xffec,0xffed,0xffec,0xffeb,0xffed,0xffec,0xffec,0xffeb,
    0xffec,0xffec,0xffed,0xffee,0xffed,0xffec,0xffed,0xffed,
    0xffec,0xffed,0xffee,0xffec,0xffed,0xffed,0xffed,0xffed,
    0xffed,0xffed,0xffec,0xffed,0xffec,0xffee,0xffec,0xffee,
    0xffec,0xffed,0xffec,0xffed,0xffed,0xffed,0xffec,0xffee,
    0xffec,0xffee,0xffed,0xffed,0xffee,0xffed,0xffee,0xffec,
    0xffee,0xffee,0xffee,0xffed,0xffee,0xffed,0xffed,0xffee,
    0xffed,0xffee,0xffed,0xffee,0xffee,0xffed,0xffed,0xffed,
    0xffee,0xffee,0xffec,0xffee,0xffee,0xffed,0xffed,0xffed,
    0xffee,0xffec,0xffee,0xffed,0xffed,0xffed,0xffed,0xffed,
    0xffee,0xffed,0xffee,0xffeb,0xffed,0xffeb,0xffec,0xffea,
    0xffeb,0xffeb,0xffe9,0xffea,0xffe8,0xffeb,0xffe9,0xffeb,
    0xffea,0xffea,0xffeb,0xffe9,0xffeb,0xffe8,0xffea,0xffe8,
    0xffea,0xffeb,0xffe9,0xffeb,0xffe8,0xffeb,0xffe9,0xffe9,
    0xffe9,0xffe9,0xffea,0xffe9,0xffe9,0xffea,0xffea,0xffe9,
    0xffe9,0xffea,0xffe9,0xffea,0xffe9,0xffe8,0xffeb,0xffea,
    0xffeb,0xffeb,0xffea,0xffec,0xffeb,0xffeb,0xffeb,0xffeb,
    0xffec,0xffeb,0xffec,0xffeb,0xffeb,0xffec,0xffea,0xffec,
    0xffeb,0xffeb,0xffeb,0xffeb,0xffec,0xffeb,0xffeb,0xffec,
    0xffec,0xffea,0xffec,0xffea,0xffea,0xffec,0xffe9,0xffeb,
    0xffea,0xffea,0xffeb,0xffeb,0xffea,0xffeb,0xffeb,0xffea,
    0xffeb,0xffea,0xffea,0xffeb,0xffec,0xffec,0xffec,0xffed,
    0xffed,0xffeb,0xffec,0xffec,0xffec,0xffed,0xffed,0xffec,
    0xffed,0xffec,0xffed,0xffed,0xffed,0xffed,0xffec,0xffee,
    0xffeb,0xffed,0xffed,0xffed,0xffee,0xffed,0xffee,0xffed,
    0xffed,0xffed,0xffed,0xffed,0xffed,0xffed,0xffec,0xffee,
    0xffed,0xffec,0xffee,0xffec,0xffee,0xffed,0xffed,0xffee,
    0xffee,0xffed,0xfff0,0xffee,0xffee,0xffed,0xffee,0xffee,
    0xffee,0xffee,0xffee,0xffee,0xffee,0xffee,0xffef,0xffed,
    0xffee,0xffee,0xffee,0xffef,0xffee,0xffed,0xffee,0xffef,
    0xffed,0xfff0,0xffef,0xffef,0xfff0,0xffee,0xffef,0xffee,
    0xffef,0xffee,0xffef,0xffef,0xffee,0xffee,0xffef,0xfff0,
    0xffee,0xffee,0xffef,0xffec,0xffef,0xffed,0xfff0,0xffef,
    0xfff0,0xffef,0xffee,0xfff0,0xffee,0xfff0,0xffef,0xffee,
    0xfff0,0xffef,0xfff0,0xffee,0xffef,0xfff0,0xffee,0xffee,
    0xffef,0xffef,0xffed,0xfff0,0xfff0,0xffef,0xfff0,0xfff0,
    0xffef,0xfff0,0xffee,0xfff0,0xffef,0xffee,0xfff1,0xffee,
    0xfff0,0xffef,0xffee,0xfff0,0xffef,0xffef,0xfff0,0xffef,
    0xffef,0xffef,0xffef,0xfff1,0xfff0,0xfff0,0xfff0,0xfff0,
    0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,
    0xfff1,0xffef,0xfff0,0xfff1,0xffef,0xfff1,0xffef,0xfff1,
    0xfff0,0xfff1,0xfff0,0xfff0,0xfff1,0xfff0,0xfff1,0xfff0,
    0xfff0,0xfff0,0xfff1,0xfff0,0xfff1,0xfff1,0xfff0,0xfff1,
    0xfff2,0xfff0,0xfff1,0xfff1,0xfff0,0xfff1,0xfff1,0xfff0,
    0xfff2,0xfff1,0xfff2,0xfff2,0xfff1,0xfff1,0xfff1,0xfff1,
    0xfff1,0xfff0,0xfff2,0xfff1,0xfff1,0xfff2,0xfff1,0xfff1,
    0xfff1,0xfff2,0xfff2,0xfff1,0xfff1,0xfff1,0xfff2,0xfff1,
    0xfff2,0xfff1,0xfff1,0xfff2,0xfff1,0xfff3,0xfff1,0xfff2,
    0xfff2,0xfff1,0xfff2,0xfff2,0xfff2,0xfff2,0xfff3,0xfff1,
    0xfff2,0xfff2,0xfff1,0xfff2,0xfff2,0xfff3,0xfff3,0xfff2,
    0xfff2,0xfff3,0xfff2,0xfff2,0xfff2,0xfff3,0xfff1,0xfff4,
    0xfff1,0xfff4,0xfff1,0xfff3,0xfff1,0xfff2,0xfff2,0xfff1,
    0xfff2,0xfff1,0xfff2,0xfff2,0xfff2,0xfff3,0xfff3,0xfff2,
    0xfff2,0xfff2,0xfff1,0xfff2,0xfff2,0xfff3,0xfff1,0xfff2,
    0xfff2,0xfff1,0xfff3,0xfff1,0xfff2,0xfff2,0xfff2,0xfff0,
    0xfff3,0xfff2,0xfff3,0xfff3,0xfff1,0xfff3,0xfff2,0xfff2,
    0xfff2,0xfff2,0xfff0,0xfff2,0xfff2,0xfff1,0xfff2,0xfff2,
    0xfff1,0xfff1,0xfff1,0xfff1,0xfff1,0xfff0,0xfff0,0xfff1,
    0xfff0,0xfff1,0xfff1,0xfff0,0xfff1,0xfff1,0xfff0,0xfff0,
    0xfff0,0xffef,0xfff1,0xffef,0xfff1,0xfff1,0xfff1,0xfff1,
    0xfff1,0xfff1,0xfff1,0xfff0,0xfff2,0xfff1,0xfff2,0xfff2,
    0xfff2,0xfff2,0xfff3,0xfff2,0xfff1,0xfff2,0xfff1,0xfff2,
    0xfff3,0xfff2,0xfff2,0xfff1,0xfff3,0xfff2,0xfff2,0xfff3,
    0xfff2,0xfff2,0xfff1,0xfff3,0xfff3,0xfff3,0xfff3,0xfff4,
    0xfff3,0xfff4,0xfff3,0xfff3,0xfff3,0xfff3,0xfff3,0xfff5,
    0xfff2,0xfff4,0xfff4,0xfff3,0xfff4,0xfff4,0xfff3,0xfff4,
    0xfff3,0xfff2,0xfff5,0xfff3,0xfff5,0xfff4,0xfff4,0xfff4,
    0xfff4,0xfff4,0xfff4,0xfff4,0xfff4,0xfff4,0xfff4,0xfff4,
    0xfff5,0xfff3,0xfff5,0xfff3,0xfff4,0xfff4,0xfff4,0xfff4,
    0xfff3,0xfff4,0xfff5,0xfff5,0xfff4,0xfff5,0xfff5,0xfff5,
    0xfff4,0xfff5,0xfff3,0xfff5,0xfff4,0xfff4,0xfff4,0xfff5,
    0xfff4,0xfff5,0xfff4,0xfff4,0xfff5,0xfff4,0xfff4,0xfff5,
    0xfff7,0xfff4,0xfff6,0xfff5,0xfff5,0xfff6,0xfff3,0xfff5,
    0xfff5,0xfff4,0xfff5,0xfff4,0xfff5,0xfff5,0xfff6,0xfff5,
    0xfff5,0xfff4,0xfff5,0xfff5,0xfff5,0xfff5,0xfff5,0xfff7,
    0xfff7,0xfff7,0xfff6,0xfff7,0xfff7,0xfff8,0xfff7,0xfff8,
    0xfff7,0xfff8,0xfff7,0xfff8,0xfff7,0xfff6,0xfff8,0xfff7,
    0xfff9,0xfff8,0xfff8,0xfff8,0xfff8,0xfff8,0xfff8,0xfff8,
    0xfff8,0xfff9,0xfff8,0xfff7,0xfff9,0xfff7,0xfff8,0xfff8,
    0xfff7,0xfff9,0xfff7,0xfffa,0xfff7,0xfff7,0xfff8,0xfff8,
    0xfff8,0xfff8,0xfff8,0xfff8,0xfff9,0xfff8,0xfff7,0xfff9,
    0xfff9,0xfff8,0xfff9,0xfff7,0xfff8,0xfff8,0xfff7,0xfff8,
    0xfff7,0xfff8,0xfff8,0xfff8,0xfff9,0xfff7,0xfff8,0xfff8,
    0xfffa,0xfff7,0xfff9,0xfff8,0xfff8,0xfff7,0xfff9,0xfff8,
    0xfff8,0xfff8,0xfff9,0xfff7,0xfff8,0xfff9,0xfff8,0xfff8,
    0xfff9,0xfff9,0xfff7,0xfff9,0xfff8,0xfff8,0xfff9,0xfff8,
    0xfff9,0xfff9,0xfff9,0xfff9,0xfff9,0xfff9,0xfff9,0xfff9,
    0xfff9,0xfff8,0xfff9,0xfffa,0xfff9,0xfff8,0xfff9,0xfff8,
    0xfff9,0xfffa,0xfff9,0xfffa,0xfff9,0xfffa,0xfffb,0xfff9,
    0xfffa,0xfff9,0xfffb,0xfffa,0xfffb,0xfffa,0xfffa,0xfffa,
    0xfff9,0xfffa,0xfffa,0xfffa
};
#endif
