#!/bin/bash
#
#   userful-dm.sh
#
#   This is a simple Display Manager using xkeepalive and handles "auto",
#   "remote" and "urls" login sessions. Local login sessions are handled by general
#   Display Manager such as GDM and XDM.
#
#   Copyright (c) 2002-2009 Userful Corporation. All rights reserved.
#   Jason Kim <jason@userful.com>
#
# Called from: dm-start-display-manager.sh
# Call: remote-login.sh, auto-login.py, urls-login.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
LOGIN_TYPE=$1
KEEPALIVE=/opt/userful/bin/keepalive

echo "`date +"%b %d %T"` [$ProgramName]: Starting Userful's simple Display Manager. This is a Master process..." >> $logfile

if [ -f /tmp/distro.conf ]; then
    source /tmp/distro.conf
fi
# find the number of station
# /etc/X11/stations - number of available video heads
# /etc/stations - number from the license key
if [ -f /etc/X11/stations ]; then
    ALL_STATIONS=`cat /etc/X11/stations`
else
    echo "`date +"%b %d %T"` [$ProgramName](error): Unable to find /etc/X11/stations" >> $logfile
    exit 1
fi

if [ -f /etc/stations ]; then
    LICENSED_STATIONS=`cat /etc/stations`

    if [ $LICENSED_STATIONS -ge $ALL_STATIONS ]; then
	    STATIONS_NO=$ALL_STATIONS
    else
	    STATIONS_NO=$LICENSED_STATIONS
    fi

else
	STATIONS_NO=$ALL_STATIONS
fi

# delete all pid file for userful-usbinput-config (Press F-Key program)
rm -f /var/run/pid.kbdlink*


if [[ ! -d /var/log/dm ]]; then
    mkdir /var/log/dm
fi

##
## Start session
##
if [ "$LOGIN_TYPE" == "auto" -o "$LOGIN_TYPE" == "remote" -o "$LOGIN_TYPE" == "urls" ]; then

    if [ "$URLS_1ST_STN" == "disable" ]; then
        # Skip the first station if URLS_1ST_STN is disable.  
        # GDM in Ubuntu 9.10 starts the first local display always.
        START_STN=1
    else
        START_STN=0
    fi

    for (( N=$START_STN ; N < $STATIONS_NO ; N++ )) ;  do
        ## Backup log file and delete log files older than 30 days
	    LOGIN_LOG="$LOGIN_TYPE-login-$N.log"
	    mv --backup=numbered /var/log/dm/$LOGIN_LOG /var/log/dm/$LOGIN_LOG.old
	    find /var/log/dm/ -name "$LOGIN_LOG.old*" -mtime +30 -exec rm -f \{\} \;

        echo "`date +"%b %d %T"` [$ProgramName]: Starting $LOGIN_TYPE Login session for DISPLAY=:$N" >> $logfile

        if [[ "$LOGIN_TYPE" == "auto" ]]; then
            ## Start auto login session
	        $KEEPALIVE /opt/userful/bin/auto-login.py :$N >> /var/log/dm/$LOGIN_LOG 2>&1 &

        elif [[ "$LOGIN_TYPE" == "remote" ]]; then
	        $KEEPALIVE /opt/userful/bin/remote-login.sh :$N >> /var/log/dm/$LOGIN_LOG 2>&1 &

        elif [[ "$LOGIN_TYPE" == "urls" ]]; then
	        $KEEPALIVE /opt/userful/bin/urls-login.sh :$N >> /var/log/dm/$LOGIN_LOG 2>&1 &
        fi

        sleep 2
    done

else
    echo "`date +"%b %d %T"` [$ProgramName](error): Unsupport login type: $LOGIN_TYPE" >> $logfile
    exit 1
fi

wait
