#!/bin/bash
userful() {
   # we cannot just use $0 because script can be sourced
   echo "$(dirname "$SELF")"
}
# This function will generate function
# cfg.sreen.1 () { r1280x1024=( 50.0 ) r1280x960=( 52.0 ) }
# based on content of parsed file
# Example:
# . /home/ikhlopotov/dev/umx-utils/scripts/parse-xrandr.sh
# parse-xrandr "/home/ikhlopotov/dev/xrandr_short.log"
# cfg.screen.0
# echo "$r800x600"
# cfg.screen.1
# echo "$r800x600"
# This function must be invoked in a local process
parse-xrandr () {
    local IFS=$'\n' && local array=( $(<$1) ) # convert to line-array
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]//  / } )               # remove spaces
    array=( ${array[*]// /=\(} )               # remove spaces
    array=( ${array[*]/#=\(/r})             # convert item to array
    # we will use minimal possible refresh rate here
    array=( ${array[*]/%\.0*/\.0\);} )     # convert item to array
	array=( ${array[*]/#'Screen=('/$'}^\n cfg_screen_'} ) # set screen prefix
    array=( ${array[*]//default*/} )       # remove default connected statements
    array=( ${array[*]//\:*/\(\)\{ } )         # remove everything after :
    array=( ${array[*]/# \(/\(} )         # remove first element '('
    array[0]=''                            # remove first element '}'
    if [ 2 -lt "${#array[*]}" ]; then
		array[${#array[*]} + 1]=$'}'            # add the last brace
	    # split functions from 'array' and put it in elements of 'functions'
		local functions=( $(printf "%s" "${array[@]}" | tr '^' '\n' ) )
		local number_of_screens=${#functions[*]}
		# eval all generated functions
		local i
		for (( i=0; i<=$number_of_screens-1; i++ ))
		do  
			eval "$(echo ${functions[$i]})" # 2> /dev/null   # eval the result
		done
		return $number_of_screens
    else
		return 0 # empty file
    fi
}

function xrandr() {
    local TEMP_XORG_CONF=$1
    local XRANDR_LOG=$2
    local SCREEN=99
    XRANDR="$(userful)/xrandr.sh $XRANDR_LOG"
    CMD="xinit -e $XRANDR -- :$SCREEN -config $TEMP_XORG_CONF"
    >"$XRANDR_LOG" # clear the log
    if [ "true" == "$TEST" ];then
		$(simulate "$CMD")
    else
		`$CMD  &>/dev/null`
    fi
}
# TODO
function usage() {
    echo $(basename $0) 
}
function modeline() {
    local MODE=$1
    local X=$2
    local Y=$3
    local REFRESH=$4
    if [ "MODE" == "gtf" ]; then
		echo `gtf $X $Y $REFRESH -x | grep Modeline`
    else
	# default mode cvt
		echo `cvt $X $Y $REFRESH | grep Modeline` 
    fi
}

function resolutions.gen() {
    local MODE=$1
    IFS=$' ' && local RESOLUTIONS=($2) # convert to array
    local MONITOR_IDX=$3
    local PREFIX=$4
    cfg_screen_$MONITOR_IDX # open section from xorg.conf
    local GENERATED=""
    local RESOLUTION
    for RESOLUTION in "${RESOLUTIONS[@]}"
    do  
		local X=${RESOLUTION/%x*/} # everything before x
		local Y=${RESOLUTION/#*x/} # everytnimg after x
		local VAR=\$r$RESOLUTION   # construct name of variable
		local VALUE=`eval "echo  \"$VAR\""`   # eval the result
		if [ -n "$VALUE" ]; then # check if monitor support resolution
		    local Modeline=$(modeline $MODE $X $Y $VALUE)
		    GENERATED="$GENERATED$PREFIX^$MONITOR_IDX^$X^$Y^'$Modeline'"$'\n'
		fi
    done
    unset cfg_screen_$i # close section
    echo "$GENERATED"
}

function resolutions.supported() {
    echo "640x480 800x600 1024x768 1280x1024"
}
mvgainfo.busid() {
    echo `echo $1 | cut -d"^" -f1`
}
mvgainfo.vendor() {
    echo `echo $1 | cut -d"^" -f2`
}
mvgainfo.board() {
    echo `echo $1 | cut -d"^" -f3`
}
mvgainfo.driver() {
    echo `echo $1 | cut -d"^" -f4`
}
mvgainfo.heads() {
    echo `echo $1 | cut -d"^" -f5`
}
mvgainfo.vendor_id() {
    echo `echo $1 | cut -d"^" -f6 | cut -d":" -f1`
}
mvgainfo.product_id() {
    echo `echo $1 | cut -d"^" -f6 | cut -d":" -f2`
}

function probe() {
    local MVGAINFO=$1
    local XRANDR_LOG=$2
    local MODE=$3
    local SCREEN=99
    local RESs=$(resolutions.supported)
    local ALL_MONITORS=""
    while read VIDEOCARD; do
		NUMBER_OF_HEADS=$(mvgainfo.heads "$VIDEOCARD")
		TEMP_XORG_CONF=$(mktemp /tmp/xorg.conf.XXXXXXXX)
		$(xorg "$TEMP_XORG_CONF" "$VIDEOCARD")
		$(xrandr "$TEMP_XORG_CONF" "$XRANDR_LOG") 
		BUSID=$(mvgainfo.busid "$VIDEOCARD")
		parse-xrandr "$XRANDR_LOG" "$BUSID."
		NUMBER_OF_SCREENS=$?
		for ((i=0;i<=$NUMBER_OF_SCREENS-1; i++))
		do
			local MONITORS=$(resolutions.gen "$MODE" "$RESs" $i "$BUSID")
			ALL_MONITORS="$ALL_MONITORS$MONITORS"$'\n'
		done
		rm $TEMP_XORG_CONF
    done < $MVGAINFO
    echo "$ALL_MONITORS"
    return 0
}

xorg.flags() {
    local OUTFILE=$1
    (
	cat <<EOF
######################
# ServerFlagsSection
######################
Section "ServerFlags"
    Option  "Xinerama"    "off" 
    Option  "RandR"       "on"       
EndSection
EOF
	) >> $OUTFILE
}

xorg.layout() {
    local OUTFILE=$1
    local NUMBER_OF_SCREENS=$2
    local SCREENS=""
    for ((i=0;i<=$NUMBER_OF_SCREENS-1; i++))
    do
	SCREENS="$SCREENS    Screen      $i  \"Screen$i\" 0 0"$'\n'
    done
    (
	cat <<EOF
######################
# Layout Section
######################
Section "ServerLayout"
    Identifier     "Layout"
${SCREENS}
    InputDevice    "Keyboard0" "CoreKeyboard"
    InputDevice    "Mouse0" "CorePointer"
EndSection
EOF
	) >> $OUTFILE
}

xorg.input() {
    local OUTFILE=$1
    (
	cat <<EOF
######################
# Input Section
######################
Section "InputDevice"
    Identifier     "Mouse0"
    Driver         "mouse"
    Option         "Protocol" "auto"
    Option         "Device" "/dev/input/mice"
EndSection

Section "InputDevice"
    Identifier     "Keyboard0"
    Driver         "kbd"
EndSection
EOF
	) >> $OUTFILE
}

xorg.files() {
    local OUTFILE=$1
    (
	cat <<EOF
######################
# Files Section
######################
Section "Files"
EndSection
EOF
	) >> $OUTFILE
}

xorg.monitor() {
    local OUTFILE=$1
    local NUMBER_OF_MONITORS=$2
    local MONITORS=""
    for ((i=0;i<=$NUMBER_OF_MONITORS-1; i++))
    do
	MONITORS="$MONITORS"\
'Section "Monitor" 
    Option         "DPMS"
    Identifier     "Monitor'$i'"
    VendorName     "Unknown"
    ModelName      "Unknown"
    HorizSync       28.0 - 78.0
    VertRefresh     43.0 - 75.0
EndSection
'
    done
    (
	cat <<EOF
######################
# Monitor Section 
######################
$MONITORS
EOF
	) >> $OUTFILE    
}

xorg.screen() {
    local OUTFILE=$1
    local NUMBER_OF_SCREENS=$2
    local SCREENS=""
    for ((i=0;i<=$NUMBER_OF_SCREENS-1; i++))
    do
	SCREENS="$SCREENS"\
'Section "Screen"
    Identifier     "Screen'$i'"
    Device         "Videocard'$i'"
    Monitor        "Monitor'$i'"
    DefaultDepth    16
    SubSection     "Display"
        Depth       8
    EndSubSection
    SubSection     "Display"
        Depth       15
    EndSubSection
    SubSection     "Display"
        Depth       16
    EndSubSection
    SubSection     "Display"
        Depth       24
    EndSubSection
EndSection
'
    done
    (
	cat <<EOF
######################
# Screen Section
######################
$SCREENS
EOF
	) >> $OUTFILE    
}
xorg.device() {
    local OUTFILE=$1
    local VIDEOCARD=$2
    local NUMBER_OF_HEADS=$(mvgainfo.heads "$VIDEOCARD")
    local DRIVER=$(mvgainfo.driver "$VIDEOCARD")
    local VENDOR=$(mvgainfo.vendor "$VIDEOCARD")
    local BOARD=$(mvgainfo.board "$VIDEOCARD")
    local BUSID=$(mvgainfo.busid "$VIDEOCARD")

    for ((i=0;i<=$NUMBER_OF_HEADS-1; i++))
    do
	DEVICES="$DEVICES"\
'Section "Device"
    Identifier     "Videocard'$i'"
    Driver         "'$DRIVER'"
    VendorName     "'$VENDOR'"
    BoardName      "'$BOARD'"
    BusID          "PCI:'$BUSID'"
    Screen         '$i'
EndSection
'
    done
    (
	cat <<EOF
######################
# Device Section
######################
$DEVICES
EOF
	) >> $OUTFILE
}

xorg() {
    local OUTFILE=$1
    local VIDEOCARD=$2
    local NUMBER_OF_HEADS=$(mvgainfo.heads "$VIDEOCARD")
    # Generate X config file
    echo > $TEMP_XORG_CONF 
	$(xorg.flags "$TEMP_XORG_CONF")
    $(xorg.files "$TEMP_XORG_CONF")
    $(xorg.monitor "$TEMP_XORG_CONF" $NUMBER_OF_HEADS)
    $(xorg.device "$TEMP_XORG_CONF" "$VIDEOCARD")
    $(xorg.screen "$TEMP_XORG_CONF" $NUMBER_OF_HEADS)
    $(xorg.input "$TEMP_XORG_CONF")
    $(xorg.layout "$TEMP_XORG_CONF" $NUMBER_OF_HEADS)
}

# =====================
# Script start here
# ---------------------
# Unhandled remaining arguments are in $@
main () {
    echo starting... $VERBOSE "$PROBE" $@    
    if [ "true" == "$GEN" ]; then
       # $(xorg.regenerate)
       exit
    fi
    if [ "true" == "$PROBE" ]; then
	echo probing...
	local TEMP_XRANDR_LOG=$(mktemp /tmp/xrandr.log.XXXXXXXX)
	local MONITORS=$(probe "/etc/mvgainfo" "$TEMP_XRANDR_LOG" cvt)
	rm $TEMP_XRANDR_LOG
	(
	    cat <<EOF
$MONITORS
EOF
	    ) > /etc/X11/monitors.conf
        exit
    fi
}
# --------------
# End of script
# ==============



# =====================
# Boiler plate
# ---------------------
# Parse options
GETOPT=`getopt -o thvsgp: \
    --long test,help,verbose,self:,gen,probe \
    -n $(basename $0) -- "$@"`

if [ $? -ne 0 ]; then
    usage
fi

eval set -- "$GETOPT"
SELF=$0
while [ "$1" != "" ]; do
    case "$1" in
        -t | --test )     TEST="true";;
        -s | --self )     SELF="$2";shift;; # we need it for testing
        -v | --verbose )  VERBOSE="true";;  # TODO
        -g | --gen )      GEN="true";;
#        -i | --init )     INIT="true";MONITOR="$2";shift;; # MONITOR="3:7:0^0"
        -p | --probe )    PROBE="true";;
        -h | --help )     help; exit;;
	--)               break ;;
        * )               usage; exit 1
    esac
    shift
done

if [ -z "$TEST" ]; then    
    #"Remaining arguments:"
    main "${@/--}"
fi

