#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: plug-inputdev.sh
# Author: Jason Kim
# Description:
#    This script is called from "add" section of input.agent. It updates usbinput and
#  sends signal to GUI, daemons and X.
#
###################################################################################

logfile="/var/log/userful-start.log"
usbinput_logfile="/var/log/usbinput.log"
ProgramName=`basename $0`
LOCK_FILE="/tmp/usbinput.lock"
PHYS=

if [ ! -e /var/run/x.pid -o ! -d /proc/`cat /var/run/x.pid` ]; then
	# If X is not running, just exit.
	exit 1
fi

if [ -f /etc/sysconfig/xtype ]; then
	. /etc/sysconfig/xtype
	if [ "$XTYPE" = "SINGLE" -o "$XTYPE" = "single" ]; then
		# If normal X is running, just exit.
		exit 1
	fi
fi

# remove " from the $1
PHYS=`echo $1 | tr -d "\""`

echo "`date +"%b %d %T"` $ProgramName: Add new device $PHYS" >> $usbinput_logfile
echo "`date +"%b %d %T"` $ProgramName: Add new device $PHYS" >> $logfile

##
## /etc/usbinput should be accessed exclusively.
while ! (set -C; : > $LOCK_FILE) 2> /dev/null; do
	sleep 0.2
done

# Check the device config type.  If it is static, use static configration.
if [[ -f /etc/userful/umx.conf ]]; then
    sed -e "s/^\[/#\[/g" /etc/userful/umx.conf > /tmp/umx.conf.tmp
    source /tmp/umx.conf.tmp
fi

if [ "$DEVCONF" == "static" ]; then
    if [ -f /etc/usbinput.static ]; then
        cp -f /etc/usbinput.static /etc/usbinput
    fi
fi

# update /etc/usbinput
/opt/userful/bin/make-config-file -r

# Check Mandatory device
if [ -f /opt/userful/bin/umx-mandatory-dev-refresh.sh ]; then
    /opt/userful/bin/umx-mandatory-dev-refresh.sh
fi

#delete lock file
rm -f $LOCK_FILE

# send signal to X to reopen the input devices
pkill -USR2 MXSigDaemon
# send signal to GUI and kbd/mse daemons
pkill -USR2 kbd-daemon
pkill -USR2 mse-daemon

