#!/bin/bash

# Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
# http://www.userful.com/

# userful-runasroot.sh

# This is a wrapper script to run about-dialog.py as root based on the 
# available "su" program.

if [ -f /opt/userful/debug ] ; then
	DEBUG=1
fi

# for Userful Desktop admin mode support
if [ -x /opt/userful/bin/run-admin-prog.sh ] ; then
	if [ -n "$STATION" ] ; then
		if [ -f /opt/userful/locks/adminfile$STATION ] ; then
			suexec /opt/userful/bin/run-admin-prog.sh /usr/share/umx-utils/control-panel.py && exit 0
		else
			[ -n "$DEBUG" ] && echo "${0##*/}: admin lock file not present, not in admin mode"
		fi
	else
		[ -n "$DEBUG" ] && echo "${0##*/}: ERROR: station variable is not defined - not being run from UD desktop"
	fi
else
	[ -n "$DEBUG" ] && echo "${0##*/}: there is no /opt/userful/bin/run-admin-prog.sh, this is probably not a UD"
fi

# try to find something to help us run the control panel as root
if which gksu > /dev/null 2>&1; then
	exec gksu /usr/share/umx-utils/control-panel.py
elif which kdesu > /dev/null 2>&1; then
	exec kdesu /usr/share/umx-utils/control-panel.py
else
	exec /opt/userful/bin/dm-runasroot /usr/share/umx-utils/control-panel.py
fi

