#!/bin/bash
function userful() {
   # we cannot just use $0 because script can be sourced
	if [ -n "$SELF" ]; then
		echo "$(dirname "$SELF")"
	else
		echo "$(dirname "$0")"		
	fi
}

function abs() {
    echo $(cd `dirname $0` && pwd)	
}
function home() {
	echo $(cd ~ && pwd)
}
logfile="/var/log/userful-start.log" 
source "$(userful)/userful-bash-lib.sh"
function global_storage() {
	local Storage="/etc/userful/setup/gconf.storage"
	if [ -n "$TEST" ]; then
		local Prefix="$(abs $(userful)/../tests/root)/$Storage"
		mkdir -p "$Prefix"
		Storage="$Prefix/$Storage"
	fi
	echo "$Storage"
}
# Assume that scripts was runned by correct user 
function local_storage() {
	local Storage="$(home)/.gconf/gconf.storage"
	if [ -n "$TEST" ]; then
		local Prefix="$(abs $(userful)/../tests/root)/$Storage"
		mkdir -p "$Prefix"
		Storage="$Prefix/$Storage"
	fi
	echo "$Storage"
}

function default_config() {
	local Storage="/etc/gconf/gconf.xml.defaults"
	if [ -n "$TEST" ]; then
		local Prefix="$(abs $(userful)/../tests/root)/$Storage"
		mkdir -p "$Prefix"
		Storage="$Prefix/$Storage"
	fi
	echo "$Storage"
}

function save() {
	local Mode=$1
	local Key=$2
	local Type=$3
	local Value=$4
	local Flags=""
	local Storage="$(local_storage)"
	if [ "$Mode" == "direct" ]; then
		Flags="--direct --config-source xml:readwrite:$(default_config)"
		Storage="$(global_storage)"
	fi
	GCONF_VALUE=`gconftool-2 --get $Key 2> /dev/null`

	if [[ -n "$GCONF_VALUE" && "$GCONF_VALUE" != "$Value" ]]; then
		log "Changing gconf key \"%s\" (%s): \"%s\" -> \"%s\"" \
			"$Key" "$Type" "$GCONF_VALUE" "$Value"
		$(storage_save "$Key" "$Type" "$GCONF_VALUE" "$Storage")
		gconftool-2 $Flags --type $Type --set $Key $Value
	fi 
}

function restore() {
	local Mode=$1
	local Key=$2
	local Flags=""
	local Storage="$(local_storage)"
	if [ "$Mode" == direct ]; then
		Flags="--direct --config-source xml:readwrite:$(default_config)"
		Storage="$(global_storage)"
	fi
	local Record=`cat $Storage | grep $Key`
	local Type=$(storage.type "$Record")
	local Value=$(storage.value "$Record")
	if [[ -n "$Type" && -n "$Value" ]]; then
		log "Restoring gconf key \"%s\" (%s): \"%s\"" "$Key" "$Type" "$Value"
		gconftool-2 $Flags --type $Type --set $Key $Value
	fi	
}

function restore_all() {
	local Mode=$1
	local Flags=""
	local Storage="$(local_storage)"
	if [ "$Mode" == direct ]; then
		Flags="--direct --config-source xml:readwrite:$(default_config)"
		Storage="$(global_storage)"
	fi
	
	while read Record
	do
		local Key="$(storage.key $Record)"
		local Type="$(storage.type $Record)"
		local Value="$(storage.value $Record)"
		log "Restoring gconf key \"%s\" (%s): \"%s\"" "$Key" "$Type" "$Value"
		gconftool-2 $Flags --type $Type --set $Key $Value
	done < $Storage
}

function storage.key() {
	echo `echo $1 | cut -s -d"^" -f1` 
}
function storage.type() {
	echo `echo $1 | cut -s -d"^" -f2` 
}
function storage.value() {
	echo `echo $1 | cut -s -d"^" -f3` 
}

function storage_save() {
	local Key=$1
	local Type=$2
	local Value=$3
	local Storage=$4
	if [ -f "$Storage" ]; then
#		sed -i -e "'/$Key^/d'" $Storage # remove old value
		cat "$Storage" | grep -v "$Key" > "$Storage"
	else 
		log "gconf storage doesn't exist creating new one: %s" "$Storage"
		touch "$Storage"
	fi
	echo "$Key^$Type^$Value" >> "$Storage"
}

# =====================
# Script start here
# ---------------------
# Unhandled remaining arguments are in $@
main () {
	if [ "true" == "$RESTORE_ALL" ]; then
		$(restore_all normal)
	fi
}

# --------------
# End of script
# ==============

# =====================
# Boiler plate
# ---------------------
# Parse options
GETOPT=`getopt -o thvsa: \
    --long test,help,verbose,self:,restore_all \
    -n $(basename $0) -- "$@"`

if [ $? -ne 0 ]; then
    usage
fi

eval set -- "$GETOPT"
SELF=$0
while [ "$1" != "" ]; do
    case "$1" in
        -t | --test )        TEST="true";;
        -s | --self )        SELF="$2";shift;; # we need it for testing
        -v | --verbose )     VERBOSE="true";;  # TODO
        -a | --restore_all ) RESTORE_ALL="true";;
        -h | --help )     help; exit;;
	--)               break ;;
        * )               usage; exit 1
    esac
    shift
done

if [ -z "$TEST" ]; then    
    #"Remaining arguments:"
    main "${@/--}"
fi
