package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;

public class ConfirmDialog {
	private Shell parent;
	private String message;
	private boolean confirm;

	public ConfirmDialog(Shell parent,String message){
		this.parent = parent;
		this.message = message;
		this.confirm = false;
	}
	
	public boolean confirm(){
		final Shell dialog = new Shell(this.parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		dialog.setLayout(new GridLayout(1, true));
		
		
		//========================================================================
		Composite labelComposite = new Composite(dialog, SWT.NONE);
		labelComposite.setLayout(new GridLayout(2, false));
		labelComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));    
		
		Label icon = new Label(labelComposite, SWT.NONE);
        Label message = new Label(labelComposite, SWT.NONE);
        icon.setImage(parent.getDisplay().getSystemImage(SWT.ICON_QUESTION));
        message.setText(this.message);
		
		
        //========================================================================           
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout(2,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;    
				
        Button buttonOk = new Button(buttons, SWT.PUSH);
        buttonOk.setLayoutData(data);
        buttonOk.setText(TuxGuitar.getProperty("yes"));
        buttonOk.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                confirm = true;
            }
        });
		
        Button buttonCancel = new Button(buttons, SWT.PUSH);
        buttonCancel.setLayoutData(data);
        buttonCancel.setText(TuxGuitar.getProperty("no"));
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                confirm = false;
            }
        });		
        
        dialog.pack();
        dialog.open();

        int x = this.parent.getBounds().x + (this.parent.getBounds().width - dialog.getSize().x) / 2;
        int y = this.parent.getBounds().y + (this.parent.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
        
        
        
		
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }

        }
		
		return this.confirm;
		
	}

}
