package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.models.Marker;

public class UndoableReplaceMeasures implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private UndoMarkers undoMarkers;
	private TracksMeasures undoTrackMeasures;
	private TracksMeasures redoTrackMeasures;
	private int count; 
	private int freeSpace;
	private long theMove;
	
	public UndoableReplaceMeasures(long p1,long p2){
    	Caret caret = getCaret();    	    	
    	this.doAction = UNDO_ACTION;
    	this.undoCaret = new UndoableCaretHelper();	    	    	    	    	
    	this.undoMarkers = new UndoMarkers();
    	this.undoTrackMeasures = TuxGuitar.instance().getSongManager().copyMeasures(p1,p2);
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}   
               
        for(int i = freeSpace;i < count;i ++){        	 
        	TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
        }		
        TuxGuitar.instance().getSongManager().replaceMeasures((TracksMeasures)redoTrackMeasures.clone(),theMove);
		
		TuxGuitar.instance().fireUpdate();
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}							

        for(int i = freeSpace;i < count;i ++){        	 
        	TuxGuitar.instance().getSongManager().removeLastMeasure();
        }				
        TuxGuitar.instance().getSongManager().replaceMeasures((TracksMeasures)undoTrackMeasures.clone(),0);
        
		TuxGuitar.instance().fireUpdate();
		this.undoMarkers.undo();	
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }

    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

    public UndoableReplaceMeasures endUndo(TracksMeasures tracksMeasures,int count,int freeSpace,long theMove){
    	this.redoCaret = new UndoableCaretHelper();
    	this.redoTrackMeasures = tracksMeasures;
    	this.count = count;
    	this.freeSpace = freeSpace;
    	this.theMove = theMove;
    	return this;
    }
        
    
    private class UndoMarkers{
    	private List markers;
    	
    	public UndoMarkers(){
    		this.markers = new ArrayList();    		
    		Iterator it = TuxGuitar.instance().getSongManager().getMarkers().iterator();
    		while(it.hasNext()){
    			this.markers.add(((Marker)it.next()).clone());
    		}
    	}
    	
    	public void undo(){    
    		TuxGuitar.instance().getSongManager().removeAllMarkers();
    		Iterator it = this.markers.iterator();
    		while(it.hasNext()){
    			Marker marker = (Marker)it.next();
    			TuxGuitar.instance().getSongManager().updateMarker((Marker)marker.clone());
    		}    		
    	}
    }    
}
