package org.herac.tuxguitar.gui.system.keybindings.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KeyBindingWriter {
	
	private static final String SHORTCUTS_TAG = "shortcuts";
	private static final String SHORTCUT_TAG = "shortcut";
	private static final String ACTION_ATTRIBUTE = "action";
	private static final String KEYS_ATTRIBUTE = "keys";
	
    public static void setBindings(Set keyBindings,String fileName) {    	
        File file = new File(fileName);
        
        Document doc = createDocument();
        setBindings(keyBindings,doc);
        saveDocument(doc,file);        
    }
    
    
    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } 
        return document;
    }        
    

    
    public static void saveDocument(Document document,File file) {
        try {
            FileOutputStream fs = new FileOutputStream(file);

            // Write it out again
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            Source input = new DOMSource(document);            
            Result output = new StreamResult(fs);
            idTransform.setOutputProperty(OutputKeys.INDENT, "yes");
            idTransform.transform(input, output);

        } catch (FactoryConfigurationError e) {
            e.printStackTrace();
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

    }

    /**
     * Write shortcuts to xml file
     * 
     * @param shortcutsNode
     * @return
     */
    private static void setBindings(Set keyBindings,Document document){    	
    	Node shortcutsNode = document.createElement(SHORTCUTS_TAG);

    	Iterator it = keyBindings.iterator();
    	while(it.hasNext()){
    		KeyBinding keyBinding = (KeyBinding) it.next();
    		String keyString = keyBinding.toString();
    		String actionString = TuxGuitar.instance().getkeyBindingManager().getActionForKeyBinding(keyBinding).getName();			
			
    		Node node = document.createElement(SHORTCUT_TAG);
    		shortcutsNode.appendChild(node);    
    	
    		Attr keyAttr = document.createAttribute(KEYS_ATTRIBUTE);
    		Attr ActionAttr = document.createAttribute(ACTION_ATTRIBUTE);    	

    		keyAttr.setNodeValue(keyString);
    		ActionAttr.setNodeValue(actionString);
    	
    		node.getAttributes().setNamedItem(keyAttr);
    		node.getAttributes().setNamedItem(ActionAttr);
    	}
    	document.appendChild(shortcutsNode);    
    }
    
}
