/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.system.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.system.config.items.LanguageOption;
import org.herac.tuxguitar.gui.system.config.items.MainOption;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.system.config.items.StylesOption;
import org.herac.tuxguitar.gui.system.config.items.ToolBarsOption;
import org.herac.tuxguitar.gui.util.ConfirmDialog;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ConfigEditor{

    private ConfigManager config;
    private Shell dialog;
    private List options;
    
    public ConfigEditor() {        
        this.config = TuxGuitar.instance().getConfig();        
    }

    public void showDialog(Shell shell) {
            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);           

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("settings.config"));

            //-------main-------------------------------------         
            Composite mainComposite = new Composite(dialog,SWT.NONE);
            mainComposite.setLayout(new GridLayout(2,false));
            createComposites(mainComposite);
            
            //-------buttons-------------------------------------

            Composite buttonComposite = new Composite(dialog,SWT.NONE);
            buttonComposite.setLayout(new GridLayout(3,true));
            buttonComposite.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));                          
            

            Button buttonDefaults = new Button(buttonComposite, SWT.PUSH);
            buttonDefaults.setLayoutData(makeGridData(80,25)); 
            buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
            buttonDefaults.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    config.setDefaults();
                    TuxGuitar.instance().getItemManager().saveDefaultToolBars();
                    if(new ConfirmDialog(dialog,TuxGuitar.getProperty("settings.config.apply-changes-question")).confirm()){
                    	applyConfig(true);
                    }                    
                	dialog.dispose();
                }
            });

            
            Button buttonOK = new Button(buttonComposite, SWT.PUSH);
            buttonOK.setLayoutData(makeGridData(80,25)); 
            buttonOK.setText(TuxGuitar.getProperty("ok"));             
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    updateOptions();                    
                    if(new ConfirmDialog(dialog,TuxGuitar.getProperty("settings.config.apply-changes-question")).confirm()){
                    	applyConfig(false);
                    }
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttonComposite, SWT.PUSH);
            buttonCancel.setLayoutData(makeGridData(80,25)); 
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
    }

	private void createComposites(Composite parent) {	    
		ToolBar toolBar = new ToolBar(parent, SWT.VERTICAL | SWT.FLAT | SWT.WRAP);
		toolBar.setLayoutData(makeGridData(60,350));
			
	    Composite option = new Composite(parent,SWT.NONE);	
	    option.setLayout(new FormLayout());
	    option.setLayoutData(makeGridData(250,350));
	    
	    initOptions(toolBar,option);		
	    if(this.options.size() > 0){
	    	select((Option)options.get(0));
	    }
	}

	private void initOptions(ToolBar toolBar,Composite parent){		
		this.options = new ArrayList();
	    this.options.add(new MainOption(this,toolBar,parent));
	    this.options.add(new StylesOption(this,toolBar,parent));	    	    
	    this.options.add(new LanguageOption(this,toolBar,parent));
	    this.options.add(new ToolBarsOption(this,toolBar,parent));
	    
	    Option sound = TuxGuitar.instance().getPlayer().getConfigOption(this,toolBar,parent);
	    if(sound != null){
	    	this.options.add(sound);
	    }
	    
	    Iterator it = this.options.iterator();
	    while(it.hasNext()){
	    	Option option = (Option)it.next();
	    	option.createOption();		   
		}
	}
	
	public GridData makeGridData(int minWith,int minHeight){
		return makeGridData(0,0,minWith,minHeight);
	}
	
	public  GridData makeGridData(int with,int height,int minWith,int minHeight){   
    	GridData data = new GridData();    	
    	data.minimumWidth = minWith;
    	data.minimumHeight = minHeight;
    	if(with > 0){
    		data.widthHint = with;
    	}else{
    		data.horizontalAlignment = SWT.FILL;
    		data.grabExcessHorizontalSpace = true;
    	}
    	if(height > 0){
    		data.heightHint = with;
    	}else{
    		data.verticalAlignment = SWT.FILL;
    		data.grabExcessVerticalSpace = true;
    	}
    	
    	return data;
	}


    public void select(Option option){
        hideAll();
        option.setVisible(true);
        dialog.layout();
    }
    
    private void hideAll(){
	    Iterator it = this.options.iterator();
	    while(it.hasNext()){
	    	Option option = (Option)it.next();
	    	option.setVisible(false);
		}
    }

    private void updateOptions(){        
	    Iterator it = this.options.iterator();
	    while(it.hasNext()){
	    	Option option = (Option)it.next();
	    	option.updateConfig();
		}    	
        this.config.save();
    }
    
    private void applyConfig(boolean force){        
	    Iterator it = this.options.iterator();
	    while(it.hasNext()){
	    	Option option = (Option)it.next();
	    	option.applyConfig(force);
		}    
    	TuxGuitar.instance().fireUpdate();
    	TuxGuitar.instance().redraw();        
    }
    
    public ConfigManager getConfig(){
        return this.config;
    }
    
    public TablatureEditor getEditor(){
        return TuxGuitar.instance().getTablatureEditor();
    }
    
}
