/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.composition.ChangeTempoAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTimeSignatureAction;
import org.herac.tuxguitar.gui.actions.insert.CloseRepeatAction;
import org.herac.tuxguitar.gui.actions.insert.OpenRepeatAction;
import org.herac.tuxguitar.gui.items.ToolItems;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CompositionToolItems extends ToolItems{
    public static final String NAME = "composition.items";

    private ToolBar toolBar;   
    private ToolItem tempo;
    private ToolItem timeSignature;
    private ToolItem openRepeat;    
    private ToolItem closeRepeat;
    
    public CompositionToolItems(){    
    	super(NAME);
    }
   
    public void showItems(ToolBar toolBar){
    	this.toolBar = toolBar;
    	
        this.tempo = new ToolItem(toolBar, SWT.PUSH);        
        this.tempo.setImage(SystemImages.TEMPO_ICON_IMAGE);
        this.tempo.addSelectionListener(TuxGuitar.instance().getAction(ChangeTempoAction.NAME));
    	
        this.timeSignature = new ToolItem(toolBar, SWT.PUSH);        
        this.timeSignature.setImage(SystemImages.TIME_SIGNATURE_IMAGE);
        this.timeSignature.addSelectionListener(TuxGuitar.instance().getAction(ChangeTimeSignatureAction.NAME));
        
        new ToolItem(toolBar, SWT.SEPARATOR);
        
        this.openRepeat = new ToolItem(toolBar, SWT.PUSH);
        this.openRepeat.setImage(SystemImages.OPEN_REPEAT_IMAGE);
        this.openRepeat.addSelectionListener(TuxGuitar.instance().getAction(OpenRepeatAction.NAME));            
        
        this.closeRepeat = new ToolItem(toolBar, SWT.PUSH);
        this.closeRepeat.setImage(SystemImages.CLOSE_REPEAT_IMAGE);
        this.closeRepeat.addSelectionListener(TuxGuitar.instance().getAction(CloseRepeatAction.NAME));        
        
        this.loadProperties();
    }

    public void loadProperties(){
    	this.tempo.setToolTipText(TuxGuitar.getProperty("composition.tempo"));
        this.timeSignature.setToolTipText(TuxGuitar.getProperty("composition.timesignature"));
        this.openRepeat.setToolTipText(TuxGuitar.getProperty("repeat.open"));
        this.closeRepeat.setToolTipText(TuxGuitar.getProperty("repeat.close"));          
    }
    
    public void update(){
    }
}

