/*
 * Created on 28-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.effects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.BendEffect;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class BendEditor{
    public static final int X_SPAN = 30;
    public static final int Y_SPAN = 15;    
    private static final int X_LENGTH = BendEffect.MAX_POSITION_LENGTH + 1;
    private static final int Y_LENGTH = BendEffect.MAX_VALUE_LENGTH + 1;

    private Composite editor;
    private int[] x; 
    private int[] y;
    private int width;
    private int height;    
    private List points;
    
    private DefaultBend[] defaultBends;
    private boolean isEditing;    
    
    private BendEffect result;
    
    public BendEditor() {
        this.init();                
    }

    private void init(){
        this.x = new int[X_LENGTH];
        this.y = new int[Y_LENGTH];
        this.width = ((X_SPAN * X_LENGTH) - X_SPAN);
        this.height = ((Y_SPAN * Y_LENGTH) - Y_SPAN);
        this.points = new ArrayList();
        
        for(int i = 0;i < x.length;i++){
            this.x[i] = ((i + 1) * X_SPAN);            
        }
        for(int i = 0;i < y.length;i++){
            this.y[i] = ((i + 1) * Y_SPAN);
        }        
    }    
    
    public BendEffect show(Shell shell,final Note note){
        final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
   
        dialog.setLayout(new GridLayout());        
        dialog.setText(TuxGuitar.getProperty("bend.editor"));
        
        //----------------------------------------------------------------------
        Composite composite = new Composite(dialog,SWT.NONE);
        composite.setLayout(new GridLayout(3,false));
        composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));         
        
        Composite leftComposite = new Composite(composite,SWT.NONE); 
        leftComposite.setLayout(new GridLayout());              
        leftComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));        
        
        Composite rightComposite = new Composite(composite,SWT.NONE); 
        rightComposite.setLayout(new GridLayout());              
        rightComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));        
        
        //-------------EDITOR---------------------------------------------------        
        this.isEditing = (note.getEffect().isBend());                
        this.editor = new Composite(leftComposite, SWT.BORDER | SWT.DOUBLE_BUFFERED);
        this.editor.setBackground(editor.getDisplay().getSystemColor(SWT.COLOR_WHITE));        
        this.editor.setLayoutData(resizeData(new GridData(SWT.FILL,SWT.FILL,true,true) , getWidth() + (X_SPAN * 2),getHeight() + (Y_SPAN * 2))  );
        this.editor.addPaintListener(new PaintListener() {
            public void paintControl(PaintEvent e) {
                paintEditor(e.gc);
                e.gc.dispose();
            }
        });
        this.editor.addMouseListener(new MouseAdapter() {
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                checkPoint(e.x,e.y);
                editor.redraw();
            }
        });         
        if(isEditing){
            setBend(note.getEffect().getBend());
        }                

        //-------------DEFAULT BEND LIST---------------------------------------------------       
        final org.eclipse.swt.widgets.List defaultBendList = new org.eclipse.swt.widgets.List(rightComposite,SWT.BORDER);         
        this.resetDefaultBends();
        for(int i = 0;i < defaultBends.length;i++){
            defaultBendList.add(this.defaultBends[i].getName());
        }
        defaultBendList.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
        defaultBendList.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                if(!isEditing){
                    setBend(defaultBends[defaultBendList.getSelectionIndex()].getBend());
                    editor.redraw();
                }
                isEditing = false;
            }
        });                                    
 
        //------------------BUTTONS--------------------------  
        Button buttonClean = new Button(rightComposite, SWT.PUSH);
        buttonClean.setLayoutData(resizeData(new GridData(SWT.FILL,SWT.BOTTOM,true,true), 80,25));         
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = null;
                dialog.dispose();
            }
        });                
        Button buttonOK = new Button(rightComposite, SWT.PUSH);
        buttonOK.setLayoutData(resizeData(new GridData(SWT.FILL,SWT.BOTTOM,true,false), 80,25));         
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {  
            	result = getBend();
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(rightComposite, SWT.PUSH);
        buttonCancel.setLayoutData(resizeData(new GridData(SWT.FILL,SWT.BOTTOM,true,false), 80,25));         
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = note.getEffect().getBend();
                dialog.dispose();
            }
        });

        dialog.pack();
        int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;        
        dialog.setLocation(x, y);
        dialog.open(); 
        
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }
        }
	
		return result;		
        
    }    
    
    
    private GridData resizeData(GridData data,int minimumWidth,int minimumHeight){    
        data.minimumWidth = minimumWidth;
        data.minimumHeight = minimumHeight;    
        return data;
    }
    
    private void paintEditor(GC gc){        
        for(int i = 0;i < x.length;i++){
            this.setStyleX(gc,i);
            gc.drawLine(this.x[i],Y_SPAN,this.x[i],Y_SPAN + this.height);
        }
        for(int i = 0;i < y.length;i++){
            this.setStyleY(gc,i);
            gc.drawLine(X_SPAN,this.y[i],X_SPAN + this.width,this.y[i]);
        }       
        
        
        Iterator it = null;
        Point prevPoint = null;
        gc.setLineStyle(SWT.LINE_SOLID);
        gc.setLineWidth(2);
        gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_GRAY));        
        it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();            
            if(prevPoint != null){                                
                gc.drawLine(prevPoint.x,prevPoint.y,point.x,point.y);
            }            
            prevPoint = point;
        }        
        
        
        gc.setLineWidth(5);
        gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_BLACK));                                       
        it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();                       

            gc.drawRectangle(point.x - 2,point.y - 2,5,5);           
        }
        gc.setLineWidth(1);
    }


    
    private void setStyleX(GC gc,int i){
        gc.setLineStyle(SWT.LINE_SOLID);
        if(i == 0 || i == (X_LENGTH - 1)){
            gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_BLACK));
        }else{            
            gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_BLUE));
            if((i % 3) > 0){
                gc.setLineStyle(SWT.LINE_DOT);            
            }
        }
    }    
    
    private void setStyleY(GC gc,int i){
        gc.setLineStyle(SWT.LINE_SOLID);
        if(i == 0 || i == (Y_LENGTH - 1)){
            gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_BLACK));
        }else{         
            gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_RED));
        
            if((i % 2) > 0){
                gc.setLineStyle(SWT.LINE_DOT);
                gc.setForeground(this.editor.getDisplay().getSystemColor(SWT.COLOR_GRAY));
            }else if((i % 4) > 0){
                gc.setLineStyle(SWT.LINE_DOT);         
            }
        }
    }
    
    
    
    private void checkPoint(int x,int y){        
        Point point = new Point(this.getX(x),this.getY(y));
        if(!this.removePoint(point)){
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }
    
    private boolean removePoint(Point point){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point currPoint = (Point)it.next();
            if(currPoint.x == point.x && currPoint.y == point.y){
                this.points.remove(point);
                return true;
            }
        }  
        return false;
    }
    
    private void orderPoints(){
        for(int i = 0;i < this.points.size();i++){
            Point minPoint = null;
            for(int noteIdx = i;noteIdx < this.points.size();noteIdx++){
                Point point = (Point)this.points.get(noteIdx);
                if(minPoint == null || point.x < minPoint.x){
                    minPoint = point;
                }
            }
            this.points.remove(minPoint);
            this.points.add(i,minPoint);
        }
    }    
    
    private void removePointsAtXLine(int x){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();
            if(point.x == x){
                this.points.remove(point);
                break;
            }
        }  
    }     
    
    private void addPoint(Point point){
        this.points.add(point);
    }
    
    private int getX(int pointX){  
        int currPointX = -1;        
        for(int i = 0;i < this.x.length;i++){                    
            if(currPointX < 0){
                currPointX = this.x[i];
            }else{                    
                int distanceX = Math.abs(pointX - currPointX);
                int currDistanceX = Math.abs(pointX - this.x[i]);
                if(currDistanceX < distanceX){
                    currPointX = this.x[i];
                }
            }
            
        }
        return currPointX;
    }     
    
    private int getY(int pointY){  
        int currPointY = -1;        
        for(int i = 0;i < this.y.length;i++){                    
            if(currPointY < 0){
                currPointY = this.y[i];
            }else{                    
                int distanceX = Math.abs(pointY - currPointY);
                int currDistanceX = Math.abs(pointY - this.y[i]);
                if(currDistanceX < distanceX){
                    currPointY = this.y[i];
                }
            }
            
        }
        return currPointY;
    }  
    
    public boolean isEmpty(){
        return this.points.isEmpty();
    }
    
    public BendEffect getBend(){
    	if(this.points != null && !this.points.isEmpty()){
    		BendEffect bend = new BendEffect();    	
    		Iterator it = this.points.iterator();
    		while(it.hasNext()){
    			Point point = (Point)it.next();            
    			addBendPoint(bend,point);
    		}              
    		return bend;
    	}
    	return null;
    }
    
    private void addBendPoint(BendEffect effect,Point point){
        int position = 0;
        int value = 0;
        for(int i=0;i<this.x.length;i++){
            if(point.x == this.x[i]){
                position = i;
            }
        }
        for(int i=0;i<this.y.length;i++){
            if(point.y == this.y[i]){
                value = (this.y.length - i) -1;
            }
        }        
        effect.addPoint(position,value); 
    }
    
    
    public void setBend(BendEffect effect){
        this.points.clear();
        Iterator it = effect.getPoints().iterator();
        while(it.hasNext()){
            BendEffect.BendPoint bendPoint = (BendEffect.BendPoint)it.next();
            this.makePoint(bendPoint);
        }
    }
    
    private void makePoint(BendEffect.BendPoint bendPoint){
        int indexX = bendPoint.getPosition();
        int indexY = (this.y.length - bendPoint.getValue()) - 1;        
        if(indexX >= 0 && indexX < this.x.length && indexY >= 0 && indexY < this.y.length){
        	Point point = new Point(0,0);
        	point.x = this.x[indexX];
        	point.y = this.y[indexY];         
        	this.points.add(point);
        }
    }
    
    
    public int getWidth(){
        return this.width;        
    }
    
    public int getHeight(){
        return this.height;
    }
    
  
    private void resetDefaultBends(){
        this.defaultBends = new DefaultBend[5];
        
        this.defaultBends[0] = new DefaultBend(TuxGuitar.getProperty("bend.bend"),new BendEffect());        
        this.defaultBends[0].getBend().addPoint(0,0);
        this.defaultBends[0].getBend().addPoint(6,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[0].getBend().addPoint(12,(BendEffect.SEMITONE_LENGTH * 2));               
        
        this.defaultBends[1] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release"),new BendEffect());         
        this.defaultBends[1].getBend().addPoint(0,0);
        this.defaultBends[1].getBend().addPoint(3,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[1].getBend().addPoint(6,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[1].getBend().addPoint(9,0);
        this.defaultBends[1].getBend().addPoint(12,0);
                
        this.defaultBends[2] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release-bend"),new BendEffect());         
        this.defaultBends[2].getBend().addPoint(0,0);
        this.defaultBends[2].getBend().addPoint(2,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[2].getBend().addPoint(4,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[2].getBend().addPoint(6,0);
        this.defaultBends[2].getBend().addPoint(8,0);
        this.defaultBends[2].getBend().addPoint(10,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[2].getBend().addPoint(12,(BendEffect.SEMITONE_LENGTH * 2));
        
        this.defaultBends[3] = new DefaultBend(TuxGuitar.getProperty("bend.prebend"),new BendEffect());         
        this.defaultBends[3].getBend().addPoint(0,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[3].getBend().addPoint(12,(BendEffect.SEMITONE_LENGTH * 2));
        
        this.defaultBends[4] = new DefaultBend(TuxGuitar.getProperty("bend.prebend-release"),new BendEffect());         
        this.defaultBends[4].getBend().addPoint(0,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[4].getBend().addPoint(4,(BendEffect.SEMITONE_LENGTH * 2));
        this.defaultBends[4].getBend().addPoint(8,0);
        this.defaultBends[4].getBend().addPoint(12,0);
    }       
    

    
    private class DefaultBend{
        private String name;
        private BendEffect bend;
        
        public DefaultBend(String name,BendEffect bend){
            this.name = name;
            this.bend = bend;
        }                
        public BendEffect getBend() {
            return bend;
        }
        public String getName() {
            return name;
        }
    }        
}
