/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInfoTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInstrumentTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTrackPropertiesAction extends Action {
    public static final String NAME = "action.track.properties";
    
    private static final String[] NOTE_NAMES = new String[]{"C","C#","D","D#","E","F","F#","G","G#","A","Bb","B"};
    
	//private static final int MINIMUN_WIDTH = 200;
	//private static final int MINIMUN_HEIGHT = 10;	    
    
    private static final int MINIMUN_LEFT_CONTROLS_WIDTH = 180;
    
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;
    
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private Shell dialog;
    private Text nameText;
    private RGBColor trackColor;
    private List tempStrings;    
    private Spinner stringCountSpinner;
    private Combo[] stringCombos = new Combo[MAX_STRINGS];
    private Combo offsetCombo;
    private int stringCount;
    private Combo instrumentCombo;
    private Button percussionCheckBox;
    
    public ChangeTrackPropertiesAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        if (trackCoords != null) {
            this.stringCount = trackCoords.getTrack().getStrings().size();
            this.trackColor = (RGBColor) trackCoords.getTrack().getColor().clone();
            this.initTempStrings(trackCoords.getTrack().getStrings());

            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
            this.dialog.setLayout(new GridLayout());
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));
            
            Composite composite = new Composite(dialog,SWT.NONE);
            composite.setLayout(new GridLayout(2,false));
            composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            
            Composite left = new Composite(composite,SWT.NONE);
            left.setLayout(new GridLayout());
            left.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));            
            Composite right = new Composite(composite,SWT.NONE);
            right.setLayout(new GridLayout());
            right.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            Composite bottom = new Composite(dialog,SWT.NONE);
            bottom.setLayout(new GridLayout());
            bottom.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));            
            
            //GENERAL            
            initTrackInfo(makeGroup(left,1,TuxGuitar.getProperty("track.properties.general")), trackCoords);

            //INSTRUMENT
            initInstrumentFields(makeGroup(left,1,TuxGuitar.getProperty("instrument.instrument")), trackCoords);
            
            //TUNNING
            initTunningInfo(makeGroup(right,2,TuxGuitar.getProperty("tunning")), trackCoords);

            //BUTTONS
            initButtons(bottom);

            updateTunningGroup(!trackCoords.getTrack().isPercussionTrack());
            
            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
                        
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }
    
	private Group makeGroup(Composite parent,int horizontalSpan,String text){
        Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
        group.setLayoutData(makeGridData(horizontalSpan));
        group.setText(text);
        
        return group;
	}
	
	private GridData makeGridData(int horizontalSpan){
		GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);		
		data.horizontalSpan = horizontalSpan;		
		return data;
	}	

    private void initTrackInfo(Composite composite,SongTrackCoords trackCoords) {    	  	    	
    	composite.setLayout(new GridLayout(/*2,false*/));    	
        Composite top = new Composite(composite, SWT.NONE);
        top.setLayout(new GridLayout(/*2,false*/));
        top.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,true));        
        Composite bottom = new Composite(composite, SWT.NONE);
        bottom.setLayout(new GridLayout(/*2,false*/));
        bottom.setLayoutData(new GridData(SWT.FILL,SWT.BOTTOM,true,true));    	
    	
    	//-----------------------NAME---------------------------------
        Label nameLabel = new Label(top, SWT.NONE);
        nameLabel.setLayoutData(new GridData(SWT.FILL,SWT.CENTER,true,true));
        nameLabel.setText(TuxGuitar.getProperty("track.name") + ":");
              
        this.nameText = new Text(top, SWT.BORDER);
        nameText.setLayoutData(getAlignmentData(MINIMUN_LEFT_CONTROLS_WIDTH,SWT.FILL));
        nameText.setText(trackCoords.getTrack().getName());
        
        
        //-----------------------COLOR---------------------------------
        Label colorLabel = new Label(bottom, SWT.NONE);
        colorLabel.setText(TuxGuitar.getProperty("track.color") + ":");
        colorLabel.setLayoutData(new GridData(SWT.FILL,SWT.CENTER,true,true));
        
        final Button colorButton = new Button(bottom, SWT.PUSH);
        colorButton.setLayoutData(getAlignmentData(MINIMUN_LEFT_CONTROLS_WIDTH,SWT.FILL));
        colorButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(dialog);
                dlg.setRGB(dialog.getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                    trackColor.setR(rgb.red);
                    trackColor.setG(rgb.green);
                    trackColor.setB(rgb.blue);       
                    colorButton.redraw();
                }
            }
        });
        colorButton.addPaintListener(new PaintListener() {		
			public void paintControl(PaintEvent e) {
				Color color = new Color(dialog.getDisplay(), trackColor.getR(), trackColor.getG(), trackColor.getB());
		        e.gc.setBackground(color);
		        e.gc.fillRectangle(5,5,colorButton.getSize().x - 10,colorButton.getSize().y - 10);
		        color.dispose();
			}		
		});
       
    }

    private void initTunningInfo(Composite composite,SongTrackCoords trackCoords) {
    	composite.setLayout(new GridLayout(2,true));    	
        initTunningData(composite,trackCoords);
        initTunningCombos(composite);    	
    }

    private void initTunningCombos(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(/*MAX_STRINGS, false*/));
        composite.setLayoutData(new GridData(SWT.RIGHT,SWT.FILL,true,true));
        String[] tunningTexts = getAllValueNames();
        for (int i = 0; i < MAX_STRINGS; i++) {
            this.stringCombos[i] = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
            this.stringCombos[i].setItems(tunningTexts);
        }
    }

    private void initTunningData(Composite parent,SongTrackCoords trackCoords) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(/*2, false*/));    	
        composite.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,true));
        
        Composite top = new Composite(composite, SWT.NONE);
        top.setLayout(new GridLayout());
        top.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,true));
        
        Composite bottom = new Composite(composite, SWT.NONE);
        bottom.setLayout(new GridLayout());
        bottom.setLayoutData(new GridData(SWT.FILL,SWT.BOTTOM,true,true));
        
        //---------------------------------STRING--------------------------------        
        Label stringCountLabel = new Label(top, SWT.NONE);
        stringCountLabel.setText(TuxGuitar.getProperty("tunning.strings") + ":");
        stringCountLabel.setLayoutData(new GridData(SWT.LEFT,SWT.CENTER,true,true));
        
        this.stringCountSpinner = new Spinner(top, SWT.BORDER);
        stringCountSpinner.setLayoutData(getAlignmentData(80,SWT.FILL));
        stringCountSpinner.setMinimum(MIN_STRINGS);
        stringCountSpinner.setMaximum(MAX_STRINGS);
        stringCountSpinner.setSelection(this.stringCount);        
        stringCountSpinner.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                stringCount = stringCountSpinner.getSelection();
                setDefaultTunning();
                updateTunningGroup(!percussionCheckBox.getSelection());
            }
        });

        
        //---------------------------------OFFSET--------------------------------
        Label offsetLabel = new Label(bottom, SWT.NONE);
        offsetLabel.setText(TuxGuitar.getProperty("tunning.offset") + ":");
        offsetLabel.setLayoutData(new GridData(SWT.LEFT,SWT.CENTER,true,true));
        //offsetLabel.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));
        
        offsetCombo = new Combo(bottom, SWT.DROP_DOWN | SWT.READ_ONLY);
        offsetCombo.setLayoutData(getAlignmentData(80,SWT.LEFT));
        //offsetCombo.setLayoutData(new GridData(100,SWT.DEFAULT));
        for(int i = SongTrack.MIN_OFFSET;i <= SongTrack.MAX_OFFSET;i ++){
        	offsetCombo.add(Integer.toString(i));
        	if(i == trackCoords.getTrack().getOffset()){
        		offsetCombo.select(i - SongTrack.MIN_OFFSET);
        	}
        }               
    }

    private GridData getAlignmentData(int minimumWidth,int horizontalAlignment){
    	GridData data = new GridData();
    	data.minimumWidth = minimumWidth;
    	data.horizontalAlignment = horizontalAlignment;
    	data.verticalAlignment = SWT.DEFAULT;
    	data.grabExcessHorizontalSpace = true;
    	data.grabExcessVerticalSpace = true;
    	return data;
    }

    private void initButtons(final Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2,false));
        composite.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = MINIMUN_BUTTON_WIDTH;
        data.minimumHeight = MINIMUN_BUTTON_HEIGHT;
        
        Button buttonOK = new Button(composite, SWT.PUSH);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData(data);
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                updateTrackProperties();
                //--------------update and redraw------------------------------------------------------
                new SyncThread(new Runnable() {
                    public void run() {
                        if(!TuxGuitar.isDisposed()){
                        	updateTablature();
                        	TuxGuitar.instance().getMixer().update();
                        	redraw();                        
                        	dialog.dispose();
                        }
                    }
                }).start();
            }
        });

        Button buttonCancel = new Button(composite, SWT.PUSH);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(data);
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });

    }

    private void initInstrumentFields(Composite composite,SongTrackCoords trackCoords) {
    	composite.setLayout(new GridLayout(/*2,false*/));  
    	
        Composite top = new Composite(composite, SWT.NONE);
        top.setLayout(new GridLayout());
        top.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,true));
        
        Composite bottom = new Composite(composite, SWT.NONE);
        bottom.setLayout(new GridLayout());
        bottom.setLayoutData(new GridData(SWT.FILL,SWT.BOTTOM,true,true));    	
    	
        Instrument[] instruments = getInstruments();
        final SongTrack track = trackCoords.getTrack();
        //------------Instrument Combo-------------------------------------
        Label instrumentLabel = new Label(top, SWT.NONE);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument.instrument") + ":");
        instrumentLabel.setLayoutData(new GridData(SWT.FILL,SWT.CENTER,true,true));
        
        this.instrumentCombo = new Combo(top, SWT.DROP_DOWN | SWT.READ_ONLY);
        this.instrumentCombo.setLayoutData(getAlignmentData(MINIMUN_LEFT_CONTROLS_WIDTH,SWT.FILL));
        if (instruments != null) {
            int count = instruments.length;
            if (count > 128) {
                count = 128;
            }
            for (int i = 0; i < count; i++) {
                instruments[i].getName();
                instrumentCombo.add(instruments[i].getName());
            }
            instrumentCombo.select(track.getChannel().getInstrument());
        }
        instrumentCombo.setEnabled(!track.isPercussionTrack() && instruments != null);

        //--------------------Precusion CheckBox-------------------------------
        //GridData gridData = new GridData();
        //gridData.horizontalSpan = 2;
        this.percussionCheckBox = new Button(bottom, SWT.CHECK);
        this.percussionCheckBox.setText(TuxGuitar.getProperty("instrument.percussion-track"));
        this.percussionCheckBox.setLayoutData(new GridData(SWT.FILL,SWT.CENTER,true,true));
        //percussionCheckBox.setLayoutData(gridData);
        if (instruments != null) {
            percussionCheckBox.setSelection(track.isPercussionTrack());
            percussionCheckBox.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    instrumentCombo.setEnabled(!percussionCheckBox.getSelection());
                    
                    setDefaultTunning();
                    updateTunningGroup(!percussionCheckBox.getSelection());                                            
                }
            });
        } else {
            percussionCheckBox.setEnabled(false);
        }
        //-----------------------------------------------------------
    }

    private Instrument[] getInstruments() {
        Instrument[] instruments = null;
        Soundbank sb = TuxGuitar.instance().getPlayer().getSoundbank();
        if (sb != null) {
            instruments = sb.getInstruments();
        }
        return instruments;
    }

    private void updateTrackProperties() {
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        
        String trackName = this.nameText.getText();
        RGBColor trakColor = this.trackColor;
        
        List strings = new ArrayList();
        for (int i = 0; i < stringCount; i++) {
            strings.add(new InstrumentString((i + 1), stringCombos[i].getSelectionIndex()));
        }        

        boolean percussion = percussionCheckBox.getSelection();
        int offset = ((percussion)?0:SongTrack.MIN_OFFSET + offsetCombo.getSelectionIndex());
        int instrument = ((instrumentCombo.getSelectionIndex() >= 0)?instrumentCombo.getSelectionIndex():0);
       
        
        boolean infoChanges = hasInfoChanges(trackCoords,trackName,trackColor,offset);
        boolean tunningChanges = hasTunningChanges(trackCoords,strings);
        boolean instrumentChanges = hasInstrumentChanges(trackCoords,instrument,percussion);
        
        if(infoChanges || tunningChanges || instrumentChanges){
        	JoinedUndoable undoable = new JoinedUndoable();
        	
        	UndoableTrackGeneric undoableGeneric = null;
        	if(tunningChanges){
        		undoableGeneric = UndoableTrackGeneric.startUndo(trackCoords.getTrack());
        	}
        	
        	//--------------------------------------info---------------------------------------
        	if(infoChanges){
        		UndoableInfoTrack undoableInfo = null;
        		if(!tunningChanges){
        			undoableInfo = UndoableInfoTrack.startUndo(trackCoords.getTrack());
        		}
        		getEditor().getSongManager().getTrackManager().changeInfo(trackCoords.getTrack(),trackName,trackColor,offset);
        		if(!tunningChanges){
        			undoable.addUndoableEdit(undoableInfo.endUndo(trackCoords.getTrack()));
        		}
        	}
        	//--------------------------------------tunning---------------------------------------
        	if(tunningChanges){
        		getEditor().getSongManager().getTrackManager().changeInstrumentStrings(trackCoords.getTrack(),strings);
        	}
        	//-----------------------------instrument----------------------------------------------        
        	if(instrumentChanges){
        		UndoableInstrumentTrack undoableInstrument = null;
        		if(!tunningChanges){
        			undoableInstrument = UndoableInstrumentTrack.startUndo(trackCoords.getTrack());
        		}        	
        		getEditor().getSongManager().getTrackManager().changeInstrument(trackCoords.getTrack(),instrument,percussion);        		
        		if(!tunningChanges){
        			undoable.addUndoableEdit(undoableInstrument.endUndo(trackCoords.getTrack()));
        		}
        	}
        	if(tunningChanges){
        		undoable.addUndoableEdit(undoableGeneric.endUndo(trackCoords.getTrack()));
        	}        	
        	getEditor().getUndoManager().addEdit(undoable.endUndo());        	
        	if (TuxGuitar.instance().getPlayer().isRunning()) {
    			TuxGuitar.instance().getPlayer().updatePrograms();
    		}        	
        }
    }
    
    private boolean hasInfoChanges(SongTrackCoords trackCoords,String name,RGBColor color,int offset){
    	if(!name.equals(trackCoords.getTrack().getName())){
    		return true;
    	}
    	if(!color.isEqual(trackCoords.getTrack().getColor())){
    		return true;
    	}    	
    	if(offset != trackCoords.getTrack().getOffset()){
    		return true;
    	}
    	return false;
    }
    
    private boolean hasTunningChanges(SongTrackCoords trackCoords,List newStrings){
    	List oldStrings = trackCoords.getTrack().getStrings();    	
    	//check the number of strings
    	if(oldStrings.size() != newStrings.size()){
    		return true;
    	}    	
    	//check the tunning of strings
    	for(int i = 0;i < oldStrings.size();i++){    		    		
    		InstrumentString oldString = (InstrumentString)oldStrings.get(i);
    		boolean stringExists = false;    	
    		for(int j = 0;j < newStrings.size();j++){
    			InstrumentString newString = (InstrumentString)newStrings.get(j);
    			if(newString.isEqual(oldString)){
    				stringExists = true;
    			}
    		}    		
    		if(!stringExists){
    			return true;
    		}
    	}
    	return false;
    }
    
    private boolean hasInstrumentChanges(SongTrackCoords trackCoords,int instrument,boolean percussion){
    	return ((trackCoords.getTrack().getChannel().getInstrument() != instrument) || (trackCoords.getTrack().isPercussionTrack() != percussion));
    }
    
    private void updateTunningGroup(boolean enabled) {    	
        /*
    	int selectedIndex = tempStrings.size() - 1;
        Iterator it = tempStrings.iterator();
        while (it.hasNext()) {
            InstrumentString string = (InstrumentString) it.next();
            stringCombos[selectedIndex].select(string.getValue());
            stringCombos[selectedIndex].setVisible(true);
            stringCombos[selectedIndex].setEnabled(enabled);
            selectedIndex--;
        }
        */
    	for (int i = 0; i < tempStrings.size(); i++) {
            InstrumentString string = (InstrumentString)tempStrings.get(i);
            stringCombos[i].select(string.getValue());
            stringCombos[i].setVisible(true);
            stringCombos[i].setEnabled(enabled);    		
    	}
    	
        for (int i = tempStrings.size(); i < MAX_STRINGS; i++) {
        	stringCombos[i].select(0);
        	stringCombos[i].setVisible(false);
        }
        offsetCombo.setEnabled(enabled);
    }

    private void initTempStrings(List realStrings) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < realStrings.size(); i++) {
            InstrumentString realString = (InstrumentString) realStrings.get(i);
            tempStrings.add(realString.clone());
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();
        if (percussionCheckBox.getSelection()) {
            for (int i = 1; i <= stringCount; i++) {
                this.tempStrings.add(new InstrumentString(i, 0));
            }
        } 
        else {
            switch (stringCount) {
            case 7:
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                this.tempStrings.add(new InstrumentString(7, 35));
                break;
            case 6:
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                break;
            case 5:
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                this.tempStrings.add(new InstrumentString(5, 23));
                break;
            case 4:
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                break;
            }
        }
    }

    private String[] getAllValueNames() {
        String[] valueNames = new String[MAX_NOTES * MAX_OCTAVES];
        for (int i = 0; i < valueNames.length; i++) {
            valueNames[i] =  NOTE_NAMES[ (i -  ((i / MAX_NOTES) * MAX_NOTES) ) ] + (i / MAX_NOTES);;
        }
        return valueNames;
    }

}