/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTiedNoteAction extends Action{
    public static final String NAME = "action.note.general.tied";
    
    public ChangeTiedNoteAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        Caret caret = getEditor().getTablature().getCaret();
        MeasureComponent component = caret.getMeasureCoords().getComponent(caret.getPosition(),caret.getSelectedString().getNumber());
        if(component instanceof NoteCoords){
            //comienza el undoable
        	UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();        	
        	
            NoteCoords note = (NoteCoords)component;   
            getSongManager().getMeasureManager().changeTieNote(note.getNote());            
            
            //termia el undoable
            getEditor().getUndoManager().addEdit(undoable.endUndo());               
        }
        updateTablature();	    
        return true;
    }
    

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }        

}
