/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.convert;

import java.io.File;
import java.io.FileWriter;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.velocity.util.StringUtils;

public class WebMacro {
    protected String orignalTemplate;
    protected Perl5Util perl;
    protected String pathSeparator = File.separator;
    protected static final String VM_EXT = ".vm";
    protected static final String WM_EXT = ".wm";
    protected String[] res = new String[]{"#if\\s*[(]\\s*(.*\\S)\\s*[)]\\s*(#begin|{)[ \\t]?", "#if( $1 )", "[ \\t]?(#end|})\\s*#else\\s*(#begin|{)[ \\t]?(\\w)", "#else#**#$3", "[ \\t]?(#end|})\\s*#else\\s*(#begin|{)[ \\t]?", "#else", "#foreach\\s+(\\$\\w+)\\s+in\\s+(\\$[^\\s#]+)\\s*(#begin|{)[ \\t]?", "#foreach( $1 in $2 )", "\n}", "\n#end", "#set\\s+(\\$[^\\s=]+)\\s*=\\s*(.*\\S)[ \\t]*", "#set( $1 = $2 )", "(##[# \\t\\w]*)\\)", ")$1", "#parse\\s+([^\\s#]+)[ \\t]?", "#parse( $1 )", "#include\\s+([^\\s#]+)[ \\t]?", "#include( $1 )", "\\$\\(([^\\)]+)\\)", "${$1}", "\\${([^}\\(]+)\\(([^}]+)}\\)", "${$1($2)}", "\\$_", "$l_", "\\${(_[^}]+)}", "${l$1}", "\\.wm", ".vm"};

    public void convert(String[] args) {
        File file;
        if (args.length < 1) {
            this.usage();
        }
        if (!(file = new File(args[0])).exists()) {
            System.err.println("The specified template or directory does not exist");
            System.exit(1);
        }
        if (file.isDirectory()) {
            String basedir = args[0];
            String newBasedir = basedir + VM_EXT;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                this.writeTemplate(files[i], basedir, newBasedir);
                ++i;
            }
        } else {
            this.writeTemplate(args[0], "", "");
        }
    }

    private boolean writeTemplate(String file, String basedir, String newBasedir) {
        String newTemplate;
        String template;
        if (file.indexOf(WM_EXT) < 0) {
            return false;
        }
        System.out.println("Converting " + file + "...");
        if (basedir.length() == 0) {
            template = file;
            String templateDir = "";
            newTemplate = this.convertName(file);
        } else {
            template = basedir + this.pathSeparator + file;
            String templateDir = newBasedir + this.pathSeparator + file.substring(0, file.lastIndexOf(this.pathSeparator));
            File outputDirectory = new File(templateDir);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            newTemplate = newBasedir + this.pathSeparator + this.convertName(file);
        }
        String convertedTemplate = this.convertTemplate(template);
        try {
            FileWriter fw = new FileWriter(newTemplate);
            fw.write(convertedTemplate);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private String convertName(String name) {
        if (name.indexOf(WM_EXT) > 0) {
            return name.substring(0, name.indexOf(WM_EXT)) + VM_EXT;
        }
        return name;
    }

    public void usage() {
        System.err.println("Usage: convert-wm <template>.wm | directory");
        System.exit(1);
    }

    /*
     * Unable to fully structure code
     */
    public String convertTemplate(String template) {
        this.orignalTemplate = StringUtils.fileContentsToString(template);
        if (!this.orignalTemplate.endsWith("\n")) {
            this.orignalTemplate = this.orignalTemplate + "\n";
        }
        this.perl = new Perl5Util();
        i = 0;
        ** GOTO lbl11
        {
            this.orignalTemplate = this.perl.substitute("s/" + this.res[i] + "/" + this.res[i + 1] + "/", this.orignalTemplate);
            do {
                if (this.perl.match("/" + this.res[i] + "/", this.orignalTemplate)) continue block0;
                i += 2;
lbl11:
                // 2 sources

            } while (i < this.res.length);
        }
        return this.orignalTemplate;
    }

    public static void main(String[] args) {
        WebMacro converter = new WebMacro();
        converter.convert(args);
    }
}

