/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.HashMap;

public final class RefMap {
    final Object[] _key;
    final Object[] _value;
    int _size;

    public RefMap() {
        this(1001);
    }

    public RefMap(int n) {
        this._key = new Object[n];
        this._value = new Object[n];
        this._size = 0;
    }

    public void put(Object object, Object object2) throws IndexOutOfBoundsException {
        if (object == null) {
            return;
        }
        int n = object.hashCode() % this._key.length;
        if (n < 0) {
            n *= -1;
        }
        if (this._key[n] != null || this._key[n] == object) {
            int n2 = n + 1;
            while (n2 != n) {
                if (n2 == this._key.length) {
                    n2 = 0;
                    continue;
                }
                if (this._key[n2] == null || this._key[n] == object) break;
                ++n2;
            }
            n = n2;
        }
        if (this._key[n] == null || this._key[n] == object) {
            ++this._size;
            this._value[n] = object2;
            Object[] objectArray = this._key;
            synchronized (objectArray) {
            }
        } else {
            throw new IndexOutOfBoundsException("RefMap is Full, use realloc");
        }
        this._key[n] = object;
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        int n = object.hashCode() % this._key.length;
        if (n < 0) {
            n *= -1;
        }
        if (this._key[n] == object) {
            return this._value[n];
        }
        int n2 = n + 1;
        while (n2 != n) {
            if (n2 == this._key.length) {
                n2 = 0;
                continue;
            }
            if (this._key[n2] == object) {
                return this._value[n2];
            }
            ++n2;
        }
        return null;
    }

    public RefMap copy(int n) throws IndexOutOfBoundsException {
        if (this._size > n) {
            throw new IndexOutOfBoundsException("New map must be bigger than the old map");
        }
        RefMap refMap = new RefMap(n);
        int n2 = 0;
        while (n2 < this._key.length) {
            if (this._key[n2] != null) {
                refMap.put(this._key[n2], this._value[n2]);
            }
            ++n2;
        }
        return refMap;
    }

    public void clear() {
        int n = 0;
        while (n < this._key.length) {
            this._key[n] = null;
            Object[] objectArray = this._key;
            synchronized (objectArray) {
            }
            this._value[n] = null;
            ++n;
        }
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._key.length;
    }

    public static void main(String[] stringArray) {
        RefMap refMap = new RefMap(11);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer[] integerArray = new Integer[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            integerArray[n2] = new Integer(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            refMap.put(stringArray[n3], integerArray[n3]);
            hashMap.put(stringArray[n3], integerArray[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            System.out.println(stringArray[n4] + " :rm: " + refMap.get(stringArray[n4]));
            ++n4;
        }
        System.out.println();
        int n5 = 0;
        while (n5 < stringArray.length) {
            System.out.println(stringArray[n5] + " :hm: " + hashMap.get(stringArray[n5]));
            ++n5;
        }
        int n6 = 10;
        int n7 = 0;
        while (n7 < 200) {
            int n8;
            long l = System.currentTimeMillis();
            int n9 = 1;
            while (n9 < n6) {
                n8 = 1;
                while (n8 < stringArray.length) {
                    Object object = refMap.get(stringArray[n8]);
                    ++n8;
                }
                ++n9;
            }
            System.out.println("refmap : " + (System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            n8 = 1;
            while (n8 < n6) {
                int n10 = 1;
                while (n10 < stringArray.length) {
                    Object object = refMap.get(stringArray[n10]);
                    ++n10;
                }
                ++n8;
            }
            System.out.println("hashmap: " + (System.currentTimeMillis() - l));
            ++n7;
        }
    }
}

