/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.AuthDemo;
import helma.xmlrpc.Base64;
import helma.xmlrpc.Echo;
import helma.xmlrpc.ServerInputStream;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClient;
import helma.xmlrpc.XmlRpcServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebServer
implements Runnable {
    XmlRpcServer xmlrpc;
    private ServerSocket serverSocket;
    private int port;
    private Thread listener;
    private boolean paranoid;
    private Vector accept;
    private Vector deny;
    private Stack threadpool;
    private ThreadGroup runners;
    static final byte[] ctype = "Content-Type: text/xml\r\n".getBytes();
    static final byte[] clength = "Content-Length: ".getBytes();
    static final byte[] newline = "\r\n".getBytes();
    static final byte[] doubleNewline = "\r\n\r\n".getBytes();
    static final byte[] conkeep = "Connection: Keep-Alive\r\n".getBytes();
    static final byte[] conclose = "Connection: close\r\n".getBytes();
    static final byte[] ok = " 200 OK\r\n".getBytes();
    static final byte[] server = "Server: Helma XML-RPC 1.0\r\n".getBytes();
    static /* synthetic */ Class class$java$lang$Math;

    public WebServer(int n) throws IOException {
        this(n, null);
    }

    public WebServer(int n, InetAddress inetAddress) throws IOException {
        this.port = n;
        this.xmlrpc = new XmlRpcServer();
        this.accept = new Vector();
        this.deny = new Vector();
        this.threadpool = new Stack();
        this.runners = new ThreadGroup("XML-RPC Runner");
        this.serverSocket = new ServerSocket(n, 50, inetAddress);
        this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
        this.listener.start();
    }

    public void acceptClient(String string) throws IllegalArgumentException {
        try {
            AddressMatcher addressMatcher = new AddressMatcher(string);
            this.accept.addElement(addressMatcher);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\"" + string + "\" does not represent a valid IP address");
        }
    }

    public void addHandler(String string, Object object) {
        this.xmlrpc.addHandler(string, object);
    }

    private boolean checkSocket(Socket socket) {
        int n = this.deny.size();
        byte[] byArray = socket.getInetAddress().getAddress();
        int n2 = 0;
        while (n2 < n) {
            AddressMatcher addressMatcher = (AddressMatcher)this.deny.elementAt(n2);
            if (addressMatcher.matches(byArray)) {
                return false;
            }
            ++n2;
        }
        n = this.accept.size();
        int n3 = 0;
        while (n3 < n) {
            AddressMatcher addressMatcher = (AddressMatcher)this.accept.elementAt(n3);
            if (addressMatcher.matches(byArray)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void denyClient(String string) throws IllegalArgumentException {
        try {
            AddressMatcher addressMatcher = new AddressMatcher(string);
            this.deny.addElement(addressMatcher);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\"" + string + "\" does not represent a valid IP address");
        }
    }

    private Runner getRunner() {
        try {
            return (Runner)this.threadpool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            if (this.runners.activeCount() > 255) {
                throw new RuntimeException("System overload");
            }
            return new Runner();
        }
    }

    public static void main(String[] stringArray) {
        System.err.println("Usage: java helma.xmlrpc.WebServer [port]");
        int n = 8080;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing port number: " + stringArray[0]);
            }
        }
        XmlRpc.setKeepAlive(true);
        try {
            WebServer webServer = new WebServer(n);
            webServer.addHandler("string", "Welcome to XML-RPC!");
            webServer.addHandler("math", class$java$lang$Math != null ? class$java$lang$Math : (class$java$lang$Math = WebServer.class$("java.lang.Math")));
            webServer.addHandler("auth", new AuthDemo());
            webServer.addHandler("$default", new Echo());
            webServer.addHandler("mttf", new XmlRpcClient("http://www.mailtothefuture.com:80/RPC2"));
            System.err.println("started web server on port " + n);
        }
        catch (IOException iOException) {
            System.err.println("Error creating web server: " + iOException);
        }
    }

    void releaseRunner(Runner runner) {
        this.threadpool.push(runner);
    }

    public void removeHandler(String string) {
        this.xmlrpc.removeHandler(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (this.listener != null) {
                    try {
                        Socket socket = this.serverSocket.accept();
                        if (!this.paranoid || this.checkSocket(socket)) {
                            Runner runner = this.getRunner();
                            runner.handle(socket);
                            continue;
                        }
                        socket.close();
                    }
                    catch (Exception exception) {
                        System.err.println("Exception in XML-RPC listener loop (" + exception + ").");
                    }
                    catch (Error error) {
                        System.err.println("Error in XML-RPC listener loop (" + error + ").");
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error accepting XML-RPC connections (" + exception + ").");
            }
            Object var2_6 = null;
            System.err.println("Closing XML-RPC server socket.");
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            System.err.println("Closing XML-RPC server socket.");
            try {
                this.serverSocket.close();
                this.serverSocket = null;
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        this.serverSocket.close();
        this.serverSocket = null;
    }

    public void setParanoid(boolean bl) {
        this.paranoid = bl;
    }

    public void shutdown() {
        if (this.listener != null) {
            Thread thread = this.listener;
            this.listener = null;
            thread.interrupt();
        }
    }

    class Runner
    implements Runnable {
        Thread thread;
        Connection con;
        int count;

        Runner() {
        }

        public synchronized void handle(Socket socket) throws IOException {
            this.con = new Connection(socket);
            this.count = 0;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(WebServer.this.runners, this);
                this.thread.start();
            } else {
                this.notify();
            }
        }

        public void run() {
            while (Thread.currentThread() == this.thread) {
                this.con.run();
                ++this.count;
                this.con = null;
                if (this.count > 200 || WebServer.this.threadpool.size() > 20) {
                    return;
                }
                Runner runner = this;
                synchronized (runner) {
                    WebServer.this.releaseRunner(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    class Connection
    implements Runnable {
        private Socket socket;
        private BufferedInputStream input;
        private BufferedOutputStream output;
        private long lastRequest;
        private String user;
        private String password;
        byte[] buffer;

        public Connection(Socket socket) throws IOException {
            socket.setSoTimeout(30000);
            this.socket = socket;
            this.input = new BufferedInputStream(socket.getInputStream());
            this.output = new BufferedOutputStream(socket.getOutputStream());
        }

        private void parseAuth(String string) {
            try {
                byte[] byArray = Base64.decode(string.substring(21).getBytes());
                String string2 = new String(byArray);
                int n = string2.indexOf(":");
                this.user = string2.substring(0, n);
                this.password = string2.substring(n + 1);
            }
            catch (Throwable throwable) {}
        }

        private String readLine() throws IOException {
            int n;
            if (this.buffer == null) {
                this.buffer = new byte[512];
            }
            int n2 = 0;
            while ((n = this.input.read()) >= 0 && n != 10) {
                if (n != 13) {
                    this.buffer[n2++] = (byte)n;
                }
                if (n2 < 512) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, n2);
        }

        public void run() {
            try {
                block17: {
                    try {
                        boolean bl = false;
                        do {
                            Object object;
                            this.password = null;
                            this.user = null;
                            String string = this.readLine();
                            if ("".equals(string)) {
                                string = this.readLine();
                            }
                            if (XmlRpc.debug) {
                                System.err.println(string);
                            }
                            this.lastRequest = System.currentTimeMillis();
                            int n = -1;
                            StringTokenizer stringTokenizer = new StringTokenizer(string);
                            String string2 = stringTokenizer.nextToken();
                            String string3 = stringTokenizer.nextToken();
                            String string4 = stringTokenizer.nextToken();
                            boolean bl2 = bl = XmlRpc.getKeepAlive() && "HTTP/1.1".equals(string4);
                            do {
                                if ((string = this.readLine()) == null) continue;
                                if (XmlRpc.debug) {
                                    System.err.println(string);
                                }
                                if (((String)(object = string.toLowerCase())).startsWith("content-length:")) {
                                    n = Integer.parseInt(string.substring(15).trim());
                                }
                                if (((String)object).startsWith("connection:")) {
                                    boolean bl3 = bl = XmlRpc.getKeepAlive() && ((String)object).indexOf("keep-alive") > -1;
                                }
                                if (!((String)object).startsWith("authorization: basic ")) continue;
                                this.parseAuth(string);
                            } while (string != null && !string.equals(""));
                            if ("POST".equalsIgnoreCase(string2)) {
                                object = new ServerInputStream(this.input, n);
                                byte[] byArray = WebServer.this.xmlrpc.execute((InputStream)object, this.user, this.password);
                                this.output.write(string4.getBytes());
                                this.output.write(ok);
                                this.output.write(server);
                                if (bl) {
                                    this.output.write(conkeep);
                                } else {
                                    this.output.write(conclose);
                                }
                                this.output.write(ctype);
                                this.output.write(clength);
                                this.output.write(Integer.toString(byArray.length).getBytes());
                                this.output.write(doubleNewline);
                                this.output.write(byArray);
                                this.output.flush();
                                continue;
                            }
                            this.output.write(string4.getBytes());
                            this.output.write(" 400 Bad Request\r\n".getBytes());
                            this.output.write("Server: helma.XML-RPC\r\n\r\n".getBytes());
                            this.output.write(("Method " + string2 + " not implemented (try POST)").getBytes());
                            this.output.flush();
                            bl = false;
                        } while (bl);
                    }
                    catch (Exception exception) {
                        if (!XmlRpc.debug) break block17;
                        System.err.println(exception);
                        exception.printStackTrace();
                    }
                }
                Object var2_11 = null;
            }
            catch (Throwable throwable) {
                Object var2_12 = null;
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    class AddressMatcher {
        int[] pattern = new int[4];

        public AddressMatcher(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 4) {
                throw new Exception("\"" + string + "\" does not represent a valid IP address");
            }
            int n = 0;
            while (n < 4) {
                String string2 = stringTokenizer.nextToken();
                this.pattern[n] = "*".equals(string2) ? 256 : (int)((byte)Integer.parseInt(string2));
                ++n;
            }
        }

        public boolean matches(byte[] byArray) {
            int n = 0;
            while (n < 4) {
                if (this.pattern[n] <= 255 && this.pattern[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

