#!/bin/sh
SORTFILE=debian/fonts.sort
groups=`cut -f2 $SORTFILE | sort -u`
basedir=`pwd`

case "$1" in
	build)
	#
	# Create Directories for fonts
	#
	for group in $groups; do
		if [ ! -d $group ]; then
			mkdir $group
		fi
	done

	#
	# Extract font .zip files
	#
	for nam in *.zip; do
		group=`grep "^$nam[[:space:]]" $SORTFILE | cut -f2`
		if [ -z $group ]; then
			echo Font $nam is unsorted.
		else
			unzip -j -L -u -q $nam -d $group -x read_me.txt
		fi
	done

	#
	# Generate fonts.scale
	#
	for group in $groups; do
		ttmkfdir -p -f LarabieFonts -d $group | \
		sed -e 's/ttf -[^-]*-/ttf -LarabieFonts-/' > $group/fonts.scale
	done
	;;
	
	clean)
	for group in $groups; do
		rm -rf $group
	done
	;;
	
	install)
	#
	# Install .ttf and .txt files
	#
	for group in $groups; do
		cd $basedir/$group
		fontdir=share/fonts/truetype/larabie-$group
		docdir=usr/share/doc/ttf-larabie-$group
		etcdir=etc/X11/fonts/TrueType/larabie-$group
		lnkdir=usr/X11R6/lib/X11/fonts/TrueType/larabie-$group
		debdir=$basedir/debian/ttf-larabie-$group
                reldir=../../../../../../..
		# install fonts
		install -m755 -d $debdir/usr/$fontdir
		install -m755 -d $debdir/$etcdir
		install -m755 -d $debdir/$lnkdir
		for i in *.ttf; do \
			echo Installing $i
			install -m644 "$i" "$debdir/usr/$fontdir/$i"
			ln -s "../../../../../../$fontdir/$i" "$debdir/$lnkdir" 
		done
		install -m644 fonts.scale $debdir/usr/$fontdir/fonts.scale
		ln -s "/usr/$fontdir/fonts.scale" "$debdir/$etcdir/ttf-larabie-$group.scale"
		# install documentation
		install -m755 -d $debdir/$docdir
		for i in *.txt; do \
			echo Installing $i
			install -m644 "$i" "$debdir/$docdir/$i"
		done
		install -m644 $basedir/READ_ME.TXT $debdir/$docdir/READ_ME.TXT
		cd $basedir
	done
	;;
	*)
	echo "build, install or clean?"
	;;
esac

