/*
 * This file contains homebrewed PBS replacements for
 * library functions found on BSD 4.4-Lite.
 *
 * NOTE: the strange set of "if define..." results from Sun not having
 * stdarg.h, at least on SunOS 4.x 
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#if defined(__STDC__) && !defined(__TSUNOS4)
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#if defined(__STDC__) && !defined(__TSUNOS4)
void errx(int err, const char *fmt, ...)
#else
void errx(err, fmt, va_alist)
	int   err;
	char *fmt;
	va_dcl
#endif
{
	va_list ap;

#if defined(__STDC__) && !defined(__TSUNOS4)
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)vfprintf(stderr, fmt, ap);
	exit (err);
}

#if defined(__STDC__) && !defined(__TSUNOS4)
void warnx(const char *fmt, ...)
#else
void warnx(fmt, va_alist)
	char *fmt;
	va_dcl
#endif

  {
  va_list ap;

#if defined(__STDC__) && !defined(__TSUNOS4)
  va_start(ap, fmt);
#else
  va_start(ap);
#endif
  vfprintf(stderr,fmt,ap);

  return;
  }




void err(

  int   val,
  char *str)

  {
  if (str != NULL)
    {
    fprintf(stderr,"%s\n", 
      str);
    }

  exit(val);
  }  /* END err() */

