package tijmp.ui;

import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

/** A renderer that turns memory sizes into readable strings.
 */
public class TimeRenderer extends DefaultTableCellRenderer {
    private String[] names = {"nanos", "micros", "millis",  "s", "m", "h"};
    private int[] sizes =    {      1,     1000,     1000, 1000,  60,  60};

    public TimeRenderer () {
	setHorizontalAlignment (SwingConstants.RIGHT);
    }

    @Override public void setValue (Object value) {
	long l = ((Long)value).longValue ();
	if (l <= 0) {
	    super.setValue ("");
	    return;
	}
	double d = l;
	int i = 1;
	while (i < sizes.length && d > sizes[i] / 2) {
	    d /= sizes[i++];
	}
	i--;
	String val = String.format ("%.2f %s", d, names[i]);
	super.setValue (val);
    }
}
