package tijmp.ui;

import java.util.ArrayList;
import java.util.List;
import tijmp.filter.CommonArrayFilter;
import tijmp.filter.ExactFilter;
import tijmp.filter.Filter;
import tijmp.filter.NotFilter;
import tijmp.filter.OrFilter;
import tijmp.filter.RecursiveFilter;

/** A class to handle the current filter.
 */
public class FilterConfig {
    private Filter filter;
    private List<FilterListener> fls = new ArrayList<FilterListener> ();
    private static String[] defaultRemoved = 
    {"java.", "javax.", "sun.", "tijmp."};
    
    public FilterConfig () {
	setDefaultFilter ();
    }
    
    public void setDefaultFilter () {
	RecursiveFilter rj1 = new RecursiveFilter (defaultRemoved[0]);
	RecursiveFilter rj2 = new RecursiveFilter (defaultRemoved[1]);
	OrFilter o = new OrFilter (rj1, rj2);
	for (int i = 2; i < defaultRemoved.length; i++) {
	    RecursiveFilter r = new RecursiveFilter (defaultRemoved[i]);
	    o = new OrFilter (r, o);
	}
	CommonArrayFilter caf = new CommonArrayFilter ();
	o = new OrFilter (caf, o);
	filter = new NotFilter (o);
	ExactFilter sf = new ExactFilter (String.class);
	filter = new OrFilter (filter, sf);
	fireFilterChanged ();
    }

    public Filter getFilter () {
	return filter;
    }

    public void setFilter (Filter filter) {
	this.filter = filter;
	fireFilterChanged ();
    }

    private void fireFilterChanged () {
	for (FilterListener fl : fls) 
	    fl.filterChanged (filter);
    }
    
    public void addFilterListener (FilterListener fl) {
	fls.add (fl);
    }

    public void removeFilterListener (FilterListener fl) {
	fls.remove (fl);
    }
}
