package tijmp.filter;

import tijmp.ui.Translator;

/** A filter that only matches classes in a given package.
 */
public class PackageFilter implements Filter {
    private String pkg;

    public PackageFilter (String pkg) {
	if (!pkg.endsWith ("."))
	    pkg += ".";
	this.pkg = pkg;
    }

    public boolean accept (Class<?> c) {
	String n = Translator.translate (c, null);
	if (!n.startsWith (pkg))
	    return false;
	int l = pkg.length () + 1;
	if (n.length () <= l)
	    return false;
	return n.indexOf ('.', l) == -1;
    }
}
