#include <stdio.h>
#include <jvmti.h>
#include <tijmp.h>
#include <string.h>
#include <tag_list.h>

extern jvmtiEnv *jvmti;

void setup_tag_list (JNIEnv* env, tag_list* lbd, jclass clz) {
    (*jvmti)->GetTag (jvmti, clz, &lbd->clz_tag);
    lbd->size = 1000;
    lbd->next_pos = 0;
    (*jvmti)->Allocate (jvmti, sizeof (*lbd->tags) * lbd->size, 
			(unsigned char**)&lbd->tags);
}

void cleanup_tag_list (tag_list* lbd) {
    (*jvmti)->Deallocate (jvmti, (unsigned char*)lbd->tags);
    lbd->size = 0;
    lbd->next_pos = -1;
}

static void expand_tag_list (tag_list* lbd) {
    jlong* new_tags;
    jint new_size = lbd->size * 2;
    (*jvmti)->Allocate (jvmti, sizeof (*lbd->tags) * new_size, 
			(unsigned char**)&new_tags);
    memcpy (new_tags, lbd->tags, sizeof (*lbd->tags) * lbd->size);
    lbd->size = new_size;
    lbd->tags = new_tags;
}

void add_tag (tag_list* lbd, jlong tag) {
    if (lbd->next_pos == lbd->size) 
	expand_tag_list (lbd);
    lbd->tags[lbd->next_pos++] = tag;
}
