#ifndef OBJECT_INFO_LIST_H__
#define OBJECT_INFO_LIST_H__

#include <jni.h>

typedef struct {
    jclass clz;  /* the class of the object info list. */
    jint size;   /* max size of array. */
    jint count;  /* current entries. */
    jlong* sizes;
    jint* lengths;
    jobject* objects;
    jlong* tags;
} object_info_list;

/* create a new object info list with the default size. */
object_info_list* create_object_info_list (jclass clz);

void free_object_info_list (object_info_list* oil);

void add_object_info_to_list (object_info_list* oil, 
			      jlong size, 
			      jint length, 
			      jlong tag);

void create_object_store (object_info_list* oil);

#endif /* OBJECT_INFO_LIST_H__ */
