package tijmp.actions;

import java.awt.event.ActionEvent;
import tijmp.filter.AndFilter;
import tijmp.filter.Filter;
import tijmp.filter.NotFilter;
import tijmp.filter.RecursiveFilter;
import tijmp.ui.FilterConfig;

/** A class that filters out a package and its sub packages
 */
public class FilterOutPackage extends FilterAction {
    private String pname;

    public FilterOutPackage (FilterConfig fc, String pname) {
	super ("Filter out " + pname + " and sub packages", fc);
	this.pname = pname;
    }

    public void actionPerformed (ActionEvent e) {
	FilterConfig fc = getFilterConfig ();
	Filter f = fc.getFilter ();
	RecursiveFilter rf = new RecursiveFilter (pname);
	NotFilter nf = new NotFilter (rf);
	AndFilter af = new AndFilter (f, nf);
	fc.setFilter (af);
    }
}
