;*
;* PedroM - Operating System for Ti-89/Ti-92+/V200.
;* Copyright (C) 2003 PpHd
;*
;* This program is free software ; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation;
;* either version 2 of the License, or (at your option) any later version. 
;* 
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
;* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;* See the GNU General Public License for more details. 
;* 
;* You should have received a copy of the GNU General Public License along with this program;
;* if not, write to the 
;* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

;******************************************************************
;***                                                            ***
;***            	Shell commands				***
;***                                                            ***
;******************************************************************

; Display a return
DispReturn:
	pea	Return_str(pc)
	bsr	printf
	bra.s	DispAddqReturn
; Display '2 args'
DispArg2Files:
	pea	Arg2_str(pc)
	bra.s	DispErrorPrintf
; Display 'arg: FileName'
DispArgFileName:
	pea	Arg1_str(pc)
	bra.s	DispErrorPrintf
; Display 'Error: Argument number'
DispArgNumber:
	pea	ArgNumber_str(pc)
DispErrorPrintf
	bsr	errorPrintf
DispAddqReturn:
	addq.l	#4,a7
	rts	

; Match if the 2 strings may be identical !
; In :
;	a0 -> String 1
;	a1 -> String 2
; Out:
;	d0.b = 0 if there are identical
; Note: 
;	String2 may allow wildcars '*' and '?'
Match:
	move.b	(a1)+,d1
	beq.s	\End
	cmpi.b	#'*',d1
	beq.s	\DoMany
	cmpi.b	#'?',d1
	beq.s	\Skip
	move.b	(a0)+,d0
	beq.s	\Error
	cmp.b	d0,d1
	beq.s	Match
\Error	moveq	#1,d0
	rts
\Skip	addq.l	#1,a0		; Skip this character
	bra.s	Match
\End:	move.b	(a0),d0		; If a0 is null, we succeed, else we failed
	rts
\Error2	move.b	d1,d0		; Is is the joker was '0'
	rts			; Yes, so it isn't an error, we succeed !
\DoMany	move.b	(a1)+,d1	; Stop char
\Loop		move.b	(a0)+,d0	; We loop until we found
		beq.s	\Error2		; Else the end of the string 1
		cmp.b	d0,d1		; else the stop character
		bne.s	\Loop
	movem.l	d1/a0/a1,-(a7)	; We scan recursevly from this position 
	bsr	Match		; to check the motif
	movem.l	(a7)+,d1/a0/a1	
	tst.b	d0		; If it failed, we go back, and skip this one.
	bne.s	\Loop
	rts


; Display 'Confirm' and input a string from he user.
; Is the string is 'yes', it returns -1 else 0
; Out: d0.b
Confirm:
	pea	Confirmation_str(pc)
	bsr	printf				; Print 'Confirmation'
	subq.l	#4,a7
	bsr	GKeyFlush			; Flush Key Buffer
	move.l	a7,a0
	moveq	#4,d3
	bsr	Input_String
	clr.w	d0
	cmp.b	#'y',(a0)+
	bne.s	\exit
	cmp.b	#'e',(a0)+
	bne.s	\exit
	cmp.b	#'s',(a0)+
	bne.s	\exit
	tst.b	(a0)+
	seq.b	d0
\exit	addq.l	#8,a7
	rts
	
; Put a string on the screen
; In:
;	a0 -> String
;	d0.w = x
;	d1.w = y
; Out :
;	nothing
; Destroy:
;	nothing
Display_String:
	movem.l	d0-d2/a0-a1,-(a7)
	move.w	#4,-(a7)
	pea	(a0)
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	bsr	DrawStr
	lea     10(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	rts

; Get a key using GetKey.
; Enable the cursor during the waiting of the key.
; Destroy/Return: 
;	d0.w = Key
GetCursorKey:
	jsr	CU_start
	bsr	GetKey
	move.w	d0,-(a7)
	jsr	CU_stop
	move.w	(a7)+,d0
	rts
	
; Input a string
; Support FunctionKey / History Command / Cursor / Completion / HelpKeys / Switching
; In :
;	d3.w = maxchar
;	a0.l -> String to fill (maxchar+4)
; Out:
;	d0.w = string lenght
; Destroy :
;	d0
Input_String:
	movem.l	d1-d6/a0-a3,-(a7)
	moveq	#-1,d5				; History Index
	move.l	a0,a1				; a1 -> Current char
	clr.b	(a0)				; Null string
	clr.w	d4				; 0 char
	move.w	CURRENT_POINT_X,d6
\loop:	jsr	StrWidthFromTo			; Calculate the length of the string
	add.w	d6,d0				; and X position
	move.w	d0,CURRENT_POINT_X		; Update CURSOR X
	pea	(a1)
\EndLoop:	tst.b	(a1)+
		bne.s	\EndLoop
	pea	(a1)
	move.b	#' ',-1(a1)			; 1 Space
	move.b	#' ',(a1)+			; 2 Spaces
	move.b	#' ',(a1)+			; 3 Spaces
	clr.b	(a1)+				; Null string
	move.w	d6,d0				; X pos
	move.w	CURRENT_POINT_Y,d1		; Y pos
	bsr.s	Display_String			; Display string
	move.l	(a7)+,a1
	clr.b	-(a1)
	move.l	(a7)+,a1	
	bsr.s	GetCursorKey
	cmp.w	#KEY_ENTER,d0			;Enter ?
	beq	\Enter
	cmp.w	#KEY_CLEAR,d0			;Clear ?
	beq	\Clear
	cmp.w	#KEY_BACK,d0
	beq.s	\Del
	cmp.w	#KEY_ESC,d0			;ESC ?
	beq.s	\Esc
	cmp.w	#KEY_UP,d0			;Up ?
	beq	\Up
	cmp.w	#KEY_DOWN,d0			;Down ?
	beq	\Dn
	cmp.w	#KEY_LEFT,d0			;Up ?
	beq	\Left
	cmp.w	#KEY_RIGHT,d0			;Down ?
	beq	\Right
	cmp.w	#HELPKEYS_KEY,d0
	beq	\DisplayHelpKeys
	cmpi.w	#KEY_ON,d0			; Break ?
	beq	\Completion
	;cmpi.w	#KEY_SWITCH,d0
	;beq	\Switch
	cmpi.w	#KEY_F1,d0			; F1-F8 ?
	blt.s	\NoFKey
		cmpi.w	#KEY_F8,d0
		ble.s	\FKey
\NoFKey	cmp.w	#255,d0				;Charactre invalide ?
	bhi	\CheckSwitch
	bsr.s	\AddChar
	bra	\loop
\Del:	tst.w	d4
	beq	\loop
	subq.w	#1,d4
	;memmove(a1+1, a1, until a1 = zero)
	; a1 -> x y z 0 t
	subq.l	#1,a1
	move.l	a1,a2
\DelCharLoop:	move.b	1(a2),(a2)+
		bne.s	\DelCharLoop
	bra	\loop
\Esc:	clr.w	d4		; No char
	clr.b	(a0)		; Void string
\Enter:	bsr	DispReturn	; Disp final return
	move.w	d4,d0		; Number of Char
	movem.l (a7)+,d1-d6/a0-a3
	rts
	
; Add a char in a1
\AddChar:
	pea	(a2)
	cmp.w	d3,d4				; NbrChar < Maxchar ?
	beq.s	\MaxCharRts
	addq.w	#1,d4				; NbrChar++
	;memmove(a1, a1+1, until a1 = zero)
	; a1 -> x y z 0 t
	move.l	a1,a2
\AddCharLoop1:	tst.b	(a2)+
		bne.s	\AddCharLoop1
	; a2 -> t
	subq.l	#1,a2
\AddCharLoop2	move.b	(a2),1(a2)
		subq.l	#1,a2
		cmp.l	a1,a2
		bge.s	\AddCharLoop2
	move.b	d0,(a1)+			; Save new char
\MaxCharRts
	move.l	(a7)+,a2
	rts
	
\Left:	cmp.l	a0,a1
	beq	\loop
	subq.l	#1,a1
	bra	\loop
\Right:	tst.b	(a1)
	beq	\loop
	addq.l	#1,a1
	bra	\loop

; Function Key support (Or Fast Key ?)
\FKey:	sub.w	#KEY_F1-1,d0
	; Search for 'system\fkey[d0+1]'
	movem.l	d0-d2/a0-a1,-(a7)
	lea	-20(a7),a7		; Stack Frame
	move.w	d0,-(a7)
	pea	FKeyFormat_str(pc)
	pea	6(a7)
	bsr	sprintf			; 6(a7) = 'fkey1'
	lea	10(a7),a2
	jsr	getenv			; Get environement variable
	lea	30(a7),a7
	move.l	a0,a2
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,d0
	beq	\loop
	tst.b	(a2)
	beq	\loop
\FLoop		move.b	(a2)+,d0
		beq	\loop
		cmpi.b	#SHELL_AUTO_CHAR,d0
		beq	\Enter			; End of command
		bsr	\AddChar
		bra.s	\FLoop


; Clear the entire Input Line
\Clear:
	moveq	#-1,d5			; Reset History indecx
	bsr.s	\Clean
	bra	\loop

; Routine which clears the Input Line
\Clean	move.w	d4,d0
	beq.s	\CleanEnd		; No characters
	pea	(a0)
	subq.l	#4,a7
	move.l	a7,a0
	move.b	d6,(a0)+
	move.b	CURRENT_POINT_Y+1,(a0)+
	move.b	#SCR_WIDTH-1,(a0)+
	move.b	CURRENT_POINT_Y+1,(a0)
	addq.b	#USED_FONT*2+6,(a0)
	move.w	#A_REVERSE,-(a7)
	pea	ScrRect(pc)
	pea	-3(a0)
	bsr	ScrRectFill
	lea	14(a7),a7
	move.l	(a7)+,a0
	move.l	a0,a1			; Reset string ptr
	clr.b	(a0)
	clr.w	d4			; Reset length
\CleanEnd
	rts

; History
\Up:	cmpi.w	#SHELL_HISTORY,d5
	bge	\loop
	addq.w	#1,d5
	bra.s	\CopyHistory
\Dn:	tst.w	d5
	ble.s	\Clear
	subq.w	#1,d5
\CopyHistory
	lea	SHELL_HISTORY_TAB,a3
	move.w	d5,d0
	mulu.w	#SHELL_MAX_LINE+2,d0
	adda.l	d0,a3					; Saved String
	tst.b	(a3)					; If no pasted string
	beq.s	\FixIndex				; Return
	bsr.s	\Clean
\PasteLoop	move.b	(a3)+,d0			; Read char
		beq.s	\Loop2				; Check if the string is finished
		bsr	\AddChar
		bra.s	\PasteLoop
\FixIndex
	subq.w	#1,d5					; Too high
\Loop2	bra	\loop

; Completion
\Completion:
	jsr	Completion
	bra	\loop

; Display HelpKeys
\DisplayHelpKeys
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	CURRENT_POINT_X,-(a7)
	bsr	HelpKeys
	move.l	(a7)+,CURRENT_POINT_X
	movem.l	(a7)+,d0-d7/a0-a6
	bra	\loop
	
; Switch Task
\CheckSwitch:
	movem.l	d0-d2/a0-a1,-(a7)
	lea	ShellInput_str(pc),a0
	jsr	PID_CheckSwitch
	movem.l	(a7)+,d0-d2/a0-a1
	bra	\loop

; Copy the given string to the history table.
; In: a4 -> String
CopyToHistory:
	pea	((SHELL_HISTORY-1)*(SHELL_MAX_LINE+2)).w	; Size
	pea	SHELL_HISTORY_TAB				; From
	pea	SHELL_HISTORY_TAB+SHELL_MAX_LINE+2		; To 
	bsr	memmove
	pea	((SHELL_MAX_LINE+1)).w				; Size
	pea	(a4)						; From
	pea	SHELL_HISTORY_TAB				; To 
	bsr	memcpy
	lea	(4*6)(a7),a7
	rts

; Convert an hexdecimal/decimal string in an unsigned number
; In:
;	a0 -> string(NULL)
; Out:
;	d0.l = Number
; Destroy:
;	d0-d2/a0
atol:
	cmp.b	#'0',(a0)
	bne.s	\start10
	cmp.b	#'x',1(a0)
	bne.s	\start10
	addq.l	#2,a0			; Skip '0x'
\start16:
	moveq	#0,d0
\loop		moveq	#0,d1		; Read
		move.b	(a0)+,d1	; Char
		beq.s	\end
		subi.b	#'0',d1		; From '0'
		cmpi.b	#9,d1
		bls.s	\ok
			subi.b	#'a'-'0'-10,d1
\ok		lsl.l	#4,d0
		add.l	d1,d0
		bra.s	\loop
\end:	rts

\start10:
	moveq	#0,d0
\loop10		moveq	#0,d1		; Read
		move.b	(a0)+,d1	; Char
		beq.s	\end
		subi.b	#'0',d1		; From '0'
		move.l	d0,d2
		lsl.l	#3,d0
		add.l	d2,d0
		add.l	d2,d0		; x10
		add.l	d1,d0
		bra.s	\loop10


; Translate the args from the command line
; Warning : if the command contains some space, it may fail !
; It translate wildcards '*' & '?' in files.
; In:
;	a4 -> Line Buffer
; Destroy:
;	Nothing
TranslateArgs:
	movem.l	d0-d6/a0-a6,-(a7)		
	; Register Usage:
	;	d0-d2/a0-a1: Grab registers
	;	d1 IsWildCard	/ d3: Temp Save of Current Entry
	;	d4: Current Index in ARGV table / d5: Current Arg with wildcard
	;	d6: Current Ptr of Folder Separator
	;	a2 -> Input Ptr	/ a3 -> ARGV Ptr /
	;	a5 -> Extra Buffer Ptr
	move.l	a4,a2				; Line Buffer Ptr
	moveq	#0,d4
	lea	ARGV,a3				; ARGV Table
\ArgLoop:	clr.b	d1			; No wildcards
		;moveq	#0,d6			; No folder
\SkipSpace		move.b	(a2)+,d0
			beq	\RealEndOfLine
			cmpi.b	#' ',d0
			beq.s	\SkipSpace
		subq.l	#1,a2
		move.l	a2,0(a3,d4.w)		; Save command (First arg)
		addq.w	#4,d4			; Next arg
		cmpi.w	#ARG_MAX*4,d4		; Check if overflow ?
		bge	\EndOfLine
		cmpi.b	#'"',(a2)		; Check if start with '"' (Select all the args)
		bne.s	\NextChar
				addq.l	#1,-4(a3,d4.w)	; Inc previous ptr to skip '"'
				addq.l	#1,a2		; Skip first '"'
			\next2:		move.b	(a2)+,d0	; Read next Char 0
					beq.s	\RealEndOfLine	; Yes, so RealEndOfLine (No need to translate last arg)
					cmpi.b	#'"',d0		; Check if '"'
					bne.s	\next2
				bra.s	\NextArg

\NextChar:		move.b	(a2)+,d0	; Read next char
			beq	\EndOfLine	; End of line (Do the translation of the last command)
			cmpi.b	#'*',d0		; Check if '*'
			bne.s	\NoStar
				st.b	d1	; Set wildcards	translation
\NoStar			cmpi.b	#'?',d0		; Check if '?'
			bne.s	\NoJoker
				st.b	d1	; Set wildcards	translation
\NoJoker	;	cmpi.b	#'\',d0
		;	bne.s	\NoFolder
		;		move.l	a2,d6	; Ptr to file
\NoFolder		cmpi.b	#' ',d0		; Check if ' ' (Separation between args)
			bne.s	\NextChar	; Yes, next argument

\NextArg:	clr.b	-1(a2)		; Arg is NULL string
		tst.b	d1		; No Wildcars, ok
		beq.s	\ArgLoop
\Wild			move.l	-4(a3,d4.w),d5	; d5 -> Current Arg with wildcards
			subq.w	#4,d4		; Remove this arg from the arg list
			; Default folder : Current folder
			lea	CUR_FOLDER_STR,a1
;			tst.l	d6
;			beq.s	\CurrentFolderOk
;				move.l	d5,a1		; a1 -> Folder
;				move.l	d6,d5		; a6 -> d5 -> Filter String
;				move.l	d6,a0
;				clr.b	-(a0)		; Make 0 string
\CurrentFolderOk:
			; Folder convertion
			\Cvt:	tst.b	(a1)+
				bne.s	\Cvt
			; Search in the VAT some files which may be like the wildcards
			move.w	#FO_SINGLE_FOLDER,-(a7)	; We search in the current folder
			pea	-1(a1)			; From ANSI to TI...
			bsr	SymFindFirst		; Go throught the current folder
			addq.l	#6,a7
			bra.s	\CmpGo
\CmpLoop			bsr	SymFindNext	; Next entry
\CmpGo				move.l	a0,d3		; No more entry ? Quit
				beq	\ArgLoop
				move.l	d5,a1
				bsr	Match		; Does theses str matches ?
				tst.b	d0
				bne.s	\CmpLoop	; No, next
					; tst.l d6
					; beq.s \std
					;	pea	(a5)
					; 	move.l d3,-(a7)
					; 	bsr	HSYMtoName
					;	addq.l	#8,a7
					;	move.l	a5,d3
					;	lea	1(a1),a5
					;\std:
					move.l	d3,0(a3,d4.w)	; Save this arg
					addq.w	#4,d4
					cmpi.w	#ARG_MAX*4,d4
					blt.s	\CmpLoop
					bra.s	\RealEndOfLine
\EndOfLine:
	subq.l	#1,a2
	tst.b	d1
	bne.s	\Wild
\RealEndOfLine
	jsr	CheckRedirection
	lsr.w	#2,d4
	move.w	d4,ARGC
	movem.l	(a7)+,d0-d6/a0-a6
	rts


; Push the arg on the EStack for a program which is compatible with AMS.
; You must call TranslateArgs first
; If you call after push_LIST_tag and HS_popEstack, you can easilly create
; a var with all the args.
PushArgs:
	movem.l	d0-d3/a0-a2,-(a7)
	bsr	push_END_TAG
	move.w	ARGC,d3
	subq.w	#2,d3
	blt.s	\done
	lea	ARGV+8,a2
	adda.w	d3,a2
	adda.w	d3,a2
	adda.w	d3,a2
	adda.w	d3,a2
\loop		move.l	-(a2),-(a7)
		bsr	push_zstr
		addq.l	#4,a7
		dbf	d3,\loop
\done	movem.l	(a7)+,d0-d3/a0-a2
	rts
	
	
; Main Loop
ShellCommand:
	; Display first line
	move.b	#USED_FONT,CURRENT_FONT		; Set current font
	bsr	clrscr				; Clear Screen
	pea	Pedrom_str(pc)
	bsr	printf				; Print 'PedroM'
	pea	Author_str(pc)	
	bsr	printf				; Printf '(c) PpHd'
	bsr	DispReturn
	; Set the Process Number
	jsr	PID_Init
	; Run auto script ?
	tst.b	RUN_START_SCRIPT
	beq.s	\NoRun
		pea	StartScript_sym(pc)
		bsr	SymFindPtr			; Search file 'start'
		addq.l	#4,a7
		move.l	a0,d0
		beq.s	\NoRun
		move.w	SYM_ENTRY.hVal(a0),d1
		beq.s	\NoRun
			bsr	push_END_TAG		; Must call push_END_TAG (Bad conception :(
			move.w	d1,d0			; Doesn't delete d1
			jsr	ScriptExec
\NoRun:	; Alloc Input Buffer
	lea	(14-SHELL_MAX_LINE-6)(a7),a7

ShellCommandLoop
	; Check Pen position
	move.w	SHELL_SAVE_Y_POS,d0		; The window modify the vertical position of the pen.
	cmp.w	CURRENT_POINT_Y,d0		; So we check if the current position is > than the previous.
	ble.s	\Continue			; By the way, clearscreen resets the previous value too.
		move.w	d0,CURRENT_POINT_Y	; If not, we set the current value to the previous saved one.
\Continue
	cmpi.w	#SCR_HEIGHT-8,CURRENT_POINT_Y	; If the pen is outside the screen
	ble.s	\Continue2
		jsr	clrscr			; We clear the screen.
\Continue2		
	clr.w	(a7)
	bsr	ST_busy				; Idle mode
	bsr	SetTerminal			; Restore the normal way of rendering
	bsr	GKeyFlush			; Clear key buffer
	st.b	SHELL_NG_DISPLAY		; Display the result of ng_execute
	move.l	a7,a4				; Input Buffer
	clr.b	(a4)+				; First byte is null
	; Ask command
\ContInput	pea	Shell_str(pc)
		bsr	printf			; Display ':>'
		addq.l	#4,a7
		move.l	a4,a0
		moveq	#SHELL_MAX_LINE,d3
		bsr	Input_String		; Input the string
		tst.b	(a4)			; CHeck if something input ?
		beq.s	\ContInput		; No so continue the input
	bsr	CopyToHistory			; Copy the command in the history

	lea	-60(a7),a7			; Error Stack Frame
	pea	(a7)				; Push Stack Frame
	bsr	ER_catch			; Catch all errors.
	tst.w	d0
	bne.s	\Error
		jsr	ShellExecuteCommand	; Translate and execute Command
		bsr	ER_success
		bra.s	\Cont
\Error	jsr	find_error_message_reg
	pea	(a0)
	pea	CommandNotFound_str(pc)
	bsr	printf
	addq.l	#8,a7
\Cont	lea	64(a7),a7
	bra	ShellCommandLoop
	
; In:
;	a4 -> String to execute (WARNING: it is modified !, and -1(a4) =0 !)
; Destroy a0-a3/d0-d4
; Errors may be throw.
ShellExecuteSimpleCommand:
	bsr	EStackReInit			; Reinit EStack before parsing
	move.w	CURRENT_POINT_Y,SHELL_SAVE_Y_POS
;0. Skip spaces at the beginning
\Spaces		cmpi.b	#' ',(a4)+
		beq.s	\Spaces
	subq.l	#1,a4
; 1. Check if it an Internal Command ?
	move.l	a4,a1
	lea	CommandTable(pc),a2
\loop:		move.w	(a2)+,d0		; End of table ?
		beq	InternalCommandNotFound
		lea	CommandTable(pc,d0.w),a3
		move.l	a1,a0
\cmp:			tst.b	(a3)		; NULL str ?
			beq.s	\InternalCommand
			cmpm.b	(a3)+,(a0)+	; Cmp str
			beq.s	\cmp
		addq.l	#INTERNAL_COMMAND_SIZE-2,a2	; Next command
		bra.s	\loop
\InternalCommand:
	move.b	(a0),d0
	beq.s	\ok
	cmpi.b	#' ',d0
	bne.s	\loop
\ok:	bsr	TranslateArgs			; Translate the args
	move.w	(a2),d0
	jmp	CommandTable(pc,d0.w)

ADD_COMMAND	MACRO
	dc.w	\1_str-CommandTable,\1_cmd-CommandTable
		ENDM
CommandTable:
	ADD_COMMAND	Arc
	ADD_COMMAND	Cat
	ADD_COMMAND	Cd
	ADD_COMMAND	Clean
	ADD_COMMAND	Cls
	ADD_COMMAND	Cp
	ADD_COMMAND	Echo
	ADD_COMMAND	Flags
	ADD_COMMAND	Get
	ADD_COMMAND	Go
	ADD_COMMAND	Grep
	ADD_COMMAND	Help
	ADD_COMMAND	HexDump
	ADD_COMMAND	InstallFormat
	ADD_COMMAND	InstallProductCode
	ADD_COMMAND	InstallTIB
	ADD_COMMAND	Kill
	ADD_COMMAND	Ls
	ADD_COMMAND	Mem
	ADD_COMMAND	MkDir
	ADD_COMMAND	More
	ADD_COMMAND	Mv
	ADD_COMMAND	Ps
	ADD_COMMAND	Read
	ADD_COMMAND	Reset
	ADD_COMMAND	RmArc
	ADD_COMMAND	RmDir
	ADD_COMMAND	Rm
	ADD_COMMAND	SendCalc
	ADD_COMMAND	Side
	ADD_COMMAND	UnArc
	ADD_COMMAND	UnPPG
	dc.w	0

; 2 : Check if it an executable file ?
InternalCommandNotFound:
	move.l	a4,a0
	suba.l	a3,a3			; NULL
\Cvt:		move.b	(a0)+,d0	; Get a filename
		beq.s	\CvtDone
		cmpi.b	#' ',d0
		bne.s	\Cvt
		lea	-1(a0),a3
		clr.b	(a3)
\CvtDone
	jsr	FindSymInPath		; Find the filename in the path
	move.l	a3,d0			; Check if we have patched the string
	beq.s	\CheckSym
		move.b	#' ',(a3)	; Restore the ' ' char.
\CheckSym
	move.l	a0,d4			; Success finding it ?
	beq	FileNameNotFound
		; Check if it an ASM file or a PPG file
		; It may be good if kernel::exec supports script too!
		move.w	SYM_ENTRY.hVal(a0),-(a7)	; Push Handle
		bsr	HToESI
		cmpi.b	#$F3,(a0)			; ASM ?
		beq.s	\Run_ASM
		cmpi.b	#$F8,(a0)			; PPG ?
		beq.s	\KernelExec
		cmpi.b	#$E0,(a0)			; Script ?
		beq.s	\ScriptExec
			addq.l	#2,a7			; Pop Handle
			bra	FileNameNotFound	; The file has been found but it isn't an executable file.
\Run_ASM	; Asm files can't be run using kernel::exec due to Tictex which needs a twin entry.
		bsr	HeapDeref
		cmp.l	#'68cA',4(a0)			; Pack Archive ?
		beq.s	\KernelExec			; Yes => So I can use directly kernel::exec
			bsr	TranslateArgs		; Translate the args
			bsr	PushArgs		; Push on the EStack the args.
			move.l	d4,a0			; Reget the SYM_ENTRY.
			; Even if kernel::exec allows archived program, I must add a Twin entry
			; for compatibility with AMS (Who says Tictex ?)
			bsr	Sym2HSym		; Get HSym
			move.l	d0,-(a7)
			clr.l	-(a7)
			bsr	EM_twinSymFromExtMem	; Make a Twin Symbol
			move.l	d0,(a7)
			beq.s	\ErrorTwin
				bsr	DerefSym		; Deref it
				bset.b	#0,SYM_ENTRY.flags(a0)	; Set InUse
				bne.s	\ErrorTwin		; Already InUse ? Yes=> Donot run it again
					move.w	SYM_ENTRY.hVal(a0),d0	; Get Handle
					jsr	kernel::exec		; Execute program
					bsr	DerefSym		; Rederef if (It may be wrong)
					move.l	a0,d0			; But at least it will be a file ptr
					beq.s	\FinalP			; not an unkown ptr.
						bclr.b	#0,SYM_ENTRY.flags(a0)	; Unset InUse
						bsr	SymDelTwin_reg	; Delete Twin Symbol (It checks it it is a Twin before deleting it).
\FinalP			lea	10(a7),a7
			rts
\ErrorTwin	ER_THROW	670		; Error: Memory
\KernelExec	bsr	TranslateArgs		; Translate the args
		bsr	PushArgs		; Push on the EStack the args.
		move.w	(a7)+,d0		; HANDLE
		jmp	kernel::exec		; Execute the file
\ScriptExec:	bsr	TranslateArgs		; Translate the args
		bsr	PushArgs		; Push on the EStack the args.
		move.w	(a7)+,d0		; HANDLE
		jmp	ScriptExec		; Execute the script

; 3 : Interpret command using NG_approx
FileNameNotFound:
	pea	(a4)
	jsr	push_parse_text			; Push Text
	move.l	top_estack,(a7)
	jsr	NG_approxESI			; Evaluate it
	tst.b	SHELL_NG_DISPLAY
	beq.s	\DontDisplay
		move.l	top_estack,(a7)
		jsr	display_statements		; Retransform it to text
		move.w	d0,a0				; Get the Handle
		move.w	d0,(a7)				; Push the handle
		trap	#3				; Deref it
		pea	(a0)				; Push its address
		bsr	printf				; Display the text
		addq.l	#4,a7				; Pop its address
		bsr	DispReturn			; Display Return
		bsr	HeapFree			; Free the Text Handle 
\DontDisplay
	addq.l	#4,a7				; Fix stack Ptr
	rts

; ************************************
; ******	COMMANDS !	******
; ************************************

; Format Command
InstallFormat_cmd:
	bsr	Confirm
	tst.w	d0
	beq.s	DoRet
	FLASH_FUNC_ON				; Allow use of FlashErase
	lea	START_ARCHIVE+1000,a2
\Loop:		bsr	FlashErase
		adda.l	#$10000,a2		; Next Sector
		cmp.l	#END_ARCHIVE,a2
		bls.s	\Loop
DoReset	trap	#2

Reset_cmd:
	bsr	Confirm
	tst.w	d0
	bne.s	DoReset
DoRet	rts

InstallProductCode_cmd
	bsr	Confirm
	tst.w	d0
	bne	FL_download
	rts

InstallTIB_cmd:
	bsr	Confirm
	tst.w	d0
	bne	TIB_Install
	rts

Ls_cmd:
	move.l	a6,-(a7)
	move.l	a7,a6
	; Translate args
	lea	CommandDisp_str(pc),a2
	cmpi.w	#2,ARGC
	blt.s	\Std
		move.l	ARGV+4,a0
		cmpi.b	#'-',(a0)+
		bne.s	\Std
		cmpi.b	#'h',(a0)
		beq	\Folders
		cmpi.b	#'l',(a0)
		bne.s	\Std
		lea	LsLong2_str(pc),a2
		pea	LsLong1_str(pc)
		bsr	printf
\Std:	; Display Intro String
	pea	CUR_FOLDER_STR
	pea	Dir1_str(pc)
	bsr	printf
	move.w	#1,(a7)
	clr.b	NULL_CHAR
	; Start Displaying the files
	lea	CUR_FOLDER_STR,a0
\cvt		tst.b	(a0)+
		bne.s	\cvt
	pea	-1(a0)
	bsr	SymFindFirst
	moveq	#0,d3
\loop		move.l	a0,d0
		beq.s	\end
		addq.w	#1,d3		; One more file
		move.l	a0,a3		; Save SYM_ENTRY
		move.w	SYM_ENTRY.hVal(a0),d0
		bne.s	\NoHNull
			clr.l	-(a7)	; No Ptr
			clr.w	-(a7)	; No type
			clr.w	-(a7)	; No flags
			clr.w	-(a7)	; No size
			bra.s	\Cont
\NoHNull	move.w	d0,a0
		trap	#3		; Deref file
		pea	(a0)		; Push File Ptr
		moveq	#0,d2		
		move.w	(a0)+,d2	; Read size
		clr.w	d0		
		move.b	-1(a0,d2.l),d0	; Read type
		move.w	d0,-(a7)	; and push it
		move.w	SYM_ENTRY.flags(a3),-(a7)	; Push Flags
		move.w	d2,-(a7)	; Psh Size
\Cont		pea	(a3)		; Push Name
		pea	(a2)		; Push Format string
		bsr	printf		; Print it
		lea	18(a7),a7	; Pop args
		bsr	SymFindNext
		bra.s	\loop
\end:	move.w	d3,(a7)
	pea	Dir2_str(pc)
	bsr	printf
	move.l	a6,a7
	move.l	(a7)+,a6
	rts
\Folders
	pea	Home_str(pc)
	pea	Dir1_str(pc)
	bsr	printf
	clr.w	-(a7)
	clr.l	-(a7)
	bsr	SymFindFirst
	moveq	#0,d3
\loop2		move.l	a0,d0
		beq.s	\end
		addq.w	#1,d3		; One more file
		pea	(a0)		; Push Name
		pea	CommandDisp_str(pc)		; Push Format string
		bsr	printf		; Print it
		addq.l	#8,a7		; Pop args
		bsr	SymFindNext
		bra.s	\loop2
	
Help_cmd:
	lea	CommandTable(Pc),a2
\loop		move.w	(a2),d0
		beq.s	\end
		lea	CommandTable(Pc),a0
		pea	0(a0,d0.w)
		pea	CommandDisp_str(pc)
		bsr	printf
		addq.l	#8,a7
		addq.l	#4,a2
		bra.s	\loop
\end	bra	DispReturn

Mem_cmd:
	bsr	HeapCompress	; Compress the Heap
	subq.l	#8,a7
	pea	4(a7)		; Free
	pea	4(a7)		; FreeAfter GC
	clr.l	-(a7)		; InUse
	bsr	EM_survey
	lea	12(a7),a7
	move.l	(a7)+,d0
	add.l	d0,(a7)		; Free + FreeAfterGc
	bsr	HeapAvail
	move.l	d0,-(a7)
	move.l	#START_ARCHIVE,-(a7)
	sub.l	#BASE_END,(a7)	
	pea	MemDisplay_str(pc)
	bsr	printf
	lea	16(a7),a7
	rts

Cls_cmd:
	jmp	clrscr		; May be > 32K ?

Cd_cmd:	cmpi.w	#2,ARGC
	blt	DispArgFileName
	move.l	ARGV+4,a0		; First Arg ptr
\Loop		move.b	(a0)+,d0	; Loop to delete last '\'
		beq.s	\Done		; in cd main\ for example.
		cmpi.b	#'\',d0
		bne.s	\Loop
	tst.b	(a0)			; Check if next char is ZERO
	bne.s	\Done			; No so it isn't '\\\0'
		clr.b	-(a0)
\Done	lea	FolderCur(pc),a0
	bra.s	CommunOneFile	
RmArc_cmd:
	lea	EM_delSym(pc),a0
	bra.s	CommunOneFile
Get_cmd:
	lea	cmd_getcalc(pc),a0
	bra.s	CommunOneFile
SendCalc_cmd:
	lea	cmd_sendcalc(pc),a0
	bra.s	CommunOneFile
UnArc_cmd:
	lea	EM_moveSymFromExtMem(pc),a0
	bra.s	CommunOneFile
Rm_cmd:	lea	SymDel(pc),a0
	bra.s	CommunOneFile
MkDir_cmd:
	lea	FolderAdd(pc),a0
	bra.s	CommunOneFile
RmDir_cmd:
	lea	FolderDel(pc),a0
	bra.s	CommunOneFile
Arc_cmd:
	lea	EM_moveSymToExtMem(pc),a0

CommunOneFile:
	cmpi.w	#2,ARGC
	blt	DispArgFileName
	lea	-100(a7),a7
	move.l	a7,a3			; Buffer
	move.l	a0,a2			; Function
\Loop		move.w	ARGC,d0		; ARGC is the loop counter
		subq.w	#1,d0
		beq.s	\Done		; last one is done
		move.w	d0,ARGC
		lsl.w	#2,d0		; Last argument
		lea	ARGV,a1
		move.l	0(a1,d0.w),a1	; Arg ptr
		move.l	a3,a0
		clr.b	(a0)+		; Convert Arg to Ti format
\cvt:			move.b	(a1)+,(a0)+
			bne.s	\cvt		
		clr.l	-(a7)
		pea	-1(a0)
		jsr	(a2)		; Call the function
		addq.l	#8,a7
		tst.w	d0
		bne.s	\Success
			pea	1(a3)
			pea	Failed_str(pc)
			bsr	errorPrintf
			addq.l	#8,a7
\Success	bra.s	\Loop
\Done	lea	100(a7),a7
	rts
			
Clean_cmd:
	movem.l	d3-d7/a2-a6,-(a7)
	jsr	PID_clean		; Erase all the background process
	bsr	clean_up		; Clean the kernel files (Before the heap)/ Warning it may change the vector tables (Ex: GrayOn).
	bsr	CleanTwinFiles		; Clean the Twin files
	bsr	InstallVectors		; Reinstall the vectors
	bsr	EStackReInit		; Reset the EStack
	; Unlock all the VAR
	move.w	#2,-(a7)
	clr.l	-(a7)
	bsr	SymFindFirst		; Find all the vars
\loop3		move.w	SYM_ENTRY.hVal(a0),(a7)
		andi.w	#~SF_LOCKED,SYM_ENTRY.flags(a0)
		bsr	HeapUnlock
		bsr	SymFindNext
		move.l	a0,d0
		bne.s	\loop3
	; Erase Handles
	lea	HEAP_TABLE+4,a2		; HEAP TABLE (We skip the first one which is set to $FFFFFFFF)
	move.w	#MAX_HANDLES-2,d5	; d5 = number of handles
	moveq	#1,d3			; d3 = handle number = 1
\loop2		tst.l	(a2)+
		beq.s	\NextHandle
		move.w	d3,d0
		cmpi.w	#FOLDER_LIST_HANDLE,d0	; Do not delete Home directory !
		beq.s	\NextHandle
		cmpi.w	#ESTACK_HANDLE,d0	; Do not delete EStack !
		beq.s	\NextHandle
		bsr	kernel::Hd2Sym		; Then see if this handle is in VAT (it is a file or a folder)
		move.l	a0,d0			; Test if Null
		bne.s	\NextHandle
			move.w	d3,(a7)		; Free this handle (It may be usefull, but 
			bsr	HeapFree
\NextHandle:	addq.w	#1,d3			; increase handle number
		dbf	d5,\loop2		; Next Handle
	addq.l	#6,a7				; Pop the stack
	bsr	HeapCheck			; Check the heap and 
	bsr	HeapCompress			; Compress the Heap
	movem.l	(a7)+,d3-d7/a2-a6
	rts
	
Mv_cmd:
	cmpi.w	#3,ARGC
	bne	DispArg2Files
	; Convert to Ti format (FIXME: Buggy if use of wildcards)
	move.l	ARGV+4,a0		; SrcFileName
\cvt1		tst.b	(a0)+
		bne.s	\cvt1
	move.l	ARGV+8,a1		; Dest File Name
\cvt2		tst.b	(a1)+
		bne.s	\cvt2
	pea	-1(a1)			; Dest File Name
	pea	-1(a0)			; Src File Name
	bsr	SymMove
	addq.l	#8,a7
	tst.w	d0
	bne.s	\Ok2
		pea	ST_StrA(pc)
		pea	Failed_str(pc)
		bsr	errorPrintf
		addq.l	#8,a7
\Ok2:	rts
	
Cp_cmd:
	cmpi.w	#3,ARGC
	bne	DispArg2Files
	; Convert to Ti format
	subq.l	#6,a7			; Stack Frame
	move.l	ARGV+4,a0		; SrcFileName
	bsr	ASymFindPtr
	move.l	a0,d0
	beq.s	\Fail
		move.w	SYM_ENTRY.hVal(a0),(a7)	; Push Handle
		moveq	#0,d0
		move.w	(a7),a0
		trap	#3
		move.w	(a0),d0
		addq.l	#3,d0
		bsr	HeapAlloc_reg
		tst.w	d0
		beq.s	\Fail
			move.w	(a7),a0		; Reload Handle
			trap	#3
			move.w	(a0),d1		; Reload Size
			addq.w	#3,d1
			move.l	a0,a1		; Src = a1
			move.w	d0,(a7)		; Save Handle
			move.w	d0,a0		; Dest 
			trap	#3		; a0 = dest
\CpyLoop			move.b	(a1)+,(a0)+
				subq.w	#1,d1
				bne.s	\CpyLoop	
			move.l	ARGV+8,a0	; Dest File Name
			bsr	ASymAdd		; Add file in VAT
			tst.l	d0
			beq.s	\Fail2
				bsr	DerefSym_Reg
				move.w	(a7),SYM_ENTRY.hVal(a0)
				bra.s	\Ok2
\Fail2			bsr	HeapFree
\Fail	pea	ST_StrA(pc)
	pea	Failed_str(pc)
	bsr	errorPrintf
	addq.l	#8,a7
\Ok2:	addq.l	#6,a7
	rts

Side_cmd:
	moveq	#0,d0
	cmpi.w	#1,ARGC
	beq.s	\Go
		move.l	ARGV+4,d0
\Go	move.l	d0,filename
	jsr	run_side
	jmp	clrscr
	
Echo_cmd:
	cmpi.w	#2,ARGC
	blt.s	\No
		move.l	ARGV+4,-(a7)
		pea	String_str(pc)
		bsr	printf
		addq.l	#8,a7
		bra	DispReturn
\No	rts
	
UnPPG_cmd:
 ifne 0 ; no builtin ttunpack, it is non-Free
	cmpi.w	#3,ARGC
	bne	DispArg2Files
	; Find Src Name
	move.l	ARGV+4,a0		; SrcFileName
	bsr	ASymFindPtr
	move.l	a0,d0
	bne.s	\Ok2
 endc
\Fail		move.l	ARGV+4,-(a7)
		pea	Failed_str(pc)
		bsr	errorPrintf
		addq.l	#4,a7
 ifne 0 ; no builtin ttunpack, it is non-Free
		bra.s	\done
\Ok2:	; Extract PPG
	move.w	SYM_ENTRY.hVal(a0),d4	; Source Handle
	bsr	ExtractPPG		; Extract PPG
	move.w	d0,d4
	beq.s	\Fail			; FIXME: Unlocked it !
	; Add new file
	move.l	ARGV+8,a0		; DestFileName
	bsr	ASymAdd
	bsr	DerefSym_Reg
	move.l	a0,d0
	bne.s	\Ok4
		move.w	d4,d0
		bsr	HeapFree_reg
		bra.s	\Fail
\Ok4	move.w	d4,SYM_ENTRY.hVal(a0)
 endc
\done:	rts

Read_cmd:
	cmpi.w	#2,ARGC				; Check Arg
	blt	DispArgFileName
	movem.l	d3-d7/a2-a6,-(a7)
	lea	(-4*ARG_MAX)(a7),a7		; Copy VARIABLE ARGS
	move.l	a7,a3
	move.l	a3,a1
	lea	ARGV+4,a0
	moveq	#ARG_MAX-2,d0
\CopyArg	move.l	(a0)+,(a1)+
		dbf	d0,\CopyArg
	lea	(-SHELL_MAX_LINE-6)(a7),a7
	move.l	a7,a4
	clr.b	(a4)+				; Clear first byte (<= Translate Arg)
	move.w	ARGC,d5				; Number of variable to read
	subq.w	#1,d5				; -1
\VarLoop
	; Input a string
\Input		move.l	a4,a0
		moveq	#SHELL_MAX_LINE,d0
		lea	stdin,a1
		jsr	fgets
		move.l	a0,d0			; End of input?
		beq.s	\End
		tst.b	(a4)
		beq.s	\Input	
	; Delete final char if it is \n
\StrLoop	tst.b	(a0)+
		bne.s	\StrLoop
	cmpi.b	#10,-2(a0)
	bne.s	\SkipTranslateChar
		clr.b	-2(a0)
\SkipTranslateChar
	; Translate it
	bsr	TranslateArgs
	; Save the vars
	move.w	ARGC,d4
	lea	ARGV,a2
\VarSaveLoop		bsr	EStackReInit	; Reset EStack
			move.l	(a2)+,-(a7)
			bsr	push_zstr	; Push STRING
			move.l	top_estack,(a7)
			clr.w	-(a7)		; Size is useless
			move.w	#STOF_ESI,-(a7)
			move.l	(a3)+,a0	; Read VAR Name . Should be 0,NAME,0 where ptr is N
			\Cvt:	tst.b	(a0)+
				bne.s	\Cvt
			pea	-1(a0)
			bsr	VarStore
			lea	12(a7),a7
			subq.w	#1,d5
			beq.s	\End
			subq.w	#1,d4
			bne.s	\VarSaveLoop
	bra.s	\VarLoop
\End	lea	(SHELL_MAX_LINE+6+4*ARG_MAX)(a7),a7
	movem.l	(a7)+,d3-d7/a2-a6
	rts
	
Ps_cmd:
	pea	PID_status(pc)
	bsr	printf
	addq.l	#4,a7
	lea	PROCESS_TABLE,a2
	moveq	#MAX_PROCESS-1,d3
	clr.w	d4
\loop		move.w	(a2)+,d0
		beq.s	\next
		move.w	d0,a0
		trap	#3
		pea	8(a0)		; Push String Name
		move.l	(a0),-(a7)	; Push Stack Size
		move.w	d4,-(a7)
		pea	PID_string(pc)
		bsr	printf
		lea	14(a7),a7
\next		addq.w	#1,d4
		dbf	d3,\loop
	rts	

; kill pid
Kill_cmd:
	cmp.w	#2,ARGC
	blt	DispArgNumber
	move.l	ARGV+4,a0		; Number
	bsr	atol			; Get number
	; Check Pid
	jsr	PID_Check
	tst.w	d1
	ble.s	\Fail
	move.w	d1,a0
	; Print Name of Process
	trap	#3
	pea	8(a0)
	pea	PID_KillProcess(pc)
	bsr	printf
	addq.l	#8,a7
	bsr	Confirm
	tst.b	d0
	beq.s	\Fail
		;if (argv==2)
		;	Call kill func if != NULL (& set Kill func to NULL before calling !)
		cmpi.w	#2,ARGC
		bne.s	\DontCallKillFunction
			move.w	(a2),a0
			trap	#3
			move.l	4(a0),a1
			clr.l	4(a0)
			move.l	a1,d0
			beq.s	\DontCallKillFunction
				; Restore context?
				jsr	(a1)
\DontCallKillFunction:
		; Free Process
		move.w	(a2),d0
		clr.w	(a2)
		bsr	HeapFree_reg
\Fail	rts

; go pid
Go_cmd:
	move.w	PREVIOUS_PROCESS,d0
	cmpi.w	#1,ARGC
	beq.s	\Continue
		move.l	ARGV+4,a0		; Number
		bsr	atol			; Get number
\Continue
	jmp	PID_Go

Flags_cmd:
	lea	FlagsTable(pc),a2
	cmpi.w	#2,ARGC
	blt	\DispFlagsValue
\Loop	subq.w	#1,ARGC
	beq.s	\Done		; last one is done
		move.w	ARGC,d0
		lsl.w	#2,d0		; Last argument
		lea	ARGV,a1
		move.l	0(a1,d0.w),a3	; Arg ptr
		move.w	#'=',-(a7)
		pea	(a3)
		bsr	strchr		; Find '='
		addq.l	#6,a7
		move.l	a0,d0
		beq.s	\Loop		; Not found, skip
			clr.b	(a0)+
			cmpi.b	#'1',(a0)
			seq.b	d3
			moveq	#-1,d2			; Bit Flag
			\TableLoop:
			move.w	(a2)+,d0
			beq.s	\Loop
				addq.w	#1,d2		; Next Bit
				lea	0(a2,d0.w),a0	; Next Name
				move.l	a3,a1		; Arg
				bsr	strcmp_reg
				tst.w	d0
				bne.s	\TableLoop
			bclr.b	d2,SHELL_FLAGS
			tst.b	d3
			beq.s	\Loop
				bset.b	d2,SHELL_FLAGS
				bra.s	\Loop
\Done	rts
\DispFlagsValue
	moveq	#-1,d3
\DisplayLoop	
	move.w	(a2)+,d0
	beq.s	\Done
		addq.w	#1,d3
		pea	ON_str(pc)
		btst.b	d3,SHELL_FLAGS
		bne.s	\Go
			addq.l	#3,(a7)
\Go		pea	0(a2,d0.w)
		pea	FlagsDisplay_str(pc)
		bsr	printf
		lea	12(a7),a7
		bra.s	\DisplayLoop

FlagsTable:	dc.w	AutoArchive_str-*-2
		dc.w	OffSwitch_str-*-2
		dc.w	GetKeySwitch_str-*-2
		dc.w	0

More_cmd:
	move.l	ARGV+4,a0
	cmpi.w	#1,ARGC
	beq.s	\Check
		lea	stdin,a2
		lea	ReadModeStr,a1
		jsr	freopen
\Check
	btst.b	#0,stdin
	bne.s	\Done
	clr.w	PRINTF_LINE_COUNTER
\Loop		pea	stdin
		bsr.s	LocalFgetc
		addq.l	#4,a7
		tst.w	d0
		blt.s	\Done
		bsr.s	\PutChar
		bra.s	\Loop
\Done	moveq	#10,d0
\PutChar
	pea	stdout
	move.w	d0,-(a7)
	bsr.s	LocalFputc
	addq.l	#6,a7
	rts

LocalFgetc	jmp	fgetc
LocalFputc	jmp	fputc
	
Cat_cmd:
	cmpi.w #1,ARGC
	ble.s \stdin
	lea  ARGV+4,a2
\LoopFilename:
	lea	ReadModeStr,a1
	move.l	(a2)+,a0
	cmpi.b	#'-',(a0)
	bne.s	\fopen
\stdin:
	lea	stdin,a0
	btst.b	#0,(a0)
	bne.s	\Return
	bra.s	\open
\fopen:
	jsr	fopen
	move.l	a0,d0
	beq.s	\Return
\open:
	pea	(a0)
\loop
		bsr.s	LocalFgetc
		tst.w	d0
		blt.s	\end
		pea	stdout
		move.w	d0,-(a7)
		bsr	LocalFputc
		addq.l	#6,a7
		bra.s	\loop
\end:	move.l	(a7)+,a0
	;jsr	fclose		; FIXME: Necessary ?
	subq.w	#1,ARGC
	bgt.s	\LoopFilename
\Return:
	rts

Grep_cmd:
	; argv[1] = seed
	cmp.w	#2,ARGC
	blt	\Return
	bgt.s	\OkFilename
		; Check if stdout is redirected
		move.w	stdout+2,a0
		lea	\stdin_str+4(pc),a2
		btst.b	#0,stdout
		beq	\Return
		bra.s	\HandleEntry
\stdin_str	dc.l	Stdin_str
\OkFilename:
	subq.w	#2,ARGV
	lea	ARGV+8,a2
\LoopFile
	move.l	(a2)+,a0
	bsr	ASymFindPtr
	move.l	a0,d0
	beq.s	\NextFile
	move.w	SYM_ENTRY.hVal(a0),a0
\HandleEntry
	trap  #3
	moveq #0,d0
	move.w (a0)+,d0
	cmpi.b #$E0,-1(a0,d0.l)
	bne.s \NextFile
	addq.l #3,a0
	move.l a0,a3
\Loop
	move.l ARGV+4,-(a7)
	pea (a0)
	bsr strstr
	addq.l #8,a7
	move.l a0,d0
	beq.s \NextFile
\BeginLine	cmp.l	a0,a3
		bge.s	\FoundBeginLine
		cmpi.b	#10,-(a0)
		bne.s	\BeginLine
	addq.l #2,a0
\FoundBeginLine:
	pea (a0)			; push string
\LineLoop	move.b	(a0)+,d0		; Calculate string length
		beq.s	\LineLoopEnd
		cmpi.b	#10,d0
		bne.s	\LineLoop
\LineLoopEnd
	move.l	a0,d3
	sub.l	(a7),a0
	subq.w	#3,a0			; -LF -+
	move.w	a0,-(a7)		; Push string precision
	move.l	-4(a2),-(a7)
	bsr.s	\printf
		dc.b	"%s: %.*s",10,0
\printf	bsr	printf
	lea	14(a7),a7
	move.l	d3,a0
	tst.b	(a0)
	bne.s	\Loop
\NextFile
	subq.w #1,ARGC
	bge.s \LoopFile 
\Return:
	rts

HexDump_cmd:
	cmpi.w	#2,ARGC
	bne	DispArgNumber
	movem.l	d3/a3,-(a7)
	move.l	ARGV+4,a0		; Number
	bsr	atol			; Get number
	move.l	d0,a3
	moveq	#8-1,d3
\loop2		moveq	#8-1,d1
		addq.l	#8,a3
\loop			clr.w	d0
			move.b	-(a3),d0
			move.w	d0,-(a7)
			dbf	d1,\loop
		pea	(a3)
		addq.l	#8,a3
		pea	HexFormat_str(pc)
		bsr	printf
		lea	(8*2+4+4)(a7),a7	
		dbf	d3,\loop2
	movem.l	(a7)+,d3/a3
	rts
	
HexDump_str		dc.b	"hexdump",0
Grep_str		dc.b	"grep",0
Cat_str			dc.b	"cat",0
More_str		dc.b	"more",0
Flags_str		dc.b	"flags",0
InstallFormat_str	dc.b	"install format",0	
Ps_str			dc.b	"ps",0
Go_str			dc.b	"go",0
Kill_str		dc.b	"kill",0
Read_str		dc.b	"read",0
InstallTIB_str		dc.b	"install tib",0
UnPPG_str		dc.b	"unppg",0
Echo_str		dc.b	"echo",0
Side_str		dc.b	"side",0
Get_str			dc.b	"getcalc",0
Cp_str			dc.b	"cp",0
Mv_str			dc.b	"mv",0
Clean_str		dc.b	"clean",0
SendCalc_str		dc.b	"sendcalc",0
Cd_str			dc.b	"cd",0
RmDir_str		dc.b	"rmdir",0
MkDir_str		dc.b	"mkdir",0
Rm_str			dc.b	"rm",0
Cls_str			dc.b	"cls",0	
Arc_str			dc.b	"arc",0
UnArc_str		dc.b	"unarc",0
Mem_str			dc.b	"mem",0
InstallProductCode_str	dc.b	"install product code",0
Reset_str		dc.b	"reset",0
Help_str		dc.b	"help",0
Ls_str			dc.b	"ls",0
RmArc_str		dc.b	"rmarc",0
AutoArchive_str		dc.b	"AutoArc",0
OffSwitch_str		dc.b	"OffSwitch",0
GetKeySwitch_str	dc.b	"GetKeySwitch",0
	EVEN
