;*
;* PedroM - Operating System for Ti-89/Ti-92+/V200.
;* Copyright (C) 2003 PpHd
;*
;* This program is free software ; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation;
;* either version 2 of the License, or (at your option) any later version. 
;* 
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
;* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;* See the GNU General Public License for more details. 
;* 
;* You should have received a copy of the GNU General Public License along with this program;
;* if not, write to the 
;* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

;******************************************************************
;***                                                            ***
;***            	Main FILE				***
;***                                                            ***
;******************************************************************

PEDROM_VERSION		EQU	$0080
PEDROM_STR_VERSION	EQU	'0.80'

**********************************************************
	ifd	TI92P
ROM_BASE		EQU	$400000	; $400000 for ti92+ / $200000 for 89 & V200
	endif
	ifd	TI89TI
ROM_BASE		EQU	$800000	; $400000 for ti92+ / $200000 for 89 & V200
	endif
	ifnd	TI92P
	ifnd	TI89TI
ROM_BASE		EQU	$200000	; $400000 for ti92+ / $200000 for 89 & V200	
	endif	
	endif	
**********************************************************
	section "_st1"
	include "Vectors.h"		; Vectors's table
	include	"Mem.h"			; Macros usefull for defining struct
	include	"Const.h"		; Constants 
	include "Vars.h"		; Global vars
	include "kheader.h"		; Kernel Header
**********************************************************
CODE_START:
Trap_2:
        include	"Boot.asm"		; Boot Code (Set IO ports, clear RAM, unprotect, ...) and go to the Shell Command loop - MUST BE THE FIRST INCLUDE FILE -
	include	"Flash.asm"		; Flash Code (Write to Flash, ...) - MUST BE THE SECOND INCLUDE FILE -
	include "Shell.asm"		; Command shell
	include "Link.asm"		; Link functions.
	include	"Strings.asm"		; String character
	include "Vat.asm"		; VAT functions.
	include "Memstr.asm"		; memcpy/strcmp/... functions
	include	"Heap.asm"		; Heap functions
	include "Graph.asm"		; Graph functions
	include	"Misc.asm"		; Various functions (1)
	include "Estack.asm"		; EStack functions (1)
	include	"RomVoid.asm"		; All other rom_calls 
BASE1_END:				; End of first Base of code : MUST BE <$418000

***********************************************************
***							***
***  $418000-$419FFF       8K      [read protected]	***
***							***
***********************************************************
	section ".text"
	include "library.asm"		; Export API
	include	"Printf.asm"		; Printf functions
	include "Kernel.asm"		; Kernel functions
	include "Window.asm"		; Window functions
	include "Dialog.asm"		; Dialog functions
	include "Bitmap.asm"		; Bitmap functions
	include "Estack2.asm"		; EStack functions (2)
	include "Bcd.asm"		; Float Functions (1)
	include "Clipline.asm"		; ClipLine functions (Window needs DrawClipLine)
	include "Ellipse.asm"		; Ellipses functions (Window needs DrawClipEllipse)
	include "misc2.asm"		; Various functions (2)
	include	"shell2.asm"		; Shell (2)
	include "Script.asm"		; Script functions
	ifnd	TI89
		include "side92.asm"	; Side
	endif
	ifd	TI89
		include	"side89.asm"
	endif
	include "files.asm"		; Files	
	include	"Ints.asm"		; Auto Ints 
	include	"Vectors.asm"		; Vectors (Error, traps, ...)
	include	"process.asm"		; Process Functions
	include "qsort.asm"		; Quick Sort
	include	"Long.asm"		; Long Functions (32 bits / 32 bits, ...)
	include "md5.asm"		; MD5 Functions
	include "float.asm"		; Float functions (2)
	include "cert.asm"		; Certificate functions.

***********************************************************
***			DATA				***
***********************************************************
		CNOP	0,4		; Long Alignement for DB92
MediumFont	incbin	"Fontes.bin"	; Font Data
		EVEN
		include	"RomCalls.h"	; Romcalls table ($C8)

License_str	dc.b	"(http://www.timetoteam.fr.st)",10,10
		dc.b	"This program is free software; you can",10
		dc.b	"redistribute it and/or modify it under",10
		dc.b	"the terms of the GNU GPL as published by",10
		dc.b	"the Free Software Foundation (version 2,",10
		dc.b	"or any later version).",10,10
		dc.b	"It is distributed WITHOUT ANY WARRANTY.",10,10
		dc.b	"See the GNU General Public License for",10
		dc.b	"more details (http://www.gnu.org).",0

		
BASE_END:				; MUST BE < $430000

	END     			; End of assembly
