#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "gtk_romv_cb.h"
#include "gtk_romv_dbox.h"
#include "support.h"

#include "platform.h"
#include "struct.h"
#include "specific.h"
#include "gtk_msg_cb.h"
#include "paths.h"
#include "tilibs.h"

#define CACHE_FILE "ROMs.lst"

gchar *chosen_rom = NULL;
gchar *chosen_tib = NULL;
extern int romOk;

gint display_romversion_dbox()
{
  GtkWidget *dbox, *dbox2;
  gpointer user_data;
  GtkWidget *list = NULL;
  gchar *text[6]; // 6 columns
  gchar buffer[MAXCHARS];
  int i;
  FILE *fp;
  const gchar *filename = CACHE_FILE;

  dbox = create_romversion_dbox();
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "clist1");
  list = GTK_WIDGET(user_data);

  /* List all ROMs available in the ROM directory */
  gtk_widget_show_all(dbox2 = create_window1());
  while( gtk_events_pending() ) { gtk_main_iteration(); }
  ti68k_scanRomImages(inst_paths.rom_dir, filename);
  gtk_widget_destroy(dbox2);
  while( gtk_events_pending() ) { gtk_main_iteration(); }

  fp = fopen(filename, "rt");
  if(fp == NULL)
    {
      DISPLAY("Unable to open this file: %s\n", filename);
      return -1;
    }
  while(!feof(fp))
    {
      for(i=0; i<6; i++)
	{
	  fscanf(fp, "%s\t", buffer);
	  text[i] = g_strdup(buffer);
	}
      gtk_clist_append(GTK_CLIST(list), text);	  
      for(i=0; i<6; i++) g_free(text[i]);
    } 
  fclose(fp);
  
  gtk_widget_show_all(dbox);
  return 0;
}

void
on_button6_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Load the ROM */
  if(chosen_rom != NULL)
    {
      g_free(options.rom_file);
      options.rom_file = g_strconcat(inst_paths.rom_dir,
				     chosen_rom, NULL);
      if(ti68k_loadRom(options.rom_file)) 
	{
	  msg_box("Error", "Can not open the ROM image.");
	  return;
	}
      romOk = 1;
    }

  if(chosen_tib != NULL)
    {
      if(!romOk)
	{
	  msg_box("Error", "A ROM must have been loaded.");
	  return;
	}
      g_free(options.tib_file);
      options.tib_file = g_strconcat(inst_paths.rom_dir,
				     chosen_tib, NULL);
      if(ti68k_loadTib(options.tib_file))
	{
	  msg_box("Error", "Can not open the ROM image.");
	  return;
	}
    }

  ti68k_resetLib68k();
  update_window(); //added by Tom
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_button7_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_romversion_dbox_destroy             (GtkObject       *object,
                                        gpointer         user_data)
{
  unsuspend();
}


void
on_romv_clist1_select_row              (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gchar *filename = NULL;
  gchar *ext = NULL;

  gtk_clist_get_text(clist, row, 0, &filename);
  ext = strrchr(filename, '.');
#ifdef __WIN32__
  if(!stricmp(ext, ".rom"))
#else
  if(!strcasecmp(ext, ".rom"))
#endif
    {
      chosen_rom = g_strdup(filename);
    }
  else
    {
      chosen_tib = g_strdup(filename);
    }
}


void
on_romv_clist1_unselect_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
}


gboolean
on_romv_clist1_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}

/**/
