/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTOOLBAR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int lastFocusId;
    ToolItem[] items;
    boolean ignoreResize;
    ImageList imageList;
    ImageList disabledImageList;
    ImageList hotImageList;
    static final int ToolBarProc;
    static final TCHAR ToolBarClass;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;

    static {
        ToolBarClass = new TCHAR(0, "ToolbarWindow32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ToolBarClass, wNDCLASS);
        ToolBarProc = wNDCLASS.lpfnWndProc;
    }

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        if (n == 262) {
            return OS.DefWindowProc(this.handle, n, n2, n3);
        }
        return OS.CallWindowProc(ToolBarProc, this.handle, n, n2, n3);
    }

    static int checkStyle(int n) {
        if ((n & 0x800000) == 0) {
            n |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            n &= 0xFFFFFFBF;
        }
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        if (this.layout != null) {
            return super.computeSize(n, n2, bl);
        }
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x200) != 0) {
            object = new RECT();
            TBBUTTON tBBUTTON = new TBBUTTON();
            int n5 = OS.SendMessage(this.handle, 1048, 0, 0);
            int n6 = 0;
            while (n6 < n5) {
                OS.SendMessage(this.handle, 1053, n6, (RECT)object);
                n4 = Math.max(n4, ((RECT)object).bottom);
                OS.SendMessage(this.handle, 1047, n6, tBBUTTON);
                if ((tBBUTTON.fsStyle & 1) == 0) {
                    n3 = Math.max(n3, ((RECT)object).right);
                }
                ++n6;
            }
        } else {
            object = new RECT();
            OS.GetWindowRect(this.handle, (RECT)object);
            int n7 = ((RECT)object).right - ((RECT)object).left;
            int n8 = ((RECT)object).bottom - ((RECT)object).top;
            int n9 = this.getBorderWidth();
            int n10 = n == -1 ? 16383 : n + n9 * 2;
            int n11 = n2 == -1 ? 16383 : n2 + n9 * 2;
            boolean bl2 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            this.ignoreResize = true;
            if (bl2) {
                OS.UpdateWindow(this.handle);
            }
            int n12 = 30;
            this.SetWindowPos(this.handle, 0, 0, 0, n10, n11, n12);
            int n13 = OS.SendMessage(this.handle, 1048, 0, 0);
            if (n13 != 0) {
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, n13 - 1, rECT);
                n3 = Math.max(n3, rECT.right);
                n4 = Math.max(n4, rECT.bottom);
            }
            this.SetWindowPos(this.handle, 0, 0, 0, n7, n8, n12);
            if (bl2) {
                OS.ValidateRect(this.handle, null);
            }
            this.ignoreResize = false;
        }
        if (n3 == 0) {
            n3 = 24;
        }
        if (n4 == 0) {
            n4 = 22;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        object = this.computeTrim(0, 0, n3, n4);
        n3 = ((Rectangle)object).width;
        n4 = ((Rectangle)object).height;
        return new Point(n3, n4);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = OS.GetWindowLong(this.handle, -16);
        if ((n5 & 0x40) == 0) {
            rectangle.height += 2;
        }
        return rectangle;
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        int n = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n, 0);
        OS.SendMessage(this.handle, 1054, 20, 0);
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
        int n2 = 9;
        OS.SendMessage(this.handle, 1108, 0, n2);
    }

    void createItem(ToolItem toolItem, int n) {
        int n2 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        int n3 = 0;
        while (n3 < this.items.length && this.items[n3] != null) {
            ++n3;
        }
        if (n3 == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        int n4 = toolItem.widgetStyle();
        TBBUTTON tBBUTTON = new TBBUTTON();
        tBBUTTON.idCommand = n3;
        tBBUTTON.fsStyle = (byte)n4;
        tBBUTTON.fsState = (byte)4;
        if ((n4 & 1) == 0) {
            tBBUTTON.iBitmap = -2;
        }
        if (OS.SendMessage(this.handle, OS.TB_INSERTBUTTON, n, tBBUTTON) == 0) {
            this.error(14);
        }
        toolItem.id = n3;
        this.items[toolItem.id] = toolItem;
        if ((this.style & 0x200) != 0) {
            this.setRows(n2 + 1);
        }
        this.layoutItems();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.lastFocusId = -1;
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    void destroyItem(ToolItem toolItem) {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = 32;
        tBBUTTONINFO.dwMask = 9;
        int n = OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, toolItem.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            if (this.imageList != null) {
                this.imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.hotImageList != null) {
                this.hotImageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.disabledImageList != null) {
                this.disabledImageList.put(tBBUTTONINFO.iImage, null);
            }
        }
        OS.SendMessage(this.handle, 1046, n, 0);
        if (toolItem.id == this.lastFocusId) {
            this.lastFocusId = -1;
        }
        this.items[toolItem.id] = null;
        toolItem.id = -1;
        int n2 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n2 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 1072, 0, 0);
                this.display.releaseToolImageList(this.imageList);
            }
            if (this.hotImageList != null) {
                OS.SendMessage(this.handle, 1076, 0, 0);
                this.display.releaseToolHotImageList(this.hotImageList);
            }
            if (this.disabledImageList != null) {
                OS.SendMessage(this.handle, 1078, 0, 0);
                this.display.releaseToolDisabledImageList(this.disabledImageList);
            }
            this.disabledImageList = null;
            this.hotImageList = null;
            this.imageList = null;
            this.items = new ToolItem[4];
        }
        if ((this.style & 0x200) != 0) {
            this.setRows(n2 - 1);
        }
        this.layoutItems();
    }

    ImageList getDisabledImageList() {
        return this.disabledImageList;
    }

    ImageList getHotImageList() {
        return this.hotImageList;
    }

    ImageList getImageList() {
        return this.imageList;
    }

    public ToolItem getItem(int n) {
        TBBUTTON tBBUTTON;
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n < 0 || n >= n3) {
            this.error(6);
        }
        if ((n2 = OS.SendMessage(this.handle, 1047, n, tBBUTTON = new TBBUTTON())) == 0) {
            this.error(8);
        }
        return this.items[tBBUTTON.idCommand];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            Rectangle rectangle = toolItemArray[n].getBounds();
            if (rectangle.contains(point)) {
                return toolItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 1048, 0, 0);
        TBBUTTON tBBUTTON = new TBBUTTON();
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, 1047, n2, tBBUTTON);
            toolItemArray[n2] = this.items[tBBUTTON.idCommand];
            ++n2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            return OS.SendMessage(this.handle, 1048, 0, 0);
        }
        return OS.SendMessage(this.handle, 1064, 0, 0);
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1049, toolItem.id, 0);
    }

    void layoutItems() {
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null) {
                toolItem.resizeControl();
            }
            ++n;
        }
    }

    boolean mnemonicHit(char c) {
        int[] nArray;
        int n = Display.wcsToMbcs(c);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, n, nArray = new int[1]) == 0) {
            return false;
        }
        if ((this.style & 0x800000) != 0 && !this.setTabGroupFocus()) {
            return false;
        }
        int n2 = OS.SendMessage(this.handle, 1049, nArray[0], 0);
        if (n2 == -1) {
            return false;
        }
        OS.SendMessage(this.handle, 1096, n2, 0);
        this.items[nArray[0]].click(false);
        return true;
    }

    boolean mnemonicMatch(char c) {
        int[] nArray;
        int n = Display.wcsToMbcs(c);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, n, nArray = new int[1]) == 0) {
            return false;
        }
        int n2 = OS.SendMessage(this.handle, 1049, nArray[0], 0);
        if (n2 == -1) {
            return false;
        }
        return this.findMnemonic(this.items[nArray[0]].text) != '\u0000';
    }

    void releaseWidget() {
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && !toolItem.isDisposed()) {
                toolItem.releaseImages();
                toolItem.releaseResources();
            }
            ++n;
        }
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 1072, 0, 0);
            this.display.releaseToolImageList(this.imageList);
        }
        if (this.hotImageList != null) {
            OS.SendMessage(this.handle, 1076, 0, 0);
            this.display.releaseToolHotImageList(this.hotImageList);
        }
        if (this.disabledImageList != null) {
            OS.SendMessage(this.handle, 1078, 0, 0);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
        }
        this.disabledImageList = null;
        this.hotImageList = null;
        this.imageList = null;
        super.releaseWidget();
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        if (this.parent.lpwp != null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
            this.parent.setResizeChildren(false);
            this.parent.setResizeChildren(true);
        }
        super.setBounds(n, n2, n3, n4, n5);
    }

    void setDefaultFont() {
        super.setDefaultFont();
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
    }

    void setDisabledImageList(ImageList imageList) {
        if (this.disabledImageList == imageList) {
            return;
        }
        int n = 0;
        this.disabledImageList = imageList;
        if (this.disabledImageList != null) {
            n = this.disabledImageList.getHandle();
        }
        OS.SendMessage(this.handle, 1078, 0, n);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        int n = 0;
        int n2 = 60;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & n2) != 0) break;
            ++n;
        }
        if (n == this.items.length) {
            OS.SendMessage(this.handle, 1056, 0, 0);
            OS.SendMessage(this.handle, 1055, 0, 0);
        }
        this.layoutItems();
    }

    void setHotImageList(ImageList imageList) {
        if (this.hotImageList == imageList) {
            return;
        }
        int n = 0;
        this.hotImageList = imageList;
        if (this.hotImageList != null) {
            n = this.hotImageList.getHandle();
        }
        OS.SendMessage(this.handle, 1076, 0, n);
    }

    void setImageList(ImageList imageList) {
        if (this.imageList == imageList) {
            return;
        }
        int n = 0;
        this.imageList = imageList;
        if (this.imageList != null) {
            n = imageList.getHandle();
        }
        OS.SendMessage(this.handle, 1072, 0, n);
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (!super.setParent(composite)) {
            return false;
        }
        OS.SendMessage(this.handle, 1061, composite.handle, 0);
        return true;
    }

    void setRows(int n) {
        if ((this.style & 0x200) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            OS.MapWindowPoints(0, this.parent.handle, rECT, 2);
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 1063, 0x10000 | (n += 2), 0);
            int n2 = 22;
            this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n2);
            this.ignoreResize = false;
        }
    }

    boolean setTabItemFocus() {
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & 2) == 0 && toolItem.getEnabled()) break;
            ++n;
        }
        if (n == this.items.length) {
            return false;
        }
        return super.setTabItemFocus();
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        if (!this.hasCursor()) {
            return "";
        }
        int n = nMTTDISPINFO.idFrom;
        int n2 = OS.SendMessage(this.handle, 1059, 0, 0);
        if (n2 == nMTTDISPINFO.hwndFrom) {
            ToolItem toolItem;
            if (this.toolTipText != null) {
                return "";
            }
            if (n >= 0 && n < this.items.length && (toolItem = this.items[n]) != null) {
                return toolItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 4 | 0x100 | 0x2000;
        if ((this.style & 8) == 0) {
            n |= 0x40;
        }
        if ((this.style & 0x40) != 0) {
            n |= 0x200;
        }
        if ((this.style & 0x800000) != 0) {
            n |= 0x800;
        }
        if ((this.style & 0x20000) != 0) {
            n |= 0x1000;
        }
        return n;
    }

    TCHAR windowClass() {
        return ToolBarClass;
    }

    int windowProc() {
        return ToolBarProc;
    }

    LRESULT WM_COMMAND(int n, int n2) {
        LRESULT lRESULT = super.WM_COMMAND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8192);
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 32: {
                TBBUTTON tBBUTTON;
                int n3;
                int n4 = OS.SendMessage(this.handle, 1095, 0, 0);
                if (n4 == -1 || (n3 = OS.SendMessage(this.handle, 1047, n4, tBBUTTON = new TBBUTTON())) == 0) break;
                this.items[tBBUTTON.idCommand].click(false);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        TBBUTTON tBBUTTON;
        int n3 = OS.SendMessage(this.handle, 1095, 0, 0);
        int n4 = OS.SendMessage(this.handle, 1047, n3, tBBUTTON = new TBBUTTON());
        if (n4 != 0) {
            this.lastFocusId = tBBUTTON.idCommand;
        }
        return super.WM_KILLFOCUS(n, n2);
    }

    LRESULT WM_NOTIFY(int n, int n2) {
        LRESULT lRESULT = super.WM_NOTIFY(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if (this.lastFocusId != -1 && this.handle == OS.GetFocus()) {
            int n3 = OS.SendMessage(this.handle, 1049, this.lastFocusId, 0);
            OS.SendMessage(this.handle, 1096, n3, 0);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        boolean bl;
        if (this.ignoreResize) {
            int n3 = this.callWindowProc(5, n, n2);
            if (n3 == 0) {
                return LRESULT.ZERO;
            }
            return new LRESULT(n3);
        }
        RECT[] rECTArray = null;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = bl = this.drawCount == 0 && (this.style & 0x40) != 0 && OS.IsWindowVisible(this.handle) && OS.SendMessage(this.handle, 1064, 0, 0) != 1;
        if (bl) {
            n4 = OS.CreateRectRgn(0, 0, 0, 0);
            OS.GetUpdateRgn(this.handle, n4, false);
            n5 = OS.SendMessage(this.handle, 1048, 0, 0);
            rECTArray = new RECT[n5];
            int n6 = 0;
            while (n6 < n5) {
                rECTArray[n6] = new RECT();
                OS.SendMessage(this.handle, 1053, n6, rECTArray[n6]);
                ++n6;
            }
        }
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (bl) {
            int n7 = OS.SendMessage(this.handle, 1048, 0, 0);
            if (n7 == n5) {
                int n8 = 0;
                RECT rECT = new RECT();
                while (n8 < n7) {
                    OS.SendMessage(this.handle, 1053, n8, rECT);
                    if (!OS.EqualRect(rECTArray[n8], rECT)) break;
                    ++n8;
                }
                if (n8 == n7) {
                    OS.ValidateRect(this.handle, null);
                    OS.InvalidateRgn(this.handle, n4, false);
                }
            }
            OS.DeleteObject(n4);
        }
        this.layoutItems();
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        RECT rECT;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.drawCount != 0) {
            return lRESULT;
        }
        if ((this.style & 0x40) == 0) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (OS.SendMessage(this.handle, 1064, 0, 0) == 1) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n2, 28);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        RECT rECT3 = new RECT();
        OS.SetRect(rECT3, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT3);
        int n3 = rECT2.right - rECT2.left;
        int n4 = rECT2.bottom - rECT2.top;
        int n5 = rECT3.right - rECT3.left;
        int n6 = rECT3.bottom - rECT3.top;
        if (n5 > n3) {
            rECT = new RECT();
            OS.SetRect(rECT, n3 - 2, 0, n3, n6);
            OS.InvalidateRect(this.handle, rECT, false);
            OS.SetRect(rECT, rECT2.right, rECT3.top, rECT3.right, rECT3.bottom);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n6 > n4) {
            rECT = new RECT();
            OS.SetRect(rECT, rECT3.left, rECT2.bottom, rECT3.right, rECT3.bottom);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n, int n2) {
        ToolItem toolItem = this.items[n & 0xFFFF];
        if (toolItem == null) {
            return null;
        }
        return toolItem.wmCommandChild(n, n2);
    }

    LRESULT wmNotifyChild(int n, int n2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, n2, 12);
        switch (nMHDR.code) {
            case -710: {
                NMTOOLBAR nMTOOLBAR = new NMTOOLBAR();
                OS.MoveMemory(nMTOOLBAR, n2, NMTOOLBAR.sizeof);
                ToolItem toolItem = this.items[nMTOOLBAR.iItem];
                if (toolItem == null) break;
                Event event = new Event();
                event.detail = 4;
                int n3 = OS.SendMessage(this.handle, 1049, nMTOOLBAR.iItem, 0);
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, n3, rECT);
                event.x = rECT.left;
                event.y = rECT.bottom;
                toolItem.postEvent(13, event);
                break;
            }
            case -12: {
                if (this.background == -1) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n2, 48);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 3: {
                        return new LRESULT(64);
                    }
                    case 4: {
                        this.drawBackground(nMCUSTOMDRAW.hdc);
                        return null;
                    }
                }
            }
        }
        return super.wmNotifyChild(n, n2);
    }
}

