/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class Label
extends Control {
    String text = "";
    Image image;
    int font;
    static final int LabelProc;
    static final TCHAR LabelClass;

    static {
        LabelClass = new TCHAR(0, "STATIC", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, LabelClass, wNDCLASS);
        LabelProc = wNDCLASS.lpfnWndProc;
    }

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(LabelProc, this.handle, n, n2, n3);
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Widget.checkBits(n, 512, 256, 0, 0, 0, 0);
            return Widget.checkBits(n, 8, 4, 32, 0, 0, 0);
        }
        return Widget.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        boolean bl2;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getBorderWidth();
        if ((this.style & 2) != 0) {
            int n6 = OS.GetSystemMetrics(5);
            if ((this.style & 0x100) != 0) {
                n3 = 64;
                n4 = n6 * 2;
            } else {
                n3 = n6 * 2;
                n4 = 64;
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3 += n5 * 2, n4 += n5 * 2);
        }
        int n7 = OS.GetWindowLong(this.handle, -16);
        boolean bl3 = (n7 & 0xE) == 14;
        boolean bl4 = bl2 = (n7 & 3) == 3;
        if (bl3 || bl2) {
            if (this.image != null) {
                Rectangle rectangle = this.image.getBounds();
                n3 = rectangle.width;
                n4 = rectangle.height;
            }
        } else {
            int n8 = OS.GetDC(this.handle);
            int n9 = OS.SendMessage(this.handle, 49, 0, 0);
            int n10 = OS.SelectObject(n8, n9);
            RECT rECT = new RECT();
            int n11 = 9280;
            if ((this.style & 0x40) != 0 && n != -1) {
                n11 |= 0x10;
                rECT.right = n;
            }
            int n12 = OS.GetWindowTextLength(this.handle);
            TCHAR tCHAR = new TCHAR(this.getCodePage(), n12 + 1);
            OS.GetWindowText(this.handle, tCHAR, n12 + 1);
            OS.DrawText(n8, tCHAR, n12, rECT, n11);
            n3 = rECT.right - rECT.left;
            n4 = rECT.bottom - rECT.top;
            if (n4 == 0) {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n8, tEXTMETRIC);
                n4 = tEXTMETRIC.tmHeight;
            }
            if (n9 != 0) {
                OS.SelectObject(n8, n10);
            }
            OS.ReleaseDC(this.handle, n8);
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        n3 += n5 * 2;
        n4 += n5 * 2;
        if (OS.IsWinCE && !bl3 && !bl2) {
            n3 += 2;
        }
        return new Point(n3, n4);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    boolean getWrap() {
        int n = OS.GetWindowLong(this.handle, -16);
        if ((n & 3) != 0) {
            return true;
        }
        return (n & 0xC) == 0;
    }

    boolean mnemonicHit(char c) {
        Composite composite = this.parent;
        while (composite != null) {
            Control[] controlArray = composite._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (++n < controlArray.length && controlArray[n].setFocus()) {
                return true;
            }
            composite = composite.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 0xE) == 14) {
            return;
        }
        if ((n2 & 3) == 3) {
            return;
        }
        n2 &= 0xFFFFFFF0;
        if ((this.style & 0x4000) != 0 && (this.style & 0x40) == 0) {
            n2 |= 0xC;
        }
        if ((this.style & 0x1000000) != 0) {
            n2 |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            n2 |= 2;
        }
        OS.SetWindowLong(this.handle, -16, n2);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setImage(Image image) {
        int n;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            n2 = image.handle;
            switch (image.type) {
                case 0: {
                    n3 = 14;
                    n4 = 0;
                    break;
                }
                case 1: {
                    n3 = 3;
                    n4 = 1;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.image = image;
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n5 = n = OS.GetWindowLong(this.handle, -16);
        n &= 0xFFFFFFF0;
        if ((n |= n3 | 0x800 | 0x200) != n5) {
            OS.SetWindowLong(this.handle, -16, n);
        }
        OS.SendMessage(this.handle, 370, n4, n2);
        int n6 = 54;
        this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n6);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        int n2 = n = OS.GetWindowLong(this.handle, -16);
        n &= 0xFFFFF5F0;
        if ((this.style & 0x4000) != 0 && (this.style & 0x40) == 0) {
            n |= 0xC;
        }
        if ((this.style & 0x1000000) != 0) {
            n |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            n |= 2;
        }
        if (n != n2) {
            int n3 = OS.SendMessage(this.handle, 49, 0, 0);
            OS.SetWindowLong(this.handle, -16, n);
            if (n3 != 0) {
                OS.SendMessage(this.handle, 48, n3, 0);
            }
        }
        string = Display.withCrLf(string);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
    }

    void setWrap(boolean bl) {
        int n = OS.GetWindowLong(this.handle, -16);
        if ((n & 3) != 0) {
            return;
        }
        n &= 0xFFFFFFF3;
        if (!bl) {
            n |= 0xC;
        }
        OS.SetWindowLong(this.handle, -16, n);
        OS.InvalidateRect(this.handle, null, true);
    }

    int widgetExtStyle() {
        int n = super.widgetExtStyle() & 0xFFFFFDFF;
        if ((this.style & 0x800) != 0) {
            return n | 0x20000;
        }
        return n;
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x100;
        if ((this.style & 2) != 0) {
            return n | 0xD;
        }
        if ((this.style & 0x1000000) != 0) {
            return n | 1;
        }
        if ((this.style & 0x20000) != 0) {
            return n | 2;
        }
        if ((this.style & 0x40) != 0) {
            return n;
        }
        return n | 0xC;
    }

    TCHAR windowClass() {
        return LabelClass;
    }

    int windowProc() {
        return LabelProc;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 2) != 0) {
            return LRESULT.ONE;
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        boolean bl2 = (n3 & 0xE) == 14;
        boolean bl3 = bl = (n3 & 3) == 3;
        if (bl2 || bl) {
            this.drawBackground(n);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETFONT(int n, int n2) {
        LRESULT lRESULT = super.WM_GETFONT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_SETFONT(int n, int n2) {
        this.font = n;
        return super.WM_SETFONT(this.font, n2);
    }

    LRESULT WM_SIZE(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if ((this.style & 2) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        boolean bl2 = (n3 & 0xE) == 14;
        boolean bl3 = bl = (n3 & 3) == 3;
        if (bl2 || bl) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        if ((this.style & 0x1020040) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        return lRESULT;
    }

    LRESULT wmDrawChild(int n, int n2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, 48);
        this.drawBackground(dRAWITEMSTRUCT.hDC);
        if ((this.style & 0x20) != 0) {
            return null;
        }
        RECT rECT = new RECT();
        int n3 = OS.GetSystemMetrics(5);
        int n4 = 6;
        if ((this.style & 4) != 0) {
            n4 = 10;
        }
        if ((this.style & 0x100) != 0) {
            int n5 = dRAWITEMSTRUCT.top + Math.max(n3 * 2, (dRAWITEMSTRUCT.bottom - dRAWITEMSTRUCT.top) / 2);
            OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, n5);
            OS.DrawEdge(dRAWITEMSTRUCT.hDC, rECT, n4, 8);
        } else {
            int n6 = dRAWITEMSTRUCT.left + Math.max(n3 * 2, (dRAWITEMSTRUCT.right - dRAWITEMSTRUCT.left) / 2);
            OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, n6, dRAWITEMSTRUCT.bottom);
            OS.DrawEdge(dRAWITEMSTRUCT.hDC, rECT, n4, 4);
        }
        return null;
    }
}

