/* sqUnixSoundNull.c -- sound module for no sound
 *
 * Author: Ian.Piumarta@inria.fr
 * 
 * Last edited: 2003-02-09 17:53:08 by piumarta on emilia.inria.fr
 *
 *   Copyright (C) 1996-2004 by Ian Piumarta and other authors/contributors
 *                              listed elsewhere in this file.
 *   All rights reserved.
 *   
 *   This file is part of Unix Squeak.
 * 
 *      You are NOT ALLOWED to distribute modified versions of this file
 *      under its original name.  If you modify this file then you MUST
 *      rename it before making your modifications available publicly.
 * 
 *   This file is distributed in the hope that it will be useful, but WITHOUT
 *   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *   FITNESS FOR A PARTICULAR PURPOSE.
 *   
 *   You may use and/or distribute this file ONLY as part of Squeak, under
 *   the terms of the Squeak License as described in `LICENSE' in the base of
 *   this distribution, subject to the following additional restrictions:
 * 
 *   1. The origin of this software must not be misrepresented; you must not
 *      claim that you wrote the original software.  If you use this software
 *      in a product, an acknowledgment to the original author(s) (and any
 *      other contributors mentioned herein) in the product documentation
 *      would be appreciated but is not required.
 * 
 *   2. You must not distribute (or make publicly available by any
 *      means) a modified copy of this file unless you first rename it.
 * 
 *   3. This notice must not be removed or altered in any source distribution.
 * 
 *   Using (or modifying this file for use) in any context other than Squeak
 *   changes these copyright conditions.  Read the file `COPYING' in the
 *   directory `platforms/unix/doc' before proceeding with any such use.
 */

#include "sq.h"

#define FAIL(X) { success(false); return X; }

/* output */
static int    sound_AvailableSpace(void)								FAIL(8192)
static int    sound_InsertSamplesFromLeadTime(int frameCount, int srcBufPtr, int samplesOfLeadTime)	FAIL(frameCount)
static int    sound_PlaySamplesFromAtLength(int frameCount, int arrayIndex, int startIndex)		FAIL(8192)
static int    sound_PlaySilence(void)									FAIL(8192)
static int    sound_Start(int frameCount, int samplesPerSec, int stereo, int semaIndex)			FAIL(1)
static int    sound_Stop(void)										FAIL(0)
/* input */
static int    sound_StartRecording(int desiredSamplesPerSec, int stereo, int semaIndex)			FAIL(0)
static int    sound_StopRecording(void)									FAIL(0)
static double sound_GetRecordingSampleRate(void)							FAIL(0)
static int    sound_RecordSamplesIntoAtLength(int buf, int startSliceIndex, int bufferSizeInBytes)	FAIL(0)
/* mixer */
static void   sound_Volume(double *left, double *right)							{ return; }
static void   sound_SetVolume(double left, double right)						{ return; }
static int    sound_SetRecordLevel(int level)								{ return level; }

#include "SqSound.h"

SqSoundDefine(null);

#include "SqModule.h"

static void sound_parseEnvironment(void) {}

static int sound_parseArgument(int argc, char **argv)
{
  if (!strcmp(argv[0], "-nosound")) return 1;
  return 0;
}

static void  sound_printUsage(void) {}
static void  sound_printUsageNotes(void) {}
static void *sound_makeInterface(void) { return &sound_null_itf; }

SqModuleDefine(sound, null);
