

#include "protocol.h"

#include <qlayout.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qstringlist.h>

#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>


Protocol::Protocol( QWidget *parent, const char *name, bool modal, WFlags f )
    : QDialog( parent, name, modal, f )
{
    setCaption( QString(i18n("Protocol")).append(" - soundKonverter") );
    resize(700,300);
    setIcon(KGlobal::iconLoader()->loadIcon("view_text",KIcon::Small));

    QGridLayout *grid = new QGridLayout( this, 2, 1, 10, 5 );

    tCmd = new QTextEdit( this, "tCmd" );
    tCmd->setReadOnly(true);
    tCmd->setTextFormat(Qt::LogText);

    grid->addWidget( tCmd, 0, 0 );

    QHBoxLayout *buttonBox = new QHBoxLayout( );
    grid->addLayout( buttonBox, 1, 0 );

    buttonBox->addStretch();

    pOk = new QPushButton( i18n("Close"), this, "pOk" );
    pOk->setFocus();
    buttonBox->addWidget( pOk );

    connect( pOk, SIGNAL(clicked()),
             this, SLOT(accept()) );
}

Protocol::~Protocol()
{
}

void Protocol::getOutput(QStringList cmd)
{
    QStringList::Iterator it = cmd.begin();

    tCmd->clear();

    while( it != cmd.end() )
    {
        tCmd->append(*it);
        it++;
    }
}

