#include <qdatetime.h>


class QString;
class QListViewItem;

struct MetaTag
{
    QString sTitle, sArtist, sAlbum, sGenre, sComment;
    unsigned int iTrack, iYear;
};

enum QualityMode
{
    EQuality, EBitrate, ELossless
};

enum ConversionStep
{
    EEncode, EDecode, EReplayGain
};

struct QualityOptions
{
    QualityMode EMode;
    QString sBitrateMode;
    int iInputBitrate, iOutputBitrate;
    int iLevel;
    bool bRange;
    int iMinBitrate, iMaxBitrate;
};

struct ConvertOptions
{
    bool bEnabled;
    QString sOutputFilename;
    QString sWaveOutputFilename;
    QString sOutputFormat;
    QualityOptions Quality;
};

struct SampleRateOptions
{
    bool bEnabled;
    int iInputSampleRate, iOutputSampleRate;
};

struct ChannelsOptions
{
    bool bEnabled;
    int iInputChannels, iOutputChannels;
};

struct Times
{
    float fDec, fEnc, fRep;
    int iRealLength;
    QTime tTime;
};

struct ProcessState
{
    int iPercent;
    float fPercentTime;
    QString sPercent;
    float fSpeed;
    QString sSpeed;
};

class ProcessOptions
{
public:
    QString sFilename;
    QString sFormat;
    float fLength;
    bool bReplayGain;
    QListViewItem *pItem;
    Times Time;
    MetaTag Tag;
    ConvertOptions Convert;
    SampleRateOptions SampleRate;
    ChannelsOptions Channels;
    ProcessState Process;
    ConversionStep step;
};

extern ProcessOptions actFile;

